/*
 * Decompiled with CFR 0.152.
 */
package owlsmx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import mx.com.hp.hpl.jena.ontology.OntClass;
import mx.com.hp.hpl.jena.ontology.OntModel;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owls.process.ParameterList;
import org.mindswap.owls.service.Service;
import org.mindswap.pellet.TuBox;
import owlsmx.Indexer.SimpleIndex;
import owlsmx.SimilarityMatchmaker;
import owlsmx.data.ConceptServiceRegistry;
import owlsmx.data.DOM;
import owlsmx.data.ExtendedServiceInformation;
import owlsmx.data.InputServiceContainer;
import owlsmx.data.LocalOntologyContainer;
import owlsmx.data.MatchingResult;
import owlsmx.data.OutputServiceContainer;
import owlsmx.data.ServiceInformation;
import owlsmx.exceptions.ConceptNotFoundException;
import owlsmx.exceptions.MatchingException;
import owlsmx.io.ErrorLog;
import owlsmx.reasoning.PelletReasoner;
import owlsmx.similaritymeasures.SimilarityMeasure;
import owlsmx.utils.MatchmakerUtils;

public class OWLSMXMatchmaker
extends SimilarityMatchmaker {
    private OWLKnowledgeBase base = OWLFactory.createKB();
    private LocalOntologyContainer localOntologyContainer = new LocalOntologyContainer();
    private ConceptServiceRegistry registry;
    private PelletReasoner reason;

    private void init(SimilarityMeasure similar) {
        this.reason = new PelletReasoner();
        this.registry = ConceptServiceRegistry.instanceOf();
        this.sim = similar;
    }

    public OWLSMXMatchmaker() {
        this.init(null);
    }

    public OWLSMXMatchmaker(SimilarityMeasure similar) {
        this.init(similar);
    }

    public OWLSMXMatchmaker(short sim) {
        SimilarityMeasure similar = this.switchSimilarityMeasure(sim);
        this.init(similar);
    }

    public String toString() {
        return this.registry.toString();
    }

    public void print() {
        System.err.println(this.getClass().toString());
        System.err.println(this.toString());
    }

    private SortedSet getServicesFromSet(boolean isInput, Set classes, OntClass concept, int degreeOfMatch) throws URISyntaxException, ConceptNotFoundException {
        this.save();
        TreeSet<ExtendedServiceInformation> result = new TreeSet<ExtendedServiceInformation>();
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            RDFNode clazz = (RDFNode)iter.next();
            Set services = this.registry.getServices(isInput, clazz.toString());
            Iterator serviceIterator = services.iterator();
            while (serviceIterator.hasNext()) {
                ServiceInformation info = (ServiceInformation)serviceIterator.next();
                try {
                    if (this.useSyntacticFilter()) {
                        result.add(new ExtendedServiceInformation(info, degreeOfMatch, this.reason.unfoldTerm(clazz)));
                        continue;
                    }
                    result.add(new ExtendedServiceInformation(info, degreeOfMatch, ""));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private SortedSet getServicesForOutputConcept(String concept) throws URISyntaxException, ConceptNotFoundException {
        OntClass clazz = this.localOntologyContainer.getOntClass(concept);
        Set equivalent = this.reason.retrieveEquivalentClasses(clazz);
        Set parents = this.reason.retrieveDirectParentClasses(clazz, equivalent);
        Set ancestors = this.reason.retrieveAncestorClasses(clazz, equivalent, parents);
        Set childs = this.reason.retrieveDirectSubClasses(clazz, equivalent);
        Set decendants = this.reason.retrieveDescendantClasses(clazz, equivalent, childs);
        TreeSet candidates = new TreeSet();
        candidates.addAll(this.getServicesFromSet(false, equivalent, clazz, 0));
        candidates.addAll(this.getServicesFromSet(false, childs, clazz, 1));
        candidates.addAll(this.getServicesFromSet(false, decendants, clazz, 2));
        candidates.addAll(this.getServicesFromSet(false, parents, clazz, 3));
        candidates.addAll(this.getServicesFromSet(false, this.reason.retrieveRemainingClasses(clazz, equivalent, parents, ancestors, childs, decendants), clazz, 4));
        return candidates;
    }

    private SortedSet getServicesForInputConcept(String concept) throws URISyntaxException, ConceptNotFoundException {
        OntClass clazz = this.localOntologyContainer.getOntClass(concept);
        Set equivalent = this.reason.retrieveEquivalentClasses(clazz);
        Set ancestors = this.reason.retrieveAllAncestorClasses(clazz);
        TreeSet candidates = new TreeSet();
        candidates.addAll(this.getServicesFromSet(true, equivalent, clazz, 0));
        candidates.addAll(this.getServicesFromSet(true, ancestors, clazz, 1));
        candidates.addAll(this.getServicesFromSet(true, this.reason.retrieveAllRemainingClasses(clazz, equivalent, ancestors), clazz, 4));
        return candidates;
    }

    private Map getOutputCandidates(Vector outConcepts) throws URISyntaxException, MatchingException {
        if (outConcepts.size() == 0) {
            return this.registry.getAllServices(false);
        }
        OutputServiceContainer resultContainer = new OutputServiceContainer();
        resultContainer.addServices(this.getServicesForOutputConcept(((URI)outConcepts.get(0)).toString()));
        int i = 1;
        while (i < outConcepts.size()) {
            OutputServiceContainer serviceContainer = new OutputServiceContainer();
            serviceContainer.addServices(this.getServicesForOutputConcept(((URI)outConcepts.get(i)).toString()));
            resultContainer.merge(serviceContainer);
            ++i;
        }
        System.out.println("Output candidates: " + resultContainer.getServiceMap().values().toString());
        return resultContainer.getServiceMap();
    }

    private Map addEmptyInputs(Map inputCandidates) {
        Map ServicesWithoutInput = this.registry.getAllServicesWithoutInput();
        Iterator iter = ServicesWithoutInput.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            ExtendedServiceInformation exInfo = (ExtendedServiceInformation)me.getValue();
            inputCandidates.put((Integer)me.getKey(), new ExtendedServiceInformation(exInfo.serviceID, true, exInfo.conceptID, exInfo.noConcepts, 0, 0.0));
        }
        return inputCandidates;
    }

    protected Map getInputCandidates(Vector inConcepts) throws URISyntaxException, ConceptNotFoundException {
        if (inConcepts.size() <= 0) {
            return this.registry.getAllServicesWithoutInput();
        }
        InputServiceContainer inputs = new InputServiceContainer();
        int i = 0;
        while (i < inConcepts.size()) {
            SortedSet sort = this.getServicesForInputConcept(((URI)inConcepts.get(i)).toString());
            inputs.addServices(sort);
            ++i;
        }
        System.out.println("Input candidates: " + inputs.getServices().values().toString());
        return this.addEmptyInputs(inputs.getServices());
    }

    protected Set getServiceInformationFromDOM(Set serviceDOMs) {
        HashSet<ExtendedServiceInformation> result = new HashSet<ExtendedServiceInformation>();
        Iterator iter = serviceDOMs.iterator();
        while (iter.hasNext()) {
            result.add(((DOM)iter.next()).getBestDegree());
        }
        return result;
    }

    private SortedSet inputCandidatesToResult(Map inputCandidates) {
        TreeSet<MatchingResult> result = new TreeSet<MatchingResult>();
        Iterator iter = inputCandidates.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            ExtendedServiceInformation inInfo = (ExtendedServiceInformation)me.getValue();
            result.add(new MatchingResult(inInfo, inInfo.unfoldedconcept, ""));
        }
        return result;
    }

    protected SortedSet semanticMatch(Vector inConcepts, Vector outConcepts) throws URISyntaxException, MatchingException {
        Map input = this.getInputCandidates(inConcepts);
        if (outConcepts == null || outConcepts.size() <= 0) {
            return this.inputCandidatesToResult(input);
        }
        Map output = this.getOutputCandidates(outConcepts);
        TreeSet<MatchingResult> result = new TreeSet<MatchingResult>();
        Iterator iter = input.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            Integer ID = (Integer)me.getKey();
            if (!output.containsKey(ID)) continue;
            ExtendedServiceInformation inInfo = (ExtendedServiceInformation)me.getValue();
            DOM degree = (DOM)output.get(ID);
            ExtendedServiceInformation outInfo = degree.getBestDegree();
            if (inInfo.degreeOfMatch > outInfo.degreeOfMatch || inInfo.degreeOfMatch == outInfo.degreeOfMatch && inInfo.similarity < outInfo.similarity) {
                result.add(new MatchingResult(inInfo, inInfo.unfoldedconcept, outInfo.unfoldedconcept));
                continue;
            }
            result.add(new MatchingResult(outInfo, inInfo.unfoldedconcept, outInfo.unfoldedconcept));
        }
        return result;
    }

    protected SortedSet syntacticFilter(Service queryService, Vector queryInputs, Vector queryOutputs, SortedSet semanticResults) throws TuBox.NotUnfoldableException, URISyntaxException, MatchingException {
        TreeSet<MatchingResult> result = new TreeSet<MatchingResult>();
        String input = this.reason.unfoldURIs(queryInputs);
        String output = this.reason.unfoldURIs(queryOutputs);
        Iterator iter = semanticResults.iterator();
        while (iter.hasNext()) {
            double sim_input = 0.0;
            double sim_output = 0.0;
            MatchingResult info = (MatchingResult)iter.next();
            if (!info.unfoldedInput.equals("")) {
                sim_input = this.sim.computeSimilarity(queryService.getURI().toString(), input, "" + info.serviceID, info.unfoldedInput);
            }
            if (queryOutputs.size() > 0) {
                sim_output = this.sim.computeSimilarity(queryService.getURI().toString(), output, "" + info.serviceID, info.unfoldedOutput);
            }
            info.similarity = (sim_input + sim_output) / 2.0;
            if (info.similarity < this.getSyntacticTreshold()) {
                if (info.degreeOfMatch == 4 || info.degreeOfMatch == 3) {
                    info.degreeOfMatch = 5;
                    continue;
                }
                result.add(info);
                continue;
            }
            result.add(info);
        }
        return result;
    }

    public void addService(Integer integer, URI profileURI) {
        try {
            OWLOntology onto = this.base.read(profileURI);
            Service service = onto.getService();
            this.addService(integer, onto, MatchmakerUtils.getURIList((ParameterList)service.getProfile().getInputs()), MatchmakerUtils.getURIList((ParameterList)service.getProfile().getOutputs()));
        }
        catch (FileNotFoundException e) {
            ErrorLog.instanceOf().report(String.valueOf(this.getClass().toString()) + "|addService: Could not add service from this URI" + profileURI.toString());
            e.printStackTrace();
        }
        this.base.unload(profileURI);
    }

    private void updateReasoner() {
        this.reason.clear();
        this.reason.load((Model)((OntModel)this.localOntologyContainer.getOntology().getImplementation()));
    }

    private void addService(Integer serviceID, OWLOntology onto, Vector inputurilist, Vector outputurilist) {
        try {
            HashSet conceptsToAdd = new HashSet();
            conceptsToAdd.addAll(inputurilist);
            conceptsToAdd.addAll(outputurilist);
            this.localOntologyContainer.processClasses(this.base, conceptsToAdd);
            this.updateReasoner();
            if (this.useSyntacticFilter()) {
                SimpleIndex.instanceOf().addDocument("" + serviceID, String.valueOf(this.reason.unfoldURIs(inputurilist)) + " " + this.reason.unfoldURIs(outputurilist));
            }
            this.registry.addConcepts(true, (int)serviceID, inputurilist);
            this.registry.addConcepts(false, (int)serviceID, outputurilist);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SortedSet matchRequest(URI profileURI) throws MatchingException {
        try {
            OWLOntology onto = this.base.read(profileURI);
            Service service = onto.getService();
            Vector inputurilist = MatchmakerUtils.getURIList((ParameterList)service.getProfile().getInputs());
            Vector outputurilist = MatchmakerUtils.getURIList((ParameterList)service.getProfile().getOutputs());
            HashSet conceptsToAdd = new HashSet();
            conceptsToAdd.addAll(inputurilist);
            conceptsToAdd.addAll(outputurilist);
            this.localOntologyContainer.processClasses(this.base, conceptsToAdd);
            this.updateReasoner();
            this.base.unload(profileURI);
            if (this.useSyntacticFilter()) {
                SimpleIndex.instanceOf().addDocument(service.getURI().toString(), String.valueOf(this.reason.unfoldURIs(inputurilist)) + " " + this.reason.unfoldURIs(outputurilist));
                return this.syntacticFilter(service, inputurilist, outputurilist, this.semanticMatch(inputurilist, outputurilist));
            }
            return this.semanticMatch(inputurilist, outputurilist);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MatchingException(e.toString());
        }
    }

    public void removeService(Integer integer) {
        this.registry.removeService(integer);
    }

    public boolean load() {
        try {
            boolean result = LocalOntologyContainer.load();
            File file = new File("registry.data");
            if (file.exists()) {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
                this.registry = (ConceptServiceRegistry)in.readObject();
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorLog.instanceOf().report(e.toString());
            return false;
        }
    }

    public boolean save() {
        try {
            boolean result = this.localOntologyContainer.save();
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("registry.data"));
            out.writeObject(this.registry);
            out.close();
            return result;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void clear() {
        File file = new File("registry.data");
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File("localOntology.owl")).exists()) {
            file.delete();
        }
        ConceptServiceRegistry.instanceOf().clear();
        SimpleIndex.instanceOf().clear();
    }

    public void enableProfileHierarchies(boolean speedyButProblematic) {
        if (speedyButProblematic) {
            OWLConfig.setStrictConversion((boolean)false);
        } else {
            this.base.setReasoner("RDFS");
        }
    }

    public void disableProfileHierarchies() {
        this.base.setReasoner(null);
        OWLConfig.setStrictConversion((boolean)true);
    }
}

