/*
 * Decompiled with CFR 0.152.
 */
package owlsmx;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import owlsmx.MatchingEngine;
import owlsmx.OWLSMXMatchmaker;
import owlsmx.data.MatchedService;
import owlsmx.data.MatchingResult;
import owlsmx.exceptions.MatchingException;
import owlsmx.io.ErrorLog;
import owlsmx.similaritymeasures.SimilarityMeasure;

public class SimilarityMatchingEngine
implements MatchingEngine {
    private Map advertisedServices = new HashMap();
    private OWLSMXMatchmaker matcher = null;
    private LinkedList newKeys;
    public static final boolean debug = false;

    public String printServiceRegistry() {
        String result = "Lokal Services: \n";
        TreeSet keys = new TreeSet(this.advertisedServices.keySet());
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Integer me = (Integer)iter.next();
            result = String.valueOf(result) + " " + me + " - " + ((URI)this.advertisedServices.get(me)).toString() + "\n";
        }
        return result;
    }

    private void init() {
        this.newKeys = new LinkedList();
        int i = 1;
        while (i < 6) {
            this.newKeys.addLast(new Integer(i));
            ++i;
        }
    }

    public SimilarityMatchingEngine() {
        this.matcher = new OWLSMXMatchmaker();
        this.init();
    }

    public SimilarityMatchingEngine(SimilarityMeasure sim) {
        this.matcher = new OWLSMXMatchmaker(sim);
        this.init();
    }

    public SimilarityMatchingEngine(short sim) throws MatchingException {
        this.matcher = new OWLSMXMatchmaker(sim);
        this.init();
    }

    private Integer getNewKey() {
        Integer integer = (Integer)this.newKeys.getFirst();
        this.newKeys.removeFirst();
        this.newKeys.addLast(new Integer((Integer)this.newKeys.getLast() + 1));
        return integer;
    }

    private void removeKey(Integer key) {
        this.newKeys.addFirst(key);
    }

    public void addService(URI profileURI) {
        if (!this.advertisedServices.containsKey(profileURI)) {
            try {
                Integer ID = this.getNewKey();
                this.advertisedServices.put(ID, profileURI);
                this.matcher.addService(ID, profileURI);
            }
            catch (Exception e) {
                System.out.println("Service failed " + profileURI.toString());
                e.printStackTrace();
            }
        }
    }

    private void removeService(Integer ID) {
        if (this.advertisedServices.containsKey(ID)) {
            this.advertisedServices.remove(ID);
            this.removeKey(ID);
            this.matcher.removeService(ID);
        }
    }

    public void removeService(URI uri) {
        Iterator iter = this.advertisedServices.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            if (!((URI)me.getValue()).equals(uri)) continue;
            this.removeService((Integer)me.getKey());
            return;
        }
    }

    private boolean shouldPruneService(MatchedService service, int minimumDegreeOfMatch, double treshold) {
        if (service.degreeOfMatch > minimumDegreeOfMatch) {
            ErrorLog.instanceOf().report("Had to skip (" + service.serviceURI + "/" + service.degreeOfMatch + "/" + service.similarity + ") Degree of service " + service.degreeOfMatch + ">" + minimumDegreeOfMatch);
            return true;
        }
        if (this.matcher.sim == null || this.matcher.sim.getSimilarityType() == -1) {
            return service.degreeOfMatch >= 4;
        }
        if (service.degreeOfMatch == 4 && service.similarity < treshold) {
            ErrorLog.instanceOf().report("Had to skip (" + service.serviceURI + "/" + service.degreeOfMatch + "/" + service.similarity + ") Sim of service " + service.similarity + "<" + treshold);
            return true;
        }
        if (service.degreeOfMatch == 3 && service.similarity < treshold) {
            ErrorLog.instanceOf().report("Had to skip (" + service.serviceURI + "/" + service.degreeOfMatch + "/" + service.similarity + ") Sim of service " + service.similarity + "<" + treshold);
            return true;
        }
        return false;
    }

    public SortedSet matchRequest(URI profileURI, int minimumDegreeOfMatch, double treshold) throws MatchingException {
        double synTr = this.matcher.getSyntacticTreshold();
        double tresh = treshold;
        if (this.matcher.sim == null || this.matcher.sim.getSimilarityType() == -1) {
            ErrorLog.instanceOf().report("Reset treshold to 0.0 as syntactic matching is used");
            tresh = 0.0;
        }
        this.matcher.setSyntacticTreshold(tresh);
        TreeSet<MatchedService> result = new TreeSet<MatchedService>();
        SortedSet OWLSMXResult = this.matchRequest(profileURI);
        Iterator iter = OWLSMXResult.iterator();
        while (iter.hasNext()) {
            MatchedService entry = (MatchedService)iter.next();
            if (this.shouldPruneService(entry, minimumDegreeOfMatch, treshold)) continue;
            result.add(entry);
        }
        this.matcher.setSyntacticTreshold(synTr);
        return result;
    }

    public SortedSet matchRequest(URI profileURI) throws MatchingException {
        try {
            TreeSet<MatchedService> Matchingresult = new TreeSet<MatchedService>();
            SortedSet result = this.matcher.matchRequest(profileURI);
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                MatchingResult entry = (MatchingResult)iter.next();
                if (!this.advertisedServices.containsKey(new Integer(entry.serviceID))) continue;
                URI uri = new URI(((URI)this.advertisedServices.get(new Integer(entry.serviceID))).toString());
                Matchingresult.add(new MatchedService(entry, uri));
            }
            return Matchingresult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new TreeSet();
        }
    }

    public boolean save() {
        boolean result = this.save("");
        return result;
    }

    public boolean save(String targetpath) {
        try {
            FileWriter writer = new FileWriter(String.valueOf(targetpath) + "Services.map", false);
            Iterator iter = this.advertisedServices.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry me = iter.next();
                writer.write("(" + me.getKey() + ";" + me.getValue() + ")\n");
            }
            writer.close();
            return this.matcher.save();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean load() {
        boolean result = this.load("");
        return result;
    }

    private boolean load(String path) {
        try {
            String line;
            this.advertisedServices.clear();
            BufferedReader reader = new BufferedReader(new FileReader(String.valueOf(path) + "Services.map"));
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                String[] tokens = (line = line.substring(line.indexOf("(") + 1, line.lastIndexOf(")"))).split(";");
                if (tokens.length < 2) continue;
                this.advertisedServices.put(new Integer(tokens[0]), new URI(tokens[1]));
            }
            reader.close();
            return this.matcher.load();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setSimilarityMeasure(SimilarityMeasure sim) {
        this.matcher.setSimilarityMeasure(sim);
    }

    public void setSimilarityMeasure(short sim) {
        this.matcher.setSimilarityMeasure(sim);
    }

    public void clear() {
        this.matcher.clear();
    }

    public void print() {
        System.out.println(this.getClass().toString());
        this.printServiceRegistry();
        this.matcher.print();
    }

    public void enableProfileHierarchies(boolean speedyButProblematic) {
        this.matcher.enableProfileHierarchies(speedyButProblematic);
    }

    public void disableProfileHierarchies() {
        this.matcher.disableProfileHierarchies();
    }

    public String toString() {
        return String.valueOf(this.printServiceRegistry()) + "\n" + this.matcher.toString();
    }
}

