/*
 * Decompiled with CFR 0.152.
 */
package owlsmx;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.SortedSet;
import owlsmx.Indexer.SimpleIndex;
import owlsmx.Matchmaker;
import owlsmx.exceptions.MatchingException;
import owlsmx.similaritymeasures.ConstraintSimilarity;
import owlsmx.similaritymeasures.CosineSimilarity;
import owlsmx.similaritymeasures.ExtendedJaccardMeasure;
import owlsmx.similaritymeasures.JensenShannonMeasure;
import owlsmx.similaritymeasures.SimilarityMeasure;

public abstract class SimilarityMatchmaker
implements Matchmaker {
    public static final short EXACT = 0;
    public static final short PLUGIN = 1;
    public static final short SUBSUMES = 2;
    public static final short SUBSUMED_BY = 3;
    public static final short NEAREST_NEIGHBOUR = 4;
    public static final short FAIL = 5;
    protected double similarityTreshold = 0.001;
    protected SimilarityMeasure sim;

    public abstract void addService(Integer var1, URI var2);

    public abstract void removeService(Integer var1);

    public abstract SortedSet matchRequest(URI var1) throws URISyntaxException, MatchingException;

    public abstract boolean load();

    public abstract boolean save();

    public abstract void clear();

    public void setSyntacticTreshold(double treshold) {
        this.similarityTreshold = treshold;
    }

    public double getSyntacticTreshold() {
        return this.similarityTreshold;
    }

    protected SimilarityMeasure getSimilarityMeasure() {
        return this.sim;
    }

    public int getSimilarityMeasureType() {
        if (this.sim != null) {
            return this.sim.getSimilarityType();
        }
        return -1;
    }

    public void setSimilarityMeasure(short similarity) {
        this.sim = this.switchSimilarityMeasure(similarity);
    }

    public void setSimilarityMeasure(SimilarityMeasure sim) {
        this.sim = this.switchSimilarityMeasure(sim.getSimilarityType());
    }

    protected SimilarityMeasure switchSimilarityMeasure(short similarity) {
        if (similarity == -1) {
            SimpleIndex.instanceOf().clear();
            return null;
        }
        if (similarity == 3) {
            return new JensenShannonMeasure(this.sim);
        }
        if (similarity == 2) {
            return new CosineSimilarity(this.sim);
        }
        if (similarity == 1) {
            return new ExtendedJaccardMeasure(this.sim);
        }
        return new ConstraintSimilarity(this.sim);
    }

    protected boolean useSyntacticFilter() {
        return this.sim != null && this.sim.getSimilarityType() != -1;
    }
}

