/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.analysis;

import java.util.ArrayList;
import java.util.List;
import owlsmx.analysis.RecallPrecisionPair;

public class RecallPrecision {
    public static final double SIGMA = 0.01;
    public static final int LEMDA_LEVELS = 20;
    public static final double[] RECALL_LEVELS = new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public double[] PRECISION_LEVEL_SUM = new double[RECALL_LEVELS.length];
    public int[] LEVEL_RELEVANT_SUM = new int[20];
    public int[] LEVEL_RETRIEVED_SUM = new int[20];
    private int querySize = 0;
    private double MaxRecall = 0.0;
    private int ALL_RELEVANT_SUM = 0;

    public int getQuerySize() {
        return this.querySize;
    }

    public double[] processRecallPrecision(List retrievals, ArrayList correctRetrievals) {
        ++this.querySize;
        double[] interPrecisions = new double[this.PRECISION_LEVEL_SUM.length];
        this.MaxRecall = 0.0;
        ArrayList Precisions = this.evalRetrievals(retrievals, correctRetrievals);
        this.ALL_RELEVANT_SUM += correctRetrievals.size();
        if (this.MaxRecall > 0.0) {
            interPrecisions = this.interpolatePrecision(Precisions);
            int i = 0;
            while (i < interPrecisions.length) {
                int n = i;
                this.PRECISION_LEVEL_SUM[n] = this.PRECISION_LEVEL_SUM[n] + interPrecisions[i];
                ++i;
            }
            this.MicroEvalRetrievals(retrievals, correctRetrievals);
        }
        return interPrecisions;
    }

    public double[] getAveragePrecisionAtElevenPoints() {
        double[] result = new double[this.PRECISION_LEVEL_SUM.length];
        int i = 0;
        while (i < this.PRECISION_LEVEL_SUM.length) {
            result[i] = this.PRECISION_LEVEL_SUM[i] / (double)this.getQuerySize();
            ++i;
        }
        this.smoothRPcurve(result);
        return result;
    }

    public ArrayList getMicroAveragePrecisions() {
        System.out.println("ALL Relevant Sum: " + this.ALL_RELEVANT_SUM);
        ArrayList<RecallPrecisionPair> rpList = new ArrayList<RecallPrecisionPair>();
        int i = 0;
        while (i < this.LEVEL_RELEVANT_SUM.length) {
            double recall = (double)this.LEVEL_RELEVANT_SUM[i] / (double)this.ALL_RELEVANT_SUM;
            double precision = 0.0;
            if (this.LEVEL_RELEVANT_SUM[i] > 0) {
                precision = (double)this.LEVEL_RELEVANT_SUM[i] / (double)this.LEVEL_RETRIEVED_SUM[i];
            }
            rpList.add(new RecallPrecisionPair(recall, precision));
            System.out.println("At lemda " + (i + 1) + " LEVEL_RELEVANT_SUM: " + this.LEVEL_RELEVANT_SUM[i] + " LEVEL_RETRIEVED_SUM: " + this.LEVEL_RETRIEVED_SUM[i] + " precision " + (double)this.LEVEL_RELEVANT_SUM[i] / (double)this.LEVEL_RETRIEVED_SUM[i]);
            ++i;
        }
        return rpList;
    }

    private ArrayList evalRetrievals(List retrievals, ArrayList correctRetrievals) {
        ArrayList<RecallPrecisionPair> rpList = new ArrayList<RecallPrecisionPair>();
        double goodRetrievals = 0.0;
        int i = 0;
        while (i < retrievals.size()) {
            int numRetrieved = i + 1;
            if (correctRetrievals.contains(retrievals.get(i))) {
                double recall = (goodRetrievals += 1.0) / (double)correctRetrievals.size();
                double precision = goodRetrievals / (double)numRetrieved;
                rpList.add(new RecallPrecisionPair(recall, precision));
                this.MaxRecall = recall;
            }
            ++i;
        }
        return rpList;
    }

    private void MicroEvalRetrievals(List retrievals, ArrayList correctRetrievals) {
        int[] LEVEL_RELEVANT = new int[20];
        int[] LEVEL_RETRIEVED = new int[20];
        double slot = this.MaxRecall / 20.0;
        double[] T_RECALL_LEVELS = new double[20];
        int num = 0;
        if (this.MaxRecall > 0.5) {
            T_RECALL_LEVELS[0] = 0.1;
            num = 1;
        }
        while (num < T_RECALL_LEVELS.length) {
            T_RECALL_LEVELS[num] = (double)Math.round(slot * (double)(num + 1) * 100.0) / 100.0;
            ++num;
        }
        int lemda = 0;
        double goodRetrievals = 0.0;
        int i = 0;
        while (i < retrievals.size()) {
            int numRetrieved = i + 1;
            if (correctRetrievals.contains(retrievals.get(i))) {
                double recall = (goodRetrievals += 1.0) / (double)correctRetrievals.size();
                double checkRecall = (double)Math.round(recall * 100.0) / 100.0;
                if (lemda >= T_RECALL_LEVELS.length) {
                    lemda = T_RECALL_LEVELS.length - 1;
                }
                if (checkRecall == T_RECALL_LEVELS[lemda] || checkRecall >= T_RECALL_LEVELS[lemda] - 0.01 && checkRecall <= T_RECALL_LEVELS[lemda] + 0.01) {
                    LEVEL_RELEVANT[lemda] = (int)goodRetrievals;
                    LEVEL_RETRIEVED[lemda] = numRetrieved;
                    ++lemda;
                } else if (checkRecall > T_RECALL_LEVELS[lemda]) {
                    while (checkRecall > T_RECALL_LEVELS[lemda] + 0.01 && lemda < T_RECALL_LEVELS.length - 1) {
                        if (goodRetrievals > 1.0) {
                            LEVEL_RELEVANT[lemda] = (int)goodRetrievals;
                            LEVEL_RETRIEVED[lemda] = numRetrieved;
                        }
                        ++lemda;
                    }
                    LEVEL_RELEVANT[lemda] = (int)goodRetrievals;
                    LEVEL_RETRIEVED[lemda] = numRetrieved;
                }
            }
            ++i;
        }
        i = 0;
        while (i < LEVEL_RELEVANT.length) {
            int n = i;
            this.LEVEL_RELEVANT_SUM[n] = this.LEVEL_RELEVANT_SUM[n] + LEVEL_RELEVANT[i];
            int n2 = i;
            this.LEVEL_RETRIEVED_SUM[n2] = this.LEVEL_RETRIEVED_SUM[n2] + LEVEL_RETRIEVED[i];
            ++i;
        }
    }

    private double[] interpolatePrecision(ArrayList rpPairs) {
        double[] precisions = new double[RECALL_LEVELS.length];
        int i = RECALL_LEVELS.length - 1;
        while (i >= 0) {
            double maxPrecision = 0.0;
            int j = 0;
            while (j < rpPairs.size()) {
                RecallPrecisionPair rpPair = (RecallPrecisionPair)rpPairs.get(j);
                if (RECALL_LEVELS[i] <= rpPair.recall && (i == RECALL_LEVELS.length - 1 || rpPair.recall <= RECALL_LEVELS[i + 1]) && rpPair.precision > maxPrecision) {
                    maxPrecision = rpPair.precision;
                }
                ++j;
            }
            if (i < RECALL_LEVELS.length - 1 && precisions[i + 1] > maxPrecision) {
                maxPrecision = precisions[i + 1];
            }
            precisions[i] = maxPrecision;
            --i;
        }
        return precisions;
    }

    private void smoothRPcurve(double[] precisions) {
        int i = precisions.length - 1;
        while (i >= 0) {
            double maxPrecision = precisions[i];
            if (i < precisions.length - 1 && precisions[i + 1] > precisions[i]) {
                maxPrecision = precisions[i + 1];
            }
            precisions[i] = maxPrecision;
            --i;
        }
    }
}

