/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.data;

import owlsmx.data.DegreeOfMatch;
import owlsmx.data.ExtendedServiceInformation;
import owlsmx.exceptions.MatchingException;
import owlsmx.io.ErrorLog;

public class DOM
extends DegreeOfMatch {
    public ExtendedServiceInformation plugin;
    public ExtendedServiceInformation subsumedBy;

    DOM() {
        this.plugin = new ExtendedServiceInformation(0, false, 0, 2, 5, 0.0);
        this.subsumedBy = new ExtendedServiceInformation(0, false, 0, 2, 5, 0.0);
    }

    public DOM(ExtendedServiceInformation exInfo) {
        this.plugin = exInfo;
        this.subsumedBy = exInfo;
    }

    boolean isExact() {
        return this.plugin.degreeOfMatch == 0;
    }

    boolean isPlugin() {
        return this.plugin.degreeOfMatch == 1;
    }

    boolean isSubsumes() {
        return this.plugin.degreeOfMatch == 2;
    }

    boolean isSubsumedBy() {
        return this.subsumedBy.degreeOfMatch == 3;
    }

    boolean isNearestNeighbour() {
        return this.plugin.degreeOfMatch == 4;
    }

    boolean isFail() {
        return false;
    }

    public void mergeService(ExtendedServiceInformation info) {
        if (this.plugin == null) {
            this.plugin = info;
        }
        if (this.subsumedBy == null) {
            this.subsumedBy = info;
        }
        if (this.plugin.serviceID != info.serviceID || this.subsumedBy.serviceID != info.serviceID) {
            return;
        }
        if (this.plugin.degreeOfMatch == 0) {
            return;
        }
        if (info.degreeOfMatch == 0) {
            this.plugin = info;
            this.subsumedBy = info;
            return;
        }
        if (info.degreeOfMatch == 3) {
            if (this.subsumedBy.similarity < info.similarity) {
                this.subsumedBy = info;
            }
            return;
        }
        if (info.degreeOfMatch < this.plugin.degreeOfMatch || info.degreeOfMatch == this.plugin.degreeOfMatch && info.similarity > this.plugin.similarity) {
            this.plugin = info;
        }
        if (info.degreeOfMatch == 4) {
            if (info.degreeOfMatch < this.subsumedBy.degreeOfMatch || info.degreeOfMatch == this.subsumedBy.degreeOfMatch && info.similarity > this.subsumedBy.similarity) {
                this.subsumedBy = info;
            }
            return;
        }
    }

    public ExtendedServiceInformation getBestDegree() {
        if (this.isExact() || this.isPlugin() || this.isSubsumes()) {
            return this.plugin;
        }
        if (this.isSubsumedBy()) {
            return this.subsumedBy;
        }
        return this.plugin;
    }

    public ExtendedServiceInformation getPlugin() {
        return this.plugin;
    }

    public ExtendedServiceInformation getSubsumedBy() {
        return this.subsumedBy;
    }

    public void mergeDOM(DOM dom) throws MatchingException {
        if (!this.plugin.containsUnfoldedInformation() || !this.subsumedBy.containsUnfoldedInformation()) {
            ErrorLog.instanceOf().report("Couldn't find unfolding information (" + !this.plugin.containsUnfoldedInformation() + "|" + !this.subsumedBy.containsUnfoldedInformation() + ")");
        }
        ExtendedServiceInformation plugin_candidate = dom.getPlugin();
        ExtendedServiceInformation subsumed_by_candidate = dom.getSubsumedBy();
        if (dom.isExact()) {
            this.plugin.addUnfoldedInformation(plugin_candidate.unfoldedconcept);
            this.subsumedBy.addUnfoldedInformation(plugin_candidate.unfoldedconcept);
            return;
        }
        if (plugin_candidate.degreeOfMatch == 4 || subsumed_by_candidate.degreeOfMatch == 4) {
            if (plugin_candidate.degreeOfMatch < subsumed_by_candidate.degreeOfMatch) {
                this.plugin.degreeOfMatch = subsumed_by_candidate.degreeOfMatch;
                this.subsumedBy.degreeOfMatch = subsumed_by_candidate.degreeOfMatch;
                this.plugin.addUnfoldedInformation(subsumed_by_candidate.unfoldedconcept);
                this.subsumedBy.addUnfoldedInformation(subsumed_by_candidate.unfoldedconcept);
            } else {
                this.plugin.degreeOfMatch = plugin_candidate.degreeOfMatch;
                this.subsumedBy.degreeOfMatch = plugin_candidate.degreeOfMatch;
                this.plugin.addUnfoldedInformation(plugin_candidate.unfoldedconcept);
                this.subsumedBy.addUnfoldedInformation(plugin_candidate.unfoldedconcept);
            }
            return;
        }
        if ((this.plugin.degreeOfMatch == 1 || this.plugin.degreeOfMatch == 2) && plugin_candidate.degreeOfMatch == 3 || (plugin_candidate.degreeOfMatch == 1 || plugin_candidate.degreeOfMatch == 2) && this.plugin.degreeOfMatch == 3) {
            this.plugin.degreeOfMatch = 4;
            this.plugin.addUnfoldedInformation(plugin_candidate.unfoldedconcept);
            this.subsumedBy.addUnfoldedInformation(plugin_candidate.unfoldedconcept);
            return;
        }
        if (this.plugin.degreeOfMatch < plugin_candidate.degreeOfMatch) {
            this.plugin.degreeOfMatch = plugin_candidate.degreeOfMatch;
            this.plugin.addUnfoldedInformation(plugin_candidate.unfoldedconcept);
        }
        if (this.subsumedBy.degreeOfMatch < subsumed_by_candidate.degreeOfMatch) {
            this.subsumedBy.degreeOfMatch = subsumed_by_candidate.degreeOfMatch;
        }
        this.subsumedBy.addUnfoldedInformation(subsumed_by_candidate.unfoldedconcept);
    }

    public String toString() {
        return this.getBestDegree().toString();
    }
}

