/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.data;

import owlsmx.data.ServiceInformation;
import owlsmx.utils.MatchmakerUtils;

public class ExtendedServiceInformation
extends ServiceInformation
implements Comparable {
    public int degreeOfMatch;
    public double similarity = 0.0;
    public String unfoldedconcept = "";

    public ExtendedServiceInformation(int serviceID, boolean isInput, int conceptID, int noConcepts, int degreeOfMatch, double similarity) {
        super(serviceID, isInput, conceptID, noConcepts);
        this.degreeOfMatch = degreeOfMatch;
        this.similarity = similarity;
    }

    public void setSimilarity(double sim) {
        this.similarity = sim;
    }

    public void setDegreeOfMatch(int dom) {
        this.degreeOfMatch = dom;
    }

    public ExtendedServiceInformation(ServiceInformation info, int degreeOfMatch) {
        super(info.serviceID, info.isInput, info.conceptID, info.noConcepts);
        this.degreeOfMatch = degreeOfMatch;
    }

    public ExtendedServiceInformation(ServiceInformation info, int degreeOfMatch, double similarity) {
        super(info.serviceID, info.isInput, info.conceptID, info.noConcepts);
        this.degreeOfMatch = degreeOfMatch;
        this.similarity = similarity;
    }

    public ExtendedServiceInformation(ServiceInformation info, int degreeOfMatch, String unfoldedconcept) {
        super(info.serviceID, info.isInput, info.conceptID, info.noConcepts);
        this.degreeOfMatch = degreeOfMatch;
        this.unfoldedconcept = unfoldedconcept;
    }

    public void addUnfoldedInformation(String unfoldedConcept) {
        this.unfoldedconcept = String.valueOf(this.unfoldedconcept) + " " + unfoldedConcept.trim();
        this.unfoldedconcept = this.unfoldedconcept.trim();
    }

    public boolean containsUnfoldedInformation() {
        return this.unfoldedconcept != "";
    }

    public int compareTo(Object obj2) {
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == obj2) {
            return 0;
        }
        ExtendedServiceInformation service = (ExtendedServiceInformation)obj2;
        if (this.serviceID == service.serviceID && this.conceptID == service.conceptID && this.noConcepts == service.noConcepts && this.isInput == service.isInput && this.degreeOfMatch == service.degreeOfMatch && this.similarity == service.similarity) {
            return 0;
        }
        if (this.serviceID == service.serviceID && this.noConcepts == service.noConcepts && this.degreeOfMatch == service.degreeOfMatch && this.similarity == service.similarity && this.isInput == service.isInput && this.conceptID < service.conceptID) {
            return -1;
        }
        if (this.degreeOfMatch == service.degreeOfMatch && this.similarity == service.similarity && this.isInput == service.isInput && this.serviceID < service.serviceID) {
            return -1;
        }
        if (this.degreeOfMatch < service.degreeOfMatch || this.degreeOfMatch == service.degreeOfMatch && this.similarity > service.similarity) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        return "(S-ID (" + this.serviceID + "), C-ID (" + this.conceptID + "), " + this.noConcepts + ", isInput(" + this.isInput + "), " + MatchmakerUtils.degreeOfMatchIntToString(this.degreeOfMatch) + ", sim (" + this.similarity + ") )";
    }
}

