/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import owlsmx.data.ExtendedServiceInformation;

public class InputServiceContainer {
    Map services = new HashMap();

    private void addService(Integer ID, ExtendedServiceInformation exInfo) {
        SortedSet set = (SortedSet)this.services.get(ID);
        Vector<ExtendedServiceInformation> remove = new Vector<ExtendedServiceInformation>();
        Iterator iter = set.iterator();
        boolean add = true;
        while (iter.hasNext()) {
            ExtendedServiceInformation existingInfo = (ExtendedServiceInformation)iter.next();
            if (existingInfo.conceptID != exInfo.conceptID) continue;
            if (existingInfo.degreeOfMatch > exInfo.degreeOfMatch) {
                remove.add(existingInfo);
                continue;
            }
            add = false;
        }
        set.removeAll(remove);
        if (add) {
            set.add(exInfo);
        }
        this.services.put(ID, set);
    }

    public void addServices(SortedSet servicesInformations) {
        Iterator iter = servicesInformations.iterator();
        while (iter.hasNext()) {
            ExtendedServiceInformation exInfo = (ExtendedServiceInformation)iter.next();
            Integer ID = new Integer(exInfo.serviceID);
            if (this.services.containsKey(ID)) {
                this.addService(ID, exInfo);
                continue;
            }
            TreeSet<ExtendedServiceInformation> set = new TreeSet<ExtendedServiceInformation>();
            set.add(exInfo);
            this.services.put(ID, set);
        }
    }

    private boolean isRelevant(SortedSet extendedServiceInformations) {
        Iterator iter = extendedServiceInformations.iterator();
        HashSet<Integer> concepts = new HashSet<Integer>();
        int size = 0;
        while (iter.hasNext()) {
            ExtendedServiceInformation exInfo = (ExtendedServiceInformation)iter.next();
            size = exInfo.noConcepts;
            concepts.add(new Integer(exInfo.conceptID));
        }
        if (concepts.size() == size) {
            return true;
        }
        if (concepts.size() > size) {
            System.out.println("ERROR: more concepts relevant than should exist");
            return true;
        }
        return false;
    }

    private ExtendedServiceInformation getBestDegree(SortedSet extendedServiceInformations) {
        ExtendedServiceInformation mainInfo;
        ExtendedServiceInformation exInfo;
        HashMap<Integer, ExtendedServiceInformation> potentialResult = new HashMap<Integer, ExtendedServiceInformation>();
        Iterator<Object> iter = extendedServiceInformations.iterator();
        while (iter.hasNext()) {
            exInfo = (ExtendedServiceInformation)iter.next();
            Integer conceptID = new Integer(exInfo.conceptID);
            if (!potentialResult.containsKey(conceptID)) {
                potentialResult.put(conceptID, exInfo);
            }
            mainInfo = (ExtendedServiceInformation)potentialResult.get(conceptID);
            if (mainInfo.degreeOfMatch <= exInfo.degreeOfMatch) continue;
            potentialResult.put(conceptID, exInfo);
        }
        iter = potentialResult.entrySet().iterator();
        mainInfo = new ExtendedServiceInformation(0, true, 0, 3, 0, 1.0);
        while (iter.hasNext()) {
            Map.Entry me = (Map.Entry)iter.next();
            exInfo = (ExtendedServiceInformation)me.getValue();
            mainInfo.addUnfoldedInformation(exInfo.unfoldedconcept);
            if (mainInfo.degreeOfMatch > exInfo.degreeOfMatch) continue;
            mainInfo = exInfo;
        }
        return mainInfo;
    }

    public Map getServices() {
        HashMap<Integer, ExtendedServiceInformation> result = new HashMap<Integer, ExtendedServiceInformation>();
        Iterator iter = this.services.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            TreeSet set = (TreeSet)me.getValue();
            if (!this.isRelevant(set)) continue;
            ExtendedServiceInformation exInfo = this.getBestDegree(set);
            result.put(new Integer(exInfo.serviceID), exInfo);
        }
        return result;
    }
}

