/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.data;

import java.net.URI;
import owlsmx.data.ExtendedServiceInformation;
import owlsmx.data.MatchingResult;
import owlsmx.data.ServiceEntry;
import owlsmx.utils.MatchmakerUtils;

public class MatchedService
implements Comparable {
    public URI serviceURI;
    public int serviceID;
    public int degreeOfMatch;
    public double similarity;

    MatchedService(int serviceID, URI serviceURI, int degreeOfMatch, double similarity) {
        this.serviceID = serviceID;
        this.serviceURI = serviceURI;
        this.degreeOfMatch = degreeOfMatch;
        this.similarity = similarity;
    }

    MatchedService(ExtendedServiceInformation exInfo) {
        this.serviceID = exInfo.serviceID;
        this.degreeOfMatch = exInfo.degreeOfMatch;
        this.similarity = exInfo.similarity;
    }

    MatchedService(MatchingResult exInfo) {
        this.serviceID = exInfo.serviceID;
        this.degreeOfMatch = exInfo.degreeOfMatch;
        this.similarity = exInfo.similarity;
    }

    public MatchedService(MatchingResult exInfo, URI serviceURI) {
        this.serviceID = exInfo.serviceID;
        this.degreeOfMatch = exInfo.degreeOfMatch;
        this.similarity = exInfo.similarity;
        this.serviceURI = serviceURI;
    }

    MatchedService(ExtendedServiceInformation exInfo, URI serviceURI) {
        this.serviceID = exInfo.serviceID;
        this.degreeOfMatch = exInfo.degreeOfMatch;
        this.similarity = exInfo.similarity;
        this.serviceURI = serviceURI;
    }

    MatchedService(ServiceEntry entry, URI serviceURI) {
        this.serviceID = entry.ID;
        this.degreeOfMatch = entry.degreeOfMatch;
        this.similarity = entry.similarity;
        this.serviceURI = entry.uri;
    }

    public void setURI(URI serviceURI) {
        this.serviceURI = serviceURI;
    }

    public String toString() {
        return "(S-ID (" + this.serviceID + "), " + MatchmakerUtils.degreeOfMatchIntToString(this.degreeOfMatch) + ", SIM(" + this.similarity + ", " + this.serviceURI + " )";
    }

    public int compareTo(Object obj2) {
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == obj2) {
            return 0;
        }
        MatchedService service = (MatchedService)obj2;
        if (this.serviceID == service.serviceID && this.degreeOfMatch == service.degreeOfMatch && this.similarity == service.similarity) {
            return 0;
        }
        if (this.degreeOfMatch < service.degreeOfMatch || this.degreeOfMatch == service.degreeOfMatch && this.similarity > service.similarity) {
            return -1;
        }
        return 1;
    }
}

