/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.data;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import owlsmx.data.ServiceEntry;
import owlsmx.utils.MatchmakerUtils;

public class ServiceConcept {
    private Map outputservices = new HashMap();
    private Map inputservices = new HashMap();

    public void add(boolean input, ServiceEntry service) {
        if (input) {
            this.addInput(service);
        } else {
            this.addOutput(service);
        }
    }

    public void forceAdd(boolean input, ServiceEntry service) {
        Integer id = new Integer(service.ID);
        if (input) {
            this.inputservices.put(id, service);
        } else {
            this.outputservices.put(id, service);
        }
    }

    public void addInput(ServiceEntry service) {
        Integer id = new Integer(service.ID);
        if (this.inputservices.containsKey(id) && service.smallerThan(this.inputservices.get(id))) {
            return;
        }
        this.inputservices.put(id, service);
    }

    public void addOutput(ServiceEntry service) {
        Integer id = new Integer(service.ID);
        if (this.outputservices.containsKey(id) && service.smallerThan(this.outputservices.get(id))) {
            return;
        }
        this.outputservices.put(id, service);
    }

    public TreeSet getOutputs() {
        return new TreeSet(MatchmakerUtils.mapToSortedSet(this.outputservices));
    }

    public TreeSet getInputs() {
        return new TreeSet(MatchmakerUtils.mapToSortedSet(this.inputservices));
    }

    public void removeService(int id) {
        Integer Id = new Integer(id);
        this.outputservices.remove(Id);
        this.inputservices.remove(Id);
    }

    public void resetSimilarity() {
        ServiceEntry entry;
        Map.Entry me;
        Iterator iter = this.outputservices.entrySet().iterator();
        while (iter.hasNext()) {
            me = iter.next();
            entry = (ServiceEntry)me.getValue();
            entry.resetSimilarity();
        }
        iter = this.inputservices.entrySet().iterator();
        while (iter.hasNext()) {
            me = iter.next();
            entry = (ServiceEntry)me.getValue();
            entry.resetSimilarity();
        }
    }
}

