/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.examples;

import java.io.File;
import java.net.URI;
import java.util.Iterator;
import java.util.SortedSet;
import owlsmx.SimilarityMatchingEngine;
import owlsmx.data.MatchedService;
import owlsmx.similaritymeasures.ConstraintSimilarity;
import owlsmx.similaritymeasures.CosineSimilarity;
import owlsmx.similaritymeasures.ExtendedJaccardMeasure;
import owlsmx.similaritymeasures.JensenShannonMeasure;
import owlsmx.similaritymeasures.SimilarityMeasure;

public class CommandLineMatching {
    private static SimilarityMatchingEngine engine;
    private static URI request;
    private static Integer matchingType;
    private static Integer minDegree;
    private static Double minSim;
    private static File services;

    static {
        minDegree = new Integer(5);
        minSim = new Double(0.0);
    }

    private static void fail(String message) {
        System.out.println(message);
        System.out.println("Example usage:");
        System.out.println("java -jar matching.jar [RequestURI|URI] [ServicesPath|String] [MatchingType|Int] [minDegree|Int] [minSim|Double] ");
    }

    private static void addServices(File serviceDirectory) {
        if (!serviceDirectory.isDirectory()) {
            return;
        }
        File[] files = serviceDirectory.listFiles();
        int max = files.length;
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                System.out.println("[ADD] " + (i + 1) + "/" + max + " " + files[i].toString());
                engine.addService(files[i].toURI());
            } else {
                System.out.println("[ADD] " + (i + 1) + "/" + max + " Is a directory, not a file");
            }
            ++i;
        }
    }

    private static SimilarityMeasure getSimilarityMeasure(int i) {
        switch (i) {
            case 1: {
                return new ConstraintSimilarity();
            }
            case 2: {
                return new ExtendedJaccardMeasure();
            }
            case 3: {
                return new CosineSimilarity();
            }
            case 4: {
                return new JensenShannonMeasure();
            }
        }
        return null;
    }

    private static void printResult(SortedSet result) {
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            MatchedService service = (MatchedService)iter.next();
            System.out.println(service.toString());
        }
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            CommandLineMatching.fail("Too few arguments");
            return;
        }
        try {
            request = new URI(args[0]);
            matchingType = new Integer(args[2]);
            engine = new SimilarityMatchingEngine(CommandLineMatching.getSimilarityMeasure(matchingType));
            engine.load();
            services = args[1].toLowerCase().startsWith("file") ? new File(new URI(args[1])) : new File(args[1]);
            if (!services.isDirectory()) {
                CommandLineMatching.fail("Path to services must be a directory but was " + args[1]);
                return;
            }
            if (args.length > 3) {
                minDegree = new Integer(args[3]);
            }
            if (args.length > 4) {
                minSim = new Double(args[4]);
            }
        }
        catch (Exception e) {
            CommandLineMatching.fail(e.toString());
            return;
        }
        if (services.isDirectory()) {
            CommandLineMatching.addServices(services);
        }
        try {
            SortedSet result = engine.matchRequest(request, minDegree, minSim);
            CommandLineMatching.printResult(result);
        }
        catch (Exception e) {
            CommandLineMatching.fail(e.toString());
        }
        engine.clear();
    }
}

