/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.examples;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import owlsmx.SimilarityMatchingEngine;
import owlsmx.analysis.MemoryContainer;
import owlsmx.analysis.PassedTime;
import owlsmx.analysis.RecallPrecision;
import owlsmx.data.MatchedService;
import owlsmx.exceptions.MatchingException;
import owlsmx.similaritymeasures.ConstraintSimilarity;

public class PerformanceMeasurement {
    static String servicePath = "L:\\Webserver\\xampp\\htdocs\\services\\1.1";
    static String serverServicePath = "http://127.0.0.1/services/1.1/";
    static String relevantForQueryDocument = "D:\\Diplomarbeit\\Services\\TC2005-03-16\\AllServices\\relevant\\q";
    static String queryPath = "L:\\Webserver\\xampp\\htdocs\\queries\\1.1";
    static String queryServerPath = "http://127.0.0.1/queries/1.1/";
    static String relevantPath = "L:\\Webserver\\xampp\\htdocs\\relevant";
    static Vector log = new Vector();
    static boolean logging = true;
    static String similarityMeasure = "";
    static int count = 200;
    static int queries = 30;
    static FileWriter stream;

    public static void log(String text) {
        try {
            stream.write(String.valueOf(text) + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (logging) {
            log.add(text);
        }
    }

    public static int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public static boolean isValidFile(File files) {
        return files.getAbsolutePath().toLowerCase().endsWith("owls");
    }

    public static void storeLog() {
        Date today = new Date();
        try {
            FileWriter writer = new FileWriter("Results" + similarityMeasure + count + ".data", false);
            writer.write("Performance Measurement " + today.toString() + "\n");
            int i = 0;
            while (i < log.size()) {
                writer.write(String.valueOf((String)log.get(i)) + "\n");
                ++i;
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Vector getServiceURIsFromDirectory(String services) throws URISyntaxException {
        Vector result = new Vector();
        TreeSet<URI> temporary = new TreeSet<URI>();
        File dir = new File(servicePath);
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile() && PerformanceMeasurement.isValidFile(files[i])) {
                temporary.add(new URI(String.valueOf(serverServicePath) + files[i].getName()));
            }
            ++i;
        }
        Iterator iter = temporary.iterator();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public static ArrayList getRelevantForQuery(URI query) throws IOException, URISyntaxException {
        ArrayList<String> result = new ArrayList<String>();
        String relevantName = query.toString();
        relevantName = String.valueOf(relevantName.substring(relevantName.lastIndexOf("/"), relevantName.lastIndexOf("."))) + ".txt";
        File relevant = new File(String.valueOf(relevantPath) + "\\" + relevantName);
        BufferedReader reader = new BufferedReader(new FileReader(relevant));
        String line = "";
        PerformanceMeasurement.log("Relevant for query " + query.toString());
        while ((line = reader.readLine()) != null) {
            if (line == "") continue;
            PerformanceMeasurement.log(line);
            result.add(line.trim());
        }
        reader.close();
        return result;
    }

    public static Vector getQueryURIsFromDirectory() throws URISyntaxException {
        Vector<URI> result = new Vector<URI>();
        File[] files = new File(queryPath).listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().indexOf(".owls") >= 0) {
                result.add(new URI(String.valueOf(queryServerPath) + files[i].getName()));
            }
            ++i;
        }
        return result;
    }

    public static void parseCandidates(SimilarityMatchingEngine engine, Vector services, int count) throws Exception {
        long current = System.currentTimeMillis();
        if (count > services.size()) {
            count = services.size();
        }
        int i = 0;
        while (i < count) {
            if (i % 10 == 0) {
                MemoryContainer.getInstance().addState(i);
            }
            System.out.println("[ADD] " + (i + 1) + "/" + count + ((URI)services.get(i)).toString());
            engine.addService((URI)services.get(i));
            ++i;
        }
        current = System.currentTimeMillis() - current;
        long msperservice = current / (long)services.size();
        System.out.println("Parsed " + services.size() + " in " + current + " ms (" + msperservice + "msPerService)");
    }

    public static void printMap(Map map, boolean just_values) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            if (just_values) {
                PerformanceMeasurement.log(((Double)me.getValue()).toString());
                continue;
            }
            PerformanceMeasurement.log(String.valueOf(((Integer)me.getKey()).toString()) + " - " + ((Double)me.getValue()).toString());
        }
    }

    public static void wait(int seconds) {
        System.gc();
        try {
            Thread.sleep(1000 * seconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static SortedMap getAveragePrecisionFromRPVector(Vector results) {
        TreeMap<Integer, Double> rpcurve = new TreeMap<Integer, Double>();
        int i = 0;
        while (i < results.size()) {
            double[] queryresult = (double[])results.get(i);
            int j = 0;
            while (j < queryresult.length) {
                Integer key = new Integer(j);
                Double value = rpcurve.containsKey(key) ? new Double(queryresult[j] + (double)((Double)rpcurve.get(key)).floatValue()) : new Double(queryresult[j]);
                rpcurve.put(key, value);
                ++j;
            }
            ++i;
        }
        TreeMap result = new TreeMap();
        Iterator iter = rpcurve.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            result.put(me.getKey(), new Double(((Double)me.getValue()).floatValue() / (float)results.size() * 100.0f));
        }
        return result;
    }

    public static ArrayList sortedSetToArrayList(SortedSet set, int query) {
        ArrayList<String> array = new ArrayList<String>();
        Iterator iter = set.iterator();
        String name = "";
        while (iter.hasNext()) {
            MatchedService service = (MatchedService)iter.next();
            name = service.serviceURI.toString();
            PerformanceMeasurement.log(query + " - " + service.toString());
            array.add(name.substring(name.lastIndexOf("/") + 1));
        }
        return array;
    }

    public static void logDoubleArray(double[] var) {
        int i = 0;
        while (i < var.length) {
            PerformanceMeasurement.log("0." + i + " " + var[i]);
            ++i;
        }
    }

    public static void logRecallResult(ArrayList result) {
        int i = 0;
        while (i < result.size()) {
            PerformanceMeasurement.log("" + result.get(i));
            ++i;
        }
    }

    public static ArrayList query(SimilarityMatchingEngine engine, URI queryURI, int query, boolean isM0) throws MatchingException {
        if (!isM0) {
            ArrayList result = PerformanceMeasurement.sortedSetToArrayList(engine.matchRequest(queryURI), query);
            System.out.println(result);
            return result;
        }
        return PerformanceMeasurement.sortedSetToArrayList(engine.matchRequest(queryURI, 3, 0.0), query);
    }

    public static void performTest(SimilarityMatchingEngine engine, String service_number, short similarity_measure, boolean isM0) throws Exception {
        engine.setSimilarityMeasure(similarity_measure);
        RecallPrecision recall = new RecallPrecision();
        Vector results = new Vector();
        Vector queryVector = PerformanceMeasurement.getQueryURIsFromDirectory();
        long query = System.currentTimeMillis();
        int max = PerformanceMeasurement.min(queries, queryVector.size());
        int i = 0;
        while (i < max) {
            URI queryURI = (URI)queryVector.get(i);
            System.out.println("Query " + (i + 1) + "/" + max + ": " + queryURI.toString());
            PerformanceMeasurement.log("Query " + (i + 1) + "/" + max + ": " + queryURI.toString());
            ArrayList relevant = PerformanceMeasurement.getRelevantForQuery((URI)queryVector.get(i));
            ArrayList list = PerformanceMeasurement.query(engine, queryURI, i, isM0);
            PerformanceMeasurement.logDoubleArray(recall.processRecallPrecision(list, relevant));
            ++i;
        }
        query = System.currentTimeMillis() - query;
        long querytime = query / (long)queries;
        long memory_queries = PerformanceMeasurement.getMemory();
        PerformanceMeasurement.log("Total:");
        PerformanceMeasurement.log("");
        PerformanceMeasurement.log("Total Query processing time " + query + "ms");
        PerformanceMeasurement.log("Average Query processing time " + querytime + "ms");
        PerformanceMeasurement.log("Memory consumption after querying " + memory_queries + "bytes");
        PerformanceMeasurement.log("");
        PerformanceMeasurement.log("RP-New");
        PerformanceMeasurement.logRecallResult(recall.getMicroAveragePrecisions());
        PerformanceMeasurement.log("");
        PerformanceMeasurement.log("RP-Old");
        PerformanceMeasurement.logDoubleArray(recall.getAveragePrecisionAtElevenPoints());
        PerformanceMeasurement.printMap(PerformanceMeasurement.getAveragePrecisionFromRPVector(results), false);
    }

    public static long getMemory2() {
        return Runtime.getRuntime().totalMemory();
    }

    public static long getMemory() {
        System.out.println("Total Memory: " + Runtime.getRuntime().totalMemory());
        System.out.println("Free  Memory: " + Runtime.getRuntime().freeMemory());
        System.out.println("Used  Memory: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        System.out.println("");
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static void main(String[] args) {
        try {
            stream = new FileWriter(new File("test.dat"));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            MemoryContainer.getInstance().setGUIMemory();
            ConstraintSimilarity loi = new ConstraintSimilarity();
            long memory_before = PerformanceMeasurement.getMemory();
            String service_number = "AllServices";
            Vector services = PerformanceMeasurement.getServiceURIsFromDirectory(service_number);
            long parsing = System.currentTimeMillis();
            SimilarityMatchingEngine engine = new SimilarityMatchingEngine(loi);
            PerformanceMeasurement.parseCandidates(engine, services, count);
            parsing = System.currentTimeMillis() - parsing;
            long averageparsing = parsing / (long)services.size();
            PerformanceMeasurement.wait(2);
            PerformanceMeasurement.getMemory();
            PerformanceMeasurement.log("Total Parsing processing time " + parsing + "ms");
            PerformanceMeasurement.log("Average Parsing processing time " + averageparsing + "ms");
            long memory_parsed = PerformanceMeasurement.getMemory();
            PerformanceMeasurement.log("Memory consumption before parsing ads " + memory_before + "bytes");
            PerformanceMeasurement.log("Memory consumption after parsing ads " + memory_parsed + "bytes");
            PerformanceMeasurement.log("");
            PerformanceMeasurement.log("");
            PassedTime.start();
            PerformanceMeasurement.log("START Similarity Measure: LOI");
            PerformanceMeasurement.performTest(engine, service_number, (short)0, false);
            PerformanceMeasurement.log("END Similarity Measure: LOI");
            PerformanceMeasurement.log("");
            PerformanceMeasurement.log("");
            PerformanceMeasurement.log("" + PassedTime.getTime("LOI: "));
            System.out.println("");
            System.out.println("");
            System.out.println("");
            System.out.println("");
            System.out.println("Waiting for some more seconds for memory measurement");
            PerformanceMeasurement.wait(20);
            PerformanceMeasurement.log("Final memory " + PerformanceMeasurement.getMemory());
            PerformanceMeasurement.log("");
            PerformanceMeasurement.log(MemoryContainer.getInstance().toString());
            PerformanceMeasurement.storeLog();
            stream.close();
            System.out.println("Matching test complete, stored in Results" + similarityMeasure + count + ".data");
            System.out.println(MemoryContainer.getInstance().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

