/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import owlsmx.gui.DisplayService;
import owlsmx.gui.ShowPanelFrame;
import owlsmx.gui.data.HybridServiceItem;
import owlsmx.gui.data.Query;
import owlsmx.gui.data.SemanticServiceItem;
import owlsmx.gui.data.ServiceItem;
import owlsmx.gui.data.SyntacticServiceItem;
import owlsmx.gui.data.TestCollection;
import owlsmx.gui.util.GUIState;
import owlsmx.gui.util.SortingMethod;
import owlsmx.gui.util.UpdateDataListener;
import owlsmx.gui.util.Utils;
import owlsmx.gui.util.filefilter.ResultFilter;

public class AnswerSet
extends JPanel
implements UpdateDataListener,
ActionListener,
ItemListener,
TreeSelectionListener {
    protected int sort = 0;
    protected JButton explain;
    protected JButton queryDetails;
    protected JScrollPane queryInputScrollPane;
    protected JList queryInputs;
    protected JLabel queryInputsLabel;
    protected JLabel queryLabel;
    protected JTextField queryName;
    protected JList queryOutputs;
    protected JLabel queryOutputsLabel;
    protected JScrollPane queryOutputsScrollPane;
    protected JTree result;
    protected JLabel resultLabel;
    protected JScrollPane resultScrollPane;
    protected JButton save;
    protected JButton serviceDetails;
    protected JList serviceInputs;
    protected JLabel serviceInputsLabel;
    protected JScrollPane serviceInputsScrollPane;
    protected JLabel serviceLabel;
    protected JTextField serviceName;
    protected JList serviceOutputs;
    protected JLabel serviceOutputsLabel;
    protected JScrollPane serviceOutputsScrollPane;
    protected JComboBox sortingMethod;
    private DefaultListModel serviceInputsDataModel = new DefaultListModel();
    private DefaultListModel serviceOutputsDataModel = new DefaultListModel();
    private DefaultListModel queryInputsDataModel = new DefaultListModel();
    private DefaultListModel queryOutputsDataModel = new DefaultListModel();
    private Map resultSet = new HashMap();
    private JFileChooser fc = new JFileChooser();
    protected static final long serialVersionUID = 1L;

    public AnswerSet() {
        this.initComponents();
        this.updateData();
    }

    public AnswerSet(Set result) {
        this.initComponents();
    }

    private void setSorting(int sort) {
        int i = 0;
        while (i < this.sortingMethod.getItemCount()) {
            if (((SortingMethod)this.sortingMethod.getItemAt(i)).getSortingMethod() == sort) {
                this.sortingMethod.setSelectedIndex(i);
            }
            ++i;
        }
    }

    public AnswerSet(Set result, int sorting) {
        this.initComponents();
        this.setSorting(sorting);
    }

    public AnswerSet(Set result, SortingMethod sort) {
        this.initComponents();
        this.setSorting(sort.getSortingMethod());
    }

    protected void initComponents() {
        this.resultScrollPane = new JScrollPane();
        this.result = new JTree();
        this.result.addTreeSelectionListener(this);
        this.resultLabel = new JLabel();
        this.queryName = new JTextField();
        this.queryLabel = new JLabel();
        this.queryInputScrollPane = new JScrollPane();
        this.queryInputs = new JList();
        this.queryOutputsScrollPane = new JScrollPane();
        this.queryOutputs = new JList();
        this.queryInputsLabel = new JLabel();
        this.queryOutputsLabel = new JLabel();
        this.serviceLabel = new JLabel();
        this.serviceName = new JTextField();
        this.serviceInputsScrollPane = new JScrollPane();
        this.serviceInputs = new JList();
        this.serviceOutputsScrollPane = new JScrollPane();
        this.serviceOutputs = new JList();
        this.serviceInputsLabel = new JLabel();
        this.serviceOutputsLabel = new JLabel();
        this.queryDetails = new JButton();
        this.serviceDetails = new JButton();
        this.save = new JButton();
        this.explain = new JButton();
        this.sortingMethod = new JComboBox();
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.setMinimumSize(new Dimension(650, 450));
        this.setPreferredSize(new Dimension(650, 450));
        this.resultScrollPane.setViewportView(this.result);
        this.add((Component)this.resultScrollPane, new AbsoluteConstraints(10, 50, 280, 310));
        this.resultLabel.setText("Answer set");
        this.add((Component)this.resultLabel, new AbsoluteConstraints(10, 0, 140, -1));
        this.add((Component)this.queryName, new AbsoluteConstraints(300, 20, 330, -1));
        this.queryLabel.setText("Query");
        this.add((Component)this.queryLabel, new AbsoluteConstraints(300, 0, 80, -1));
        this.queryInputScrollPane.setViewportView(this.queryInputs);
        this.add((Component)this.queryInputScrollPane, new AbsoluteConstraints(300, 60, 160, 120));
        this.queryOutputsScrollPane.setViewportView(this.queryOutputs);
        this.add((Component)this.queryOutputsScrollPane, new AbsoluteConstraints(480, 60, 160, 120));
        this.queryInputsLabel.setText("Inputs");
        this.add((Component)this.queryInputsLabel, new AbsoluteConstraints(300, 40, 180, 20));
        this.queryOutputsLabel.setText("Outputs");
        this.add((Component)this.queryOutputsLabel, new AbsoluteConstraints(480, 40, 150, 20));
        this.serviceLabel.setText("Service");
        this.add((Component)this.serviceLabel, new AbsoluteConstraints(300, 180, 80, -1));
        this.add((Component)this.serviceName, new AbsoluteConstraints(300, 200, 330, -1));
        this.serviceInputsScrollPane.setViewportView(this.serviceInputs);
        this.add((Component)this.serviceInputsScrollPane, new AbsoluteConstraints(300, 240, 150, 120));
        this.serviceOutputsScrollPane.setViewportView(this.serviceOutputs);
        this.add((Component)this.serviceOutputsScrollPane, new AbsoluteConstraints(480, 240, 150, 120));
        this.serviceInputsLabel.setText("Inputs");
        this.add((Component)this.serviceInputsLabel, new AbsoluteConstraints(300, 220, 160, 20));
        this.serviceOutputsLabel.setText("Ouputs");
        this.add((Component)this.serviceOutputsLabel, new AbsoluteConstraints(480, 220, 160, 20));
        this.sortingMethod.addItem(new SortingMethod(2));
        this.sortingMethod.addItem(new SortingMethod(1));
        this.sortingMethod.addItem(new SortingMethod(0));
        this.sortingMethod.addItemListener(this);
        this.sortingMethod.setSelectedIndex(this.sortingMethod.getItemCount() - 1);
        this.add((Component)this.sortingMethod, new AbsoluteConstraints(10, 20, 280, 20));
        Dimension dim = new Dimension(800, 400);
        this.setSize(dim);
        this.setMinimumSize(dim);
        this.queryDetails.setText("Querydetails");
        this.queryDetails.addActionListener(this);
        this.add((Component)this.queryDetails, new AbsoluteConstraints(490, 365, 140, -1));
        this.serviceDetails.setText("Servicedetails");
        this.serviceDetails.addActionListener(this);
        this.add((Component)this.serviceDetails, new AbsoluteConstraints(330, 365, 140, -1));
        this.save.setText("Save");
        this.save.addActionListener(this);
        this.add((Component)this.save, new AbsoluteConstraints(170, 365, 140, -1));
        this.explain.setText("Explain");
        this.explain.setEnabled(false);
        this.explain.addActionListener(this);
        this.add((Component)this.explain, new AbsoluteConstraints(10, 365, 140, -1));
        this.fc.addChoosableFileFilter(new ResultFilter());
    }

    private void prepareServicesForQuery(DefaultMutableTreeNode queryNode, SortedSet services) {
        Iterator serviceIterator = services.iterator();
        if (this.sort == 0 || this.sort == 1) {
            DefaultMutableTreeNode[] nodes = new DefaultMutableTreeNode[]{new DefaultMutableTreeNode("Exact"), new DefaultMutableTreeNode("Plugin"), new DefaultMutableTreeNode("Subsumes"), new DefaultMutableTreeNode("Subsumed-By"), new DefaultMutableTreeNode("Nearest Neighbour"), new DefaultMutableTreeNode("Fail")};
            while (serviceIterator.hasNext()) {
                if (this.sort == 0) {
                    HybridServiceItem hItem = (HybridServiceItem)serviceIterator.next();
                    nodes[hItem.getDegreeOfMatch()].add(new DefaultMutableTreeNode(hItem));
                    continue;
                }
                SemanticServiceItem sItem = (SemanticServiceItem)serviceIterator.next();
                if (sItem.getDegreeOfMatch() == 4) {
                    sItem.setDegreeOfMatch(5);
                }
                nodes[sItem.getDegreeOfMatch()].add(new DefaultMutableTreeNode(sItem));
            }
            int i = 0;
            while (i < nodes.length) {
                if (nodes[i].getChildCount() > 0) {
                    queryNode.add(nodes[i]);
                    String tmp = nodes[i].getUserObject().toString();
                    int count = nodes[i].getChildCount();
                    nodes[i].setUserObject(String.valueOf(tmp) + " (" + count + ")");
                }
                ++i;
            }
            return;
        }
        serviceIterator = services.iterator();
        while (serviceIterator.hasNext()) {
            SyntacticServiceItem synItem = (SyntacticServiceItem)serviceIterator.next();
            queryNode.add(new DefaultMutableTreeNode(synItem));
        }
    }

    public void updateData() {
        this.result.removeAll();
        this.resultSet = TestCollection.getInstance().getMatchmakerAnswerset(this.sort);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Result");
        DefaultTreeModel model = new DefaultTreeModel(root);
        Iterator iter = this.resultSet.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            DefaultMutableTreeNode node = new DefaultMutableTreeNode((Query)me.getKey());
            root.add(node);
            if (((SortedSet)me.getValue()).size() <= 0) continue;
            this.prepareServicesForQuery(node, (SortedSet)me.getValue());
        }
        this.result.setModel(model);
    }

    public void itemStateChanged(ItemEvent event) {
        if (event.getSource().equals(this.sortingMethod)) {
            this.sort = ((SortingMethod)this.sortingMethod.getSelectedItem()).getSortingMethod();
            GUIState.getInstance().setSorting(this.sort);
            this.updateData();
        }
    }

    private void displayQuery(Query query) {
        if (query == null) {
            return;
        }
        this.queryName.setText(query.getName());
        this.queryInputsDataModel.removeAllElements();
        Iterator iter = query.getInputs().iterator();
        while (iter.hasNext()) {
            this.queryInputsDataModel.addElement(Utils.getConcept((URI)iter.next(), true));
        }
        this.queryInputs.setModel(this.queryInputsDataModel);
        this.queryOutputsDataModel.removeAllElements();
        iter = query.getOutputs().iterator();
        while (iter.hasNext()) {
            this.queryOutputsDataModel.addElement(Utils.getConcept((URI)iter.next(), true));
        }
        this.queryOutputs.setModel(this.queryOutputsDataModel);
    }

    private void displayService(ServiceItem service) {
        if (service == null) {
            return;
        }
        this.serviceName.setText(service.getName());
        this.serviceInputsDataModel.removeAllElements();
        Iterator iter = service.getInputs().iterator();
        while (iter.hasNext()) {
            this.serviceInputsDataModel.addElement(Utils.getConcept((URI)iter.next(), true));
        }
        this.serviceInputs.setModel(this.serviceInputsDataModel);
        this.serviceOutputsDataModel.removeAllElements();
        iter = service.getOutputs().iterator();
        while (iter.hasNext()) {
            this.serviceOutputsDataModel.addElement(Utils.getConcept((URI)iter.next(), true));
        }
        this.serviceOutputs.setModel(this.serviceOutputsDataModel);
    }

    private Query getQuery() {
        TreePath path = this.result.getSelectionPath();
        if (path == null || path.getPathCount() <= 1) {
            return null;
        }
        return (Query)((DefaultMutableTreeNode)path.getPathComponent(1)).getUserObject();
    }

    private ServiceItem getService() {
        TreePath path = this.result.getSelectionPath();
        if (path == null || path.getPathCount() < 3) {
            return null;
        }
        if (path.getPathCount() > 3 || path.getPathCount() > 2 && this.sort == 2) {
            return (ServiceItem)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        }
        return null;
    }

    private ServiceItem getService(TreePath path) {
        if (path == null || path.getPathCount() < 3) {
            return null;
        }
        if (path.getPathCount() > 3 || path.getPathCount() > 2 && this.sort == 2) {
            return (ServiceItem)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        }
        return null;
    }

    private Set getServices() {
        HashSet<ServiceItem> res = new HashSet<ServiceItem>();
        TreePath[] paths = this.result.getSelectionPaths();
        int i = 0;
        while (i < paths.length) {
            ServiceItem service = this.getService(paths[i]);
            if (service != null) {
                res.add(service);
            }
            ++i;
        }
        return res;
    }

    public void valueChanged(TreeSelectionEvent event) {
        this.displayQuery(this.getQuery());
        this.displayService(this.getService());
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.queryDetails)) {
            EventQueue.invokeLater(new ShowPanelFrame(new DisplayService(this.getQuery()), false));
        } else if (event.getSource().equals(this.serviceDetails)) {
            Iterator iter = this.getServices().iterator();
            while (iter.hasNext()) {
                ServiceItem service = (ServiceItem)iter.next();
                if (service == null) continue;
                EventQueue.invokeLater(new ShowPanelFrame(new DisplayService(service), false));
            }
        } else if (event.getSource().equals(this.save)) {
            if (this.fc.showSaveDialog(this) == 0) {
                this.saveResult(this.fc.getSelectedFile().getAbsolutePath());
            }
        } else if (event.getSource().equals(this.explain)) {
            GUIState.displayWarning("Not yet implemented", "Sorry the explanation component is not yet implemented");
        }
    }

    private void saveResult(String path) {
        try {
            if (!path.toLowerCase().endsWith(".res")) {
                path = String.valueOf(path) + ".res";
            }
            BufferedWriter output = new BufferedWriter(new FileWriter(new File(path)));
            int queries = 1;
            int counter = 1;
            Iterator iter = this.resultSet.keySet().iterator();
            while (iter.hasNext()) {
                Query query = (Query)iter.next();
                String uri = query.getURI().toString();
                if (uri.contains("/")) {
                    uri = uri.substring(uri.lastIndexOf("/") + 1);
                }
                String write = "Query " + queries + " " + uri;
                output.write(write);
                output.newLine();
                Iterator answerSet = ((SortedSet)this.resultSet.get(query)).iterator();
                while (answerSet.hasNext()) {
                    HybridServiceItem item = (HybridServiceItem)answerSet.next();
                    String s_uri = item.getURI().toString();
                    if (s_uri.contains("/")) {
                        s_uri = s_uri.substring(s_uri.lastIndexOf("/") + 1);
                    }
                    String result_count = counter < 10 ? "0" + counter : "" + counter;
                    write = String.valueOf(result_count) + "  (" + item.getDegreeOfMatch() + "," + item.getSyntacticSimilarity() + ") " + s_uri + "\n";
                    output.write(write);
                    output.newLine();
                    ++counter;
                }
                counter = 1;
                ++queries;
            }
            output.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

