/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import owlsmx.gui.AboutDialog;
import owlsmx.gui.MatchmakerGUI;
import owlsmx.gui.RelevanceSet;
import owlsmx.gui.Requests;
import owlsmx.gui.Result;
import owlsmx.gui.ResultVisualization;
import owlsmx.gui.Services;
import owlsmx.gui.Settings;
import owlsmx.gui.ShowPanelFrame;
import owlsmx.gui.TaskGUI;
import owlsmx.gui.TestCollectionGUI;
import owlsmx.gui.Testing;
import owlsmx.gui.data.TestCollection;
import owlsmx.gui.util.GUIState;
import owlsmx.gui.util.UpdateDataListener;

public class BaseWindow
extends JFrame
implements ActionListener,
UpdateDataListener {
    private JButton Exit;
    private JTextPane Helptext;
    private JButton Last;
    private JButton Next;
    private JButton ShowWizard;
    private JLabel Step;
    private JTabbedPane Tabs;
    private JPanel Wizard;
    private static final long serialVersionUID = 1L;
    private TestCollectionGUI gui_tc = new TestCollectionGUI();
    private Services gui_services = new Services();
    private Requests gui_queries = new Requests();
    private MatchmakerGUI gui_mm = new MatchmakerGUI();
    private Testing gui_td = new Testing();
    private Result gui_rr = new Result();
    private ResultVisualization gui_rv = new ResultVisualization();
    private TaskGUI gui_intro = new TaskGUI(this);
    private Settings gui_settings = new Settings(this);
    private RelevanceSet gui_as = new RelevanceSet();
    private int taskIndex;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenu menuHelp;
    private JMenu menuWizard;
    private JMenu menuAbout;
    private JMenuItem item_about;
    private JMenuItem file_item_settings;
    private JMenuItem file_item_quit;
    private JMenuItem wizard_item_show;
    private static final boolean wizardIsActivated = false;
    private static final boolean helpIsActivated = false;

    public BaseWindow() {
        this.initComponents();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints grid_constraints = new GridBagConstraints();
        grid_constraints.fill = 2;
        grid_constraints.gridx = 0;
        grid_constraints.gridy = 1;
        this.Tabs = new JTabbedPane();
        this.Wizard = new JPanel();
        this.Next = new JButton();
        this.Last = new JButton();
        this.Exit = new JButton();
        this.Helptext = new JTextPane();
        this.Step = new JLabel();
        this.ShowWizard = new JButton();
        this.setDefaultCloseOperation(3);
        this.Tabs.setMinimumSize(new Dimension(800, 450));
        this.Tabs.setPreferredSize(new Dimension(800, 450));
        this.getContentPane().add((Component)this.Tabs, grid_constraints);
        grid_constraints.gridx = 0;
        grid_constraints.gridy = 2;
        this.Wizard.setLayout(null);
        this.Wizard.setBackground(new Color(255, 255, 255));
        this.Wizard.setBorder(new EtchedBorder());
        this.Wizard.setMinimumSize(new Dimension(800, 100));
        this.Wizard.setPreferredSize(new Dimension(800, 100));
        this.Next.setActionCommand("Next");
        this.Next.setText("Next");
        this.Next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUIState.getInstance().setNextStep();
            }
        });
        this.Wizard.add(this.Next);
        this.Next.setBounds(5, 5, 75, 23);
        this.Last.setText("Back");
        this.Last.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUIState.getInstance().setLastStep();
                BaseWindow.this.updateWizard();
            }
        });
        this.Wizard.add(this.Last);
        this.Last.setBounds(5, 35, 75, 23);
        this.Exit.setText("Hide");
        this.Exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BaseWindow.this.ExitActionPerformed(evt);
            }
        });
        this.Wizard.add(this.Exit);
        this.Exit.setBounds(5, 65, 75, 23);
        this.Helptext.setBorder(null);
        this.Helptext.setFont(new Font("MS Sans Serif", 0, 10));
        this.Helptext.setText("In this step you should add services as advertisements to the matchmaker. You can either add an entire predefined testcollection, an entire local directory or single services.");
        this.Helptext.setMaximumSize(new Dimension(Integer.MAX_VALUE, 80));
        this.Helptext.setMinimumSize(new Dimension(510, 80));
        this.Helptext.setPreferredSize(new Dimension(510, 80));
        this.Wizard.add(this.Helptext);
        this.Helptext.setBounds(90, 20, 510, 70);
        this.Step.setFont(new Font("Arial", 0, 14));
        this.Step.setText("Step 2/5 Matchmaker");
        this.Step.setVerticalAlignment(1);
        this.Step.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.Step.setMinimumSize(new Dimension(510, 20));
        this.Step.setPreferredSize(new Dimension(510, 20));
        this.Wizard.add(this.Step);
        this.Step.setBounds(90, 5, 510, 15);
        this.getContentPane().add((Component)this.Wizard, grid_constraints);
        this.ShowWizard.setText("Show Wizard");
        this.ShowWizard.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.ShowWizard.setMinimumSize(new Dimension(590, 25));
        this.ShowWizard.setOpaque(false);
        this.ShowWizard.setPreferredSize(new Dimension(590, 25));
        this.ShowWizard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BaseWindow.this.ShowWizardActionPerformed(evt);
            }
        });
        this.pack();
        this.setTitle("OWLS-MX:   Hybrid OWL-S Service Matchmaker   v1.1b");
        grid_constraints = new GridBagConstraints();
        grid_constraints.fill = 2;
        grid_constraints.gridx = 0;
        grid_constraints.gridy = 0;
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu("File");
        this.file_item_settings = new JMenuItem("Settings");
        this.file_item_settings.addActionListener(this);
        this.file_item_settings.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        this.menuFile.add(this.file_item_settings);
        this.file_item_quit = new JMenuItem("Quit");
        this.file_item_quit.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        this.file_item_quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUIState.save();
                BaseWindow.this.dispose();
            }
        });
        this.menuFile.add(this.file_item_quit);
        this.menuFile.getAccessibleContext().setAccessibleDescription("File operations, settings and quit");
        this.menuBar.add(this.menuFile);
        this.menuHelp = new JMenu("Help");
        this.menuHelp.getAccessibleContext().setAccessibleDescription("Help");
        this.menuHelp.add(new JMenuItem("Test collection"));
        this.menuHelp.add(new JMenuItem("Matchmaker"));
        this.menuHelp.add(new JMenuItem("Settings"));
        this.item_about = new JMenuItem("About");
        this.item_about.addActionListener(this);
        this.menuAbout = new JMenu("About");
        this.menuAbout.add(this.item_about);
        this.menuBar.add(this.menuAbout);
        this.menuWizard = new JMenu("Wizard");
        this.wizard_item_show = new JMenuItem("Show Wizard");
        this.wizard_item_show.addActionListener(this);
        this.wizard_item_show.setAccelerator(KeyStroke.getKeyStroke(87, 8));
        this.menuWizard.add(this.wizard_item_show);
        this.add((Component)this.menuBar, grid_constraints);
        this.Tabs.addTab("Services", this.gui_services);
        this.Tabs.addTab("Requests", this.gui_queries);
        this.Tabs.addTab("Relevance set", this.gui_as);
        this.Tabs.addTab("Test collection", this.gui_tc);
        this.Tabs.addTab("Matchmaker", this.gui_mm);
        this.Tabs.addTab("Testing", this.gui_td);
        this.Tabs.addTab("Answer set", this.gui_rr);
        this.Tabs.addTab("Result", this.gui_rv);
        this.taskIndex = this.Tabs.indexOfTab("Task");
        this.Wizard.setVisible(false);
        TestCollection.getInstance().registerUpdateDataListener(this);
        this.pack();
    }

    private void ShowWizardActionPerformed(ActionEvent evt) {
        this.showWizard();
    }

    private void ExitActionPerformed(ActionEvent evt) {
        this.hideWizard();
    }

    private boolean containsComponent(JTabbedPane tabs, Component component) {
        Component[] comps = tabs.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (comps[i].equals(component)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setCurrentTab(int tab) {
        switch (tab) {
            case 0: {
                if (!this.containsComponent(this.Tabs, this.gui_intro)) break;
                this.Tabs.setSelectedComponent(this.gui_intro);
                break;
            }
            case 1: {
                this.Tabs.setSelectedComponent(this.gui_services);
                break;
            }
            case 2: {
                this.Tabs.setSelectedComponent(this.gui_queries);
                break;
            }
            case 3: {
                this.Tabs.setSelectedComponent(this.gui_as);
                break;
            }
            case 4: {
                this.Tabs.setSelectedComponent(this.gui_tc);
                break;
            }
            case 5: {
                this.Tabs.setSelectedComponent(this.gui_mm);
                break;
            }
            case 6: {
                this.Tabs.setSelectedComponent(this.gui_td);
                break;
            }
            case 7: {
                this.Tabs.setSelectedComponent(this.gui_rr);
                break;
            }
            case 8: {
                this.Tabs.setSelectedComponent(this.gui_rv);
                break;
            }
            default: {
                GUIState.displayWarning(this.getClass().toString(), " Tried to set unknown tab " + tab);
            }
        }
    }

    public int getCurrentTab() {
        if (this.Tabs.getSelectedComponent().equals(this.gui_intro)) {
            return 0;
        }
        if (this.Tabs.getSelectedComponent().equals(this.gui_services)) {
            return 1;
        }
        if (this.Tabs.getSelectedComponent().equals(this.gui_queries)) {
            return 2;
        }
        if (this.Tabs.getSelectedComponent().equals(this.gui_as)) {
            return 3;
        }
        if (this.Tabs.getSelectedComponent().equals(this.gui_tc)) {
            return 4;
        }
        if (this.Tabs.getSelectedComponent().equals(this.gui_mm)) {
            return 5;
        }
        if (this.Tabs.getSelectedComponent().equals(this.gui_td)) {
            return 6;
        }
        if (this.Tabs.getSelectedComponent().equals(this.gui_rr)) {
            return 7;
        }
        if (this.Tabs.getSelectedComponent().equals(this.gui_rv)) {
            return 8;
        }
        return -1;
    }

    public void hideWizard() {
        this.wizard_item_show.setText("Show Wizard");
        if (this.Tabs.getSelectedComponent().equals(this.gui_intro)) {
            this.taskIndex = this.Tabs.getSelectedIndex();
        }
        int currentIndex = this.Tabs.getSelectedIndex();
        this.taskIndex = this.Tabs.indexOfComponent(this.gui_intro);
        this.Tabs.remove(this.gui_intro);
        if (currentIndex > 0) {
            this.Tabs.setSelectedIndex(currentIndex - 1);
        }
        this.gui_intro.setVisible(false);
        this.Wizard.setVisible(false);
        this.pack();
    }

    public void disableWizard(boolean makeDisabled) {
        if (makeDisabled) {
            this.hideWizard();
        } else {
            this.showWizard();
        }
    }

    public void showWizard() {
        this.wizard_item_show.setText("Hide Wizard");
        this.Wizard.setVisible(true);
        this.gui_intro.setVisible(true);
        if (this.Tabs.indexOfComponent(this.gui_intro) < 0) {
            this.Tabs.insertTab("Task", null, this.gui_intro, null, this.taskIndex);
        }
        this.pack();
    }

    public boolean wizardIsVisible() {
        return this.Wizard.isVisible();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new BaseWindow().setVisible(true);
            }
        });
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.item_about)) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    new ShowPanelFrame(new AboutDialog(), false).setVisible(true);
                }
            });
        } else if (event.getSource().equals(this.file_item_settings)) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    new ShowPanelFrame(BaseWindow.this.gui_settings, false).setVisible(true);
                }
            });
        } else if (event.getSource().equals(this.wizard_item_show)) {
            if (this.wizardIsVisible()) {
                this.disableWizard(true);
            } else {
                this.disableWizard(false);
            }
        }
    }

    private void updateWizard() {
    }

    public void updateData() {
        this.gui_intro.updateData();
        this.gui_services.updateData();
        this.gui_queries.updateData();
        this.gui_as.updateData();
        this.gui_tc.updateData();
        this.gui_mm.updateData();
        this.gui_td.updateData();
        this.gui_rr.updateData();
        this.gui_rv.updateData();
        this.updateWizard();
    }
}

