/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import owlsmx.gui.data.Query;
import owlsmx.gui.data.TestCollection;
import owlsmx.gui.util.GUIState;
import owlsmx.gui.util.UpdateDataListener;
import owlsmx.gui.util.filefilter.ServiceFilter;
import owlsmx.gui.util.tasks.AddServiceToRelevanceset;

public class RelevanceSet
extends JPanel
implements ListSelectionListener,
ActionListener,
UpdateDataListener {
    private JScrollPane answerScrollpane;
    private JButton RemoveServiceButton;
    private JButton addServiceFromFolderButton;
    private JButton addServiceButton;
    private JList answerList;
    private JLabel answerLabel;
    private JLabel logo;
    private JLabel queryLabel;
    private JList queryList;
    private JScrollPane queryScrollpane;
    private JLabel serviceLabel;
    private JList serviceList;
    private JScrollPane serviceScrollpane;
    private JCheckBox markAllServices;
    private JCheckBox markAllAnswers;
    private JFileChooser fc_open;
    private Timer timer;
    private ProgressMonitor progressMonitor;
    private AddServiceToRelevanceset task;
    private static final long serialVersionUID = 1L;

    public RelevanceSet() {
        this.initComponents();
    }

    private void initComponents() {
        this.serviceScrollpane = new JScrollPane();
        this.serviceList = new JList(TestCollection.getInstance().getServiceDataModel());
        this.queryScrollpane = new JScrollPane();
        this.queryList = new JList(TestCollection.getInstance().getQueryDataModel());
        this.queryList.addListSelectionListener(this);
        this.queryList.setSelectionMode(0);
        this.serviceLabel = new JLabel();
        this.queryLabel = new JLabel();
        this.answerScrollpane = new JScrollPane();
        this.answerList = new JList(TestCollection.getInstance().getAnswerSetDataModel());
        this.answerLabel = new JLabel();
        this.addServiceButton = new JButton();
        this.RemoveServiceButton = new JButton();
        this.addServiceFromFolderButton = new JButton();
        this.addServiceButton.addActionListener(this);
        this.RemoveServiceButton.addActionListener(this);
        this.addServiceFromFolderButton.addActionListener(this);
        this.logo = new JLabel();
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.setMinimumSize(new Dimension(800, 400));
        this.setPreferredSize(new Dimension(800, 400));
        this.serviceScrollpane.setViewportView(this.serviceList);
        this.add((Component)this.serviceScrollpane, new AbsoluteConstraints(490, 30, 300, 250));
        this.queryScrollpane.setViewportView(this.queryList);
        this.add((Component)this.queryScrollpane, new AbsoluteConstraints(110, 30, 340, 150));
        this.serviceLabel.setText("Registered services");
        this.add((Component)this.serviceLabel, new AbsoluteConstraints(490, 10, 210, -1));
        this.queryLabel.setText("Service requests");
        this.add((Component)this.queryLabel, new AbsoluteConstraints(110, 10, 250, -1));
        this.answerScrollpane.setViewportView(this.answerList);
        this.add((Component)this.answerScrollpane, new AbsoluteConstraints(110, 210, 330, 170));
        this.answerLabel.setText("Relevance set");
        this.add((Component)this.answerLabel, new AbsoluteConstraints(110, 190, 280, -1));
        this.addServiceButton.setText("Add selected services to relevance set");
        this.add((Component)this.addServiceButton, new AbsoluteConstraints(490, 290, 300, -1));
        this.RemoveServiceButton.setText("Remove selected services");
        this.add((Component)this.RemoveServiceButton, new AbsoluteConstraints(490, 320, 300, -1));
        this.addServiceFromFolderButton.setText("Add services from filefolder to relevance set");
        this.add((Component)this.addServiceFromFolderButton, new AbsoluteConstraints(490, 350, 300, -1));
        this.logo.setIcon(new ImageIcon(this.getClass().getResource("/images/owlsMX1_small_rectangle.jpg")));
        this.add((Component)this.logo, new AbsoluteConstraints(0, 10, -1, -1));
        this.markAllServices = new JCheckBox();
        this.markAllServices.setText("Select all");
        this.markAllServices.addActionListener(this);
        this.add((Component)this.markAllServices, new AbsoluteConstraints(710, 5, 80, -1));
        this.markAllAnswers = new JCheckBox();
        this.markAllAnswers.setText("Select all");
        this.markAllAnswers.addActionListener(this);
        this.add((Component)this.markAllAnswers, new AbsoluteConstraints(370, 185, 80, -1));
        this.fc_open = new JFileChooser();
        this.fc_open.addChoosableFileFilter(new ServiceFilter());
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource().equals(this.queryList)) {
            Query currentQuery = (Query)this.queryList.getSelectedValue();
            if (currentQuery == null) {
                return;
            }
            TestCollection.getInstance().updateAnswerset(currentQuery);
            this.answerList.setModel(TestCollection.getInstance().getAnswerSetDataModel());
            this.answerLabel.setText("Relevance set for query " + currentQuery.getName());
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.RemoveServiceButton)) {
            if (this.queryList.getSelectedIndex() < 0) {
                GUIState.displayWarning(this, "No query selected", "As no query was selected it is unknown which relevance set to add the services to.\nPlease select a query first.");
                return;
            }
            if (this.answerList.getSelectedIndex() < 0) {
                GUIState.displayWarning(this, "No service selected", "As no service from the relevance set was selected it is unknown which to remove.\nPlease select some first.");
                return;
            }
            if (event.getSource().equals(this.RemoveServiceButton)) {
                if (this.answerList.getSelectedIndex() < 0 || this.queryList.getSelectedIndex() < 0) {
                    return;
                }
                TestCollection.getInstance().removeServicesFromAnswerset(((Query)this.queryList.getSelectedValue()).getURI(), this.answerList.getSelectedValues());
            }
        } else if (event.getSource().equals(this.timer)) {
            this.progressMonitor.setProgress(this.task.getCurrent());
            this.progressMonitor.setNote(this.task.getMessage());
            if (this.progressMonitor.isCanceled() || this.task.isDone()) {
                this.progressMonitor.close();
                this.task.stop();
                this.timer.stop();
                if (!this.task.isDone()) {
                    GUIState.displayWarning(this.getClass().toString(), "Added only " + this.task.getCurrent() + " of " + this.task.getLengthOfTask() + " services");
                }
            }
            this.updateData();
        } else if (event.getSource().equals(this.addServiceFromFolderButton)) {
            if (this.queryList.getSelectedIndex() < 0) {
                GUIState.displayWarning(this, "No query selected", "As no query was selected it is unknown which relevance set to add the services to.\nPlease select a query first.");
                return;
            }
            if (this.task != null && !this.task.isDone()) {
                GUIState.displayWarning(this, "Task still running", "There is still a task running");
                return;
            }
            this.fc_open.setFileSelectionMode(1);
            if (this.fc_open.showOpenDialog(this) != 0) {
                return;
            }
            File[] files = this.fc_open.getSelectedFile().listFiles();
            this.progressMonitor = new ProgressMonitor(this, "Adding services to answer set", "", 0, files.length - 1);
            this.progressMonitor.setProgress(1);
            this.progressMonitor.setMillisToDecideToPopup(0);
            this.progressMonitor.setMillisToPopup(0);
            this.timer = new Timer(500, this);
            this.timer.start();
            this.timer.addActionListener(this);
            this.task = new AddServiceToRelevanceset(files, (Query)this.queryList.getSelectedValue());
            this.progressMonitor.setNote(this.task.getMessage());
            this.task.go();
            this.updateData();
        } else if (event.getSource().equals(this.addServiceButton)) {
            if (this.queryList.getSelectedIndex() < 0) {
                GUIState.displayWarning(this, "No query selected", "As no query was selected it is unknown which relevance set to add the services to.\nPlease select a query first.");
                return;
            }
            if (this.serviceList.getSelectedIndex() < 0) {
                GUIState.displayWarning(this, "No service selected", "As no service was selected it is which to add the relevance set.\nPlease select some first.");
                return;
            }
            TestCollection.getInstance().addServicesToAnswerset(((Query)this.queryList.getSelectedValue()).getURI(), this.serviceList.getSelectedValues());
        } else if (event.getSource().equals(this.markAllServices)) {
            if (this.markAllServices.isSelected()) {
                this.serviceList.addSelectionInterval(0, this.serviceList.getModel().getSize() - 1);
            } else {
                this.serviceList.removeSelectionInterval(0, this.serviceList.getModel().getSize() - 1);
            }
        } else if (event.getSource().equals(this.markAllAnswers)) {
            if (this.queryList.getSelectedIndex() < 0) {
                GUIState.displayWarning(this, "No query selected", "As no query was selected it is unknown which relevance set to use.\nPlease select a query first.");
                return;
            }
            if (this.markAllAnswers.isSelected()) {
                this.answerList.addSelectionInterval(0, this.answerList.getModel().getSize() - 1);
            } else {
                this.answerList.removeSelectionInterval(0, this.answerList.getModel().getSize() - 1);
            }
        }
    }

    public void updateData() {
        int[] selectedAnswers = this.answerList.getSelectedIndices();
        int[] selectedServices = this.serviceList.getSelectedIndices();
        int[] selectedQueries = this.queryList.getSelectedIndices();
        this.serviceList.setModel(TestCollection.getInstance().getServiceDataModel());
        this.queryList.setModel(TestCollection.getInstance().getQueryDataModel());
        this.answerList.setModel(TestCollection.getInstance().getAnswerSetDataModel());
        this.answerList.setSelectedIndices(selectedAnswers);
        this.serviceList.setSelectedIndices(selectedServices);
        this.serviceList.setSelectedIndices(selectedQueries);
    }
}

