/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import owlsmx.gui.DisplayService;
import owlsmx.gui.ShowPanelFrame;
import owlsmx.gui.data.ServiceItem;
import owlsmx.gui.data.TestCollection;
import owlsmx.gui.util.GUIState;
import owlsmx.gui.util.UpdateDataListener;
import owlsmx.gui.util.Utils;
import owlsmx.gui.util.filefilter.ServiceFilter;
import owlsmx.gui.util.tasks.AddServicesToCollectionTask;

public class Services
extends JPanel
implements ListSelectionListener,
ActionListener,
UpdateDataListener {
    private JList services;
    private JButton addDirectory;
    private JButton addService;
    private JList inputs;
    private JLabel inputsLabel;
    private JScrollPane inputsScrollPane;
    private JLabel logo;
    private JButton moreInfo;
    private JTextField name;
    private JLabel nameLabel;
    private JList outputs;
    private JLabel outputsLabel;
    private JScrollPane outputsScrollPane;
    private JButton removeService;
    private JLabel servicesLabel;
    private JScrollPane servicesPane;
    private JTextField uri;
    private JLabel uriLabel;
    private DefaultListModel inputsDataModel = new DefaultListModel();
    private DefaultListModel outputsDataModel = new DefaultListModel();
    private ServiceItem currentService;
    private JFileChooser fc_open;
    private Timer timer;
    private ProgressMonitor progressMonitor;
    private AddServicesToCollectionTask task;
    private JCheckBox markAll;
    private static final long serialVersionUID = 1L;

    public Services() {
        this.initComponents();
    }

    private void initComponents() {
        this.servicesPane = new JScrollPane();
        this.services = new JList(TestCollection.getInstance().getServiceDataModel());
        this.services.addListSelectionListener(this);
        this.addService = new JButton();
        this.removeService = new JButton();
        this.servicesLabel = new JLabel();
        this.nameLabel = new JLabel();
        this.name = new JTextField();
        this.uriLabel = new JLabel();
        this.uri = new JTextField();
        this.moreInfo = new JButton();
        this.addDirectory = new JButton();
        this.logo = new JLabel();
        this.inputsLabel = new JLabel();
        this.inputsScrollPane = new JScrollPane();
        this.inputs = new JList();
        this.outputsLabel = new JLabel();
        this.outputsScrollPane = new JScrollPane();
        this.outputs = new JList();
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.setMinimumSize(new Dimension(800, 400));
        this.setPreferredSize(new Dimension(800, 400));
        this.servicesPane.setViewportView(this.services);
        this.add((Component)this.servicesPane, new AbsoluteConstraints(110, 30, 300, 290));
        this.addService.setText("Register service (file)");
        this.addService.addActionListener(this);
        this.add((Component)this.addService, new AbsoluteConstraints(110, 330, 300, -1));
        this.removeService.setText("Remove selected services");
        this.removeService.addActionListener(this);
        this.add((Component)this.removeService, new AbsoluteConstraints(470, 330, 300, -1));
        this.servicesLabel.setText("Registered Services");
        this.add((Component)this.servicesLabel, new AbsoluteConstraints(110, 10, 300, -1));
        this.nameLabel.setText("Name");
        this.add((Component)this.nameLabel, new AbsoluteConstraints(470, 10, 300, -1));
        this.add((Component)this.name, new AbsoluteConstraints(470, 30, 300, -1));
        this.uriLabel.setText("URI");
        this.add((Component)this.uriLabel, new AbsoluteConstraints(470, 60, 300, -1));
        this.add((Component)this.uri, new AbsoluteConstraints(470, 80, 300, -1));
        this.moreInfo.setText("More information");
        this.moreInfo.addActionListener(this);
        this.add((Component)this.moreInfo, new AbsoluteConstraints(470, 360, 300, -1));
        this.addDirectory.setText("Register services (filefolder)");
        this.addDirectory.addActionListener(this);
        this.add((Component)this.addDirectory, new AbsoluteConstraints(110, 360, 300, -1));
        this.logo.setIcon(new ImageIcon(this.getClass().getResource("/images/owlsMX1_small_rectangle.jpg")));
        this.add((Component)this.logo, new AbsoluteConstraints(0, 10, -1, -1));
        this.inputsLabel.setText("Inputs");
        this.add((Component)this.inputsLabel, new AbsoluteConstraints(470, 100, 300, 20));
        this.inputsScrollPane.setViewportView(this.inputs);
        this.add((Component)this.inputsScrollPane, new AbsoluteConstraints(470, 120, 300, 90));
        this.outputsLabel.setText("Outputs");
        this.add((Component)this.outputsLabel, new AbsoluteConstraints(470, 210, 300, 20));
        this.outputsScrollPane.setViewportView(this.outputs);
        this.add((Component)this.outputsScrollPane, new AbsoluteConstraints(470, 230, 300, 90));
        this.fc_open = new JFileChooser();
        this.fc_open.addChoosableFileFilter(new ServiceFilter());
        this.markAll = new JCheckBox();
        this.markAll.setText("Select all");
        this.markAll.addActionListener(this);
        this.add((Component)this.markAll, new AbsoluteConstraints(330, 5, 80, -1));
    }

    private void updateDisplayedService() {
        URI uri;
        ServiceItem tmp = (ServiceItem)this.services.getSelectedValue();
        if (this.currentService != null && this.currentService.equals(tmp) || tmp == null) {
            return;
        }
        this.currentService = tmp;
        this.name.setText(this.currentService.getName());
        this.uri.setText(this.currentService.getURI().toString());
        this.inputs.removeAll();
        Iterator iter = this.currentService.getInputs().iterator();
        this.inputsDataModel.removeAllElements();
        while (iter.hasNext()) {
            uri = (URI)iter.next();
            this.inputsDataModel.addElement(Utils.getConcept(uri.toString(), true));
        }
        this.inputs.setModel(this.inputsDataModel);
        this.outputsDataModel.removeAllElements();
        iter = this.currentService.getOutputs().iterator();
        while (iter.hasNext()) {
            uri = (URI)iter.next();
            this.outputsDataModel.addElement(Utils.getConcept(uri.toString(), true));
        }
        this.outputs.setModel(this.outputsDataModel);
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource().equals(this.services)) {
            this.updateDisplayedService();
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.addDirectory)) {
            this.fc_open.setFileSelectionMode(1);
            if (this.fc_open.showOpenDialog(this) == 0) {
                File[] files = this.fc_open.getSelectedFile().listFiles();
                this.progressMonitor = new ProgressMonitor(this, "Adding services to testcollection", "", 0, files.length - 1);
                this.progressMonitor.setProgress(1);
                this.progressMonitor.setMillisToDecideToPopup(0);
                this.progressMonitor.setMillisToPopup(0);
                this.timer = new Timer(1000, this);
                this.timer.start();
                this.timer.addActionListener(this);
                this.task = new AddServicesToCollectionTask(this, files, false);
                this.progressMonitor.setNote(this.task.getMessage());
                this.task.go();
            }
            this.updateData();
        } else if (event.getSource().equals(this.timer)) {
            this.progressMonitor.setProgress(this.task.getCurrent());
            this.progressMonitor.setNote(this.task.getMessage());
            if (this.progressMonitor.isCanceled() || this.task.isDone()) {
                this.progressMonitor.close();
                this.task.stop();
                this.timer.stop();
                if (!this.task.isDone()) {
                    GUIState.displayWarning(this.getClass().toString(), "Added only " + this.task.getCurrent() + " of " + this.task.getLengthOfTask() + " services");
                }
            }
            this.updateData();
        } else if (event.getSource().equals(this.addService)) {
            this.fc_open.setFileSelectionMode(0);
            if (this.fc_open.showOpenDialog(this) == 0) {
                try {
                    TestCollection.getInstance().addService(this.fc_open.getSelectedFile().toURI());
                }
                catch (FileNotFoundException e) {
                    if (GUIState.debug) {
                        JOptionPane.showMessageDialog(null, "Couldn't read selected service.", "FileNotFound Warning", 2);
                    }
                    e.printStackTrace();
                }
            }
            this.updateData();
        } else if (event.getSource().equals(this.moreInfo)) {
            Object[] values = this.services.getSelectedValues();
            int i = 0;
            while (i < values.length) {
                ServiceItem tmpService = (ServiceItem)values[i];
                DisplayService dService = new DisplayService(tmpService);
                EventQueue.invokeLater(new ShowPanelFrame(dService, false));
                ++i;
            }
        } else if (event.getSource().equals(this.removeService)) {
            TestCollection.getInstance().removeServices(this.services.getSelectedValues());
            this.updateData();
        } else if (event.getSource().equals(this.markAll)) {
            if (this.markAll.isSelected()) {
                this.services.addSelectionInterval(0, this.services.getModel().getSize() - 1);
            } else {
                this.services.removeSelectionInterval(0, this.services.getModel().getSize() - 1);
            }
        }
    }

    public void updateData() {
        int[] selected = this.services.getSelectedIndices();
        this.services.setModel(TestCollection.getInstance().getServiceDataModel());
        this.services.setSelectedIndices(selected);
    }
}

