/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import owlsmx.gui.BaseWindow;
import owlsmx.gui.util.GUIState;
import owlsmx.gui.util.UpdateDataListener;
import owlsmx.io.ErrorLog;

public class Settings
extends JPanel
implements UpdateDataListener {
    private JComboBox Style;
    private JRadioButton addServicesDirectly;
    private JRadioButton addServicesDuringMatching;
    private ButtonGroup addServicesWhen;
    private JLabel swingStyleLabel;
    private JLabel processServicesLabel;
    private JLabel logo;
    private JTextField replaceURI;
    private JLabel replaceURILabel;
    private JTextField withURI;
    private JLabel withURILabel;
    private JButton apply;
    private JCheckBox useReplaceURI;
    private static final long serialVersionUID = 1L;
    private HashMap look = new HashMap();
    BaseWindow frame;

    public Settings(BaseWindow frame) {
        this.frame = frame;
        this.initComponents();
        this.addServicesWhen.add(this.addServicesDirectly);
        this.addServicesWhen.add(this.addServicesDuringMatching);
        UIManager.LookAndFeelInfo[] feel = UIManager.getInstalledLookAndFeels();
        int i = 0;
        while (i < feel.length) {
            this.look.put(feel[i].getName(), feel[i].getClassName());
            this.Style.addItem(feel[i].getName());
            ++i;
        }
        this.updateData();
    }

    private void initComponents() {
        this.addServicesWhen = new ButtonGroup();
        this.Style = new JComboBox();
        this.swingStyleLabel = new JLabel();
        this.logo = new JLabel();
        this.addServicesDirectly = new JRadioButton();
        this.addServicesDuringMatching = new JRadioButton();
        this.processServicesLabel = new JLabel();
        this.replaceURI = new JTextField();
        this.replaceURI.setEnabled(GUIState.getInstance().isUseReplaceWith());
        this.withURI = new JTextField();
        this.withURI.setEnabled(GUIState.getInstance().isUseReplaceWith());
        this.apply = new JButton();
        this.replaceURILabel = new JLabel();
        this.withURILabel = new JLabel();
        this.useReplaceURI = new JCheckBox();
        this.useReplaceURI.setSelected(GUIState.getInstance().isUseReplaceWith());
        this.useReplaceURI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Settings.this.useReplaceURIPerformed(evt);
            }
        });
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.setMinimumSize(new Dimension(800, 400));
        this.setPreferredSize(new Dimension(800, 400));
        this.Style.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Settings.this.StyleActionPerformed(evt);
            }
        });
        this.add((Component)this.Style, new AbsoluteConstraints(110, 100, 200, 30));
        this.swingStyleLabel.setText("Used Swing style");
        this.add((Component)this.swingStyleLabel, new AbsoluteConstraints(110, 80, -1, -1));
        this.logo.setIcon(new ImageIcon(this.getClass().getResource("/images/owlsMX1_small_rectangle.jpg")));
        this.add((Component)this.logo, new AbsoluteConstraints(0, 10, -1, -1));
        this.addServicesDirectly.setText("Directly when they are added");
        this.addServicesDuringMatching.setSelected(true);
        this.addServicesDuringMatching.setText("During the matching process");
        this.processServicesLabel.setText("Process services when");
        this.add((Component)this.replaceURI, new AbsoluteConstraints(110, 190, 450, -1));
        this.add((Component)this.withURI, new AbsoluteConstraints(110, 240, 450, -1));
        this.apply.setText("apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Settings.this.applyPerformed(evt);
            }
        });
        this.add((Component)this.apply, new AbsoluteConstraints(110, 280, 450, -1));
        this.replaceURILabel.setText("Replace URI substring");
        this.add((Component)this.replaceURILabel, new AbsoluteConstraints(110, 170, 450, -1));
        this.withURILabel.setText("with string");
        this.add((Component)this.withURILabel, new AbsoluteConstraints(110, 220, 450, -1));
        this.useReplaceURI.setText("Replace URI substrings");
        this.add((Component)this.useReplaceURI, new AbsoluteConstraints(110, 140, 450, -1));
    }

    private void StyleActionPerformed(ActionEvent evt) {
        try {
            if (this.Style == null || this.look == null || this.frame == null || this.getParent() == null) {
                return;
            }
            UIManager.setLookAndFeel((String)this.look.get(this.Style.getSelectedItem()));
            SwingUtilities.updateComponentTreeUI(this.frame);
            SwingUtilities.updateComponentTreeUI(this.getParent());
            SwingUtilities.updateComponentTreeUI(this);
            this.updateUI();
            this.frame.pack();
        }
        catch (Exception e) {
            ErrorLog.instanceOf().report(String.valueOf(this.getClass().toString()) + "\n" + e.getClass() + "\n" + "Couldn't change look and feel");
        }
    }

    private void addImmediatelyToMatchmaker(ActionEvent evt) {
        if (this.addServicesDirectly.isSelected()) {
            GUIState.getInstance().setAddImmediately(true);
        } else if (this.addServicesDuringMatching.isSelected()) {
            GUIState.getInstance().setAddImmediately(false);
        }
    }

    private void useReplaceURIPerformed(ActionEvent evt) {
        System.out.println(String.valueOf(this.useReplaceURI.isSelected()) + "isSelected");
        System.out.println(String.valueOf(this.useReplaceURI.isEnabled()) + "isEnabled ");
        GUIState.getInstance().setUseReplaceWith(this.useReplaceURI.isSelected());
        this.updateData();
    }

    private void applyPerformed(ActionEvent evt) {
        GUIState.getInstance().setReplaceFrom(this.replaceURI.getText(), this.withURI.getText());
        this.addImmediatelyToMatchmaker(evt);
        this.updateData();
    }

    public void updateData() {
        this.addServicesDirectly.setSelected(GUIState.getInstance().isAddImmediately());
        this.addServicesDuringMatching.setSelected(!GUIState.getInstance().isAddImmediately());
        this.replaceURI.setEnabled(this.useReplaceURI.isSelected());
        this.withURI.setEnabled(this.useReplaceURI.isSelected());
    }
}

