/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jibble.epsgraphics.EpsGraphics2D;
import owlsmx.gui.util.Converter;
import owlsmx.gui.util.GUIState;
import owlsmx.gui.util.filefilter.EPSFilter;
import owlsmx.gui.util.filefilter.JPGFilter;
import owlsmx.gui.util.filefilter.PDFFilter;
import owlsmx.gui.util.filefilter.PNGFilter;

public class ShowResultVisualization
extends JFrame
implements Runnable,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton close;
    private JButton save;
    private JFreeChart chart;
    private JPanel chartPanel;
    private JFileChooser fc;

    public ShowResultVisualization(JFreeChart chart) {
        this.chart = chart;
        this.chartPanel = new ChartPanel(chart);
        this.initComponents();
    }

    private void initComponents() {
        JPanel menu = new JPanel();
        this.close = new JButton();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.chartPanel, "Center");
        this.setDefaultCloseOperation(2);
        this.close.setText("Close");
        this.close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ShowResultVisualization.this.closeActionPerformed(evt);
            }
        });
        menu.add(this.close);
        this.save = new JButton();
        this.save.setText("Save");
        this.save.addActionListener(this);
        menu.add(this.save);
        this.add((Component)menu, "Last");
        this.fc = new JFileChooser();
        this.fc.addChoosableFileFilter(new PNGFilter());
        this.fc.addChoosableFileFilter(new JPGFilter());
        this.fc.addChoosableFileFilter(new PDFFilter());
        this.fc.addChoosableFileFilter(new EPSFilter());
        this.pack();
    }

    private void closeActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
    }

    public void run() {
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.save)) {
            this.saveActionPerformed(e);
        }
    }

    public void printGraphics2DtoEPS(String path) {
        try {
            if (!path.toLowerCase().endsWith(".eps")) {
                path = String.valueOf(path) + ".eps";
            }
            FileOutputStream outputStream = new FileOutputStream(path);
            EpsGraphics2D g = new EpsGraphics2D("", (OutputStream)outputStream, 0, 0, 600, 600);
            g.flush();
            g.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveActionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.save) && this.fc.showSaveDialog(this) == 0) {
                if (this.fc.getFileFilter().getClass().equals(new PNGFilter().getClass())) {
                    if (this.fc.getSelectedFile().getAbsolutePath().toLowerCase().endsWith(".png")) {
                        ChartUtilities.saveChartAsPNG((File)this.fc.getSelectedFile(), (JFreeChart)this.chart, (int)600, (int)600);
                    } else {
                        ChartUtilities.saveChartAsPNG((File)new File(String.valueOf(this.fc.getSelectedFile().getAbsolutePath()) + ".png"), (JFreeChart)this.chart, (int)600, (int)600);
                    }
                } else if (this.fc.getFileFilter().getClass().equals(new JPGFilter().getClass())) {
                    if (this.fc.getSelectedFile().getAbsolutePath().toLowerCase().endsWith(".png")) {
                        ChartUtilities.saveChartAsJPEG((File)this.fc.getSelectedFile(), (JFreeChart)this.chart, (int)600, (int)600);
                    } else {
                        ChartUtilities.saveChartAsJPEG((File)new File(String.valueOf(this.fc.getSelectedFile().getAbsolutePath()) + ".png"), (JFreeChart)this.chart, (int)600, (int)600);
                    }
                } else if (this.fc.getFileFilter().getClass().equals(new PDFFilter().getClass())) {
                    if (this.fc.getSelectedFile().getAbsolutePath().toLowerCase().endsWith(".pdf")) {
                        Converter.convertToPdf(this.chart, 600, 600, this.fc.getSelectedFile().getAbsolutePath());
                    } else {
                        Converter.convertToPdf(this.chart, 600, 600, String.valueOf(this.fc.getSelectedFile().getAbsolutePath()) + ".pdf");
                    }
                } else if (this.fc.getFileFilter().getClass().equals(new EPSFilter().getClass())) {
                    this.printGraphics2DtoEPS(this.fc.getSelectedFile().getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            GUIState.displayWarning(e.getClass().toString(), "Couldn't save file " + this.fc.getSelectedFile().getAbsolutePath());
            e.printStackTrace();
        }
    }
}

