/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.gui.data;

import java.io.Serializable;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import owlsmx.gui.util.ServiceLoader;

public class ServiceItem
implements Serializable,
Comparable {
    private static final long serialVersionUID = 4835205656099953572L;
    protected URI uri;
    protected URI fileURI;
    protected boolean processed = false;
    protected Set inputs = new HashSet();
    protected Set outputs = new HashSet();
    protected String name;

    public ServiceItem() {
    }

    public ServiceItem(URI uri) {
        this.uri = uri;
        this.name = uri.toString();
        this.fileURI = uri;
        ServiceLoader.ServiceContent content = ServiceLoader.getInstance().loadService(uri);
        this.uri = content.uri;
        this.name = content.name;
        this.fileURI = content.fileURI;
        this.inputs = content.inputs;
        this.outputs = content.outputs;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean pro) {
        this.processed = pro;
    }

    public URI getURI() {
        return this.fileURI;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        String name = this.fileURI.toString();
        return name.substring(name.lastIndexOf("/") + 1);
    }

    public int compareTo(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return -1;
        }
        return this.getName().compareTo(((ServiceItem)obj).getName());
    }

    public Set getOutputs() {
        return this.outputs;
    }

    public Set getInputs() {
        return this.inputs;
    }
}

