/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.gui.util;

import java.net.URI;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import owlsmx.SimilarityMatchingEngine;
import owlsmx.data.MatchedService;
import owlsmx.exceptions.MatchingException;
import owlsmx.gui.data.HybridServiceItem;
import owlsmx.gui.data.ServiceItem;
import owlsmx.gui.data.TestCollection;
import owlsmx.gui.util.GUIState;
import owlsmx.io.ErrorLog;
import owlsmx.similaritymeasures.ConstraintSimilarity;
import owlsmx.similaritymeasures.CosineSimilarity;
import owlsmx.similaritymeasures.ExtendedJaccardMeasure;
import owlsmx.similaritymeasures.JensenShannonMeasure;

public class MatchmakerInterface {
    private SimilarityMatchingEngine matcher = null;
    private static MatchmakerInterface _instance = new MatchmakerInterface();
    private boolean ranMatchmaker = false;

    private String getSimType(int type) {
        switch (type) {
            case 2: {
                return "OWLS M3: Cosine";
            }
            case 1: {
                return "OWLS M3: exJ";
            }
            case 3: {
                return "OWLS M3: Jensen Shannon";
            }
            case 0: {
                return "OWLS M3: LOI";
            }
        }
        return "OWLS M0: Semantic";
    }

    public static MatchmakerInterface getInstance() {
        return _instance;
    }

    public void createMatchmaker() {
        short type = GUIState.getInstance().getSimilarityMeasure();
        ErrorLog.debug("Similarity measure: " + this.getSimType(type));
        switch (type) {
            case 2: {
                this.matcher = new SimilarityMatchingEngine(new CosineSimilarity());
                break;
            }
            case 1: {
                this.matcher = new SimilarityMatchingEngine(new ExtendedJaccardMeasure());
                break;
            }
            case 3: {
                this.matcher = new SimilarityMatchingEngine(new JensenShannonMeasure());
                break;
            }
            case 0: {
                this.matcher = new SimilarityMatchingEngine(new ConstraintSimilarity());
                break;
            }
            default: {
                this.matcher = new SimilarityMatchingEngine(null);
            }
        }
        this.matcher.clear();
    }

    public SortedSet matchRequest(URI profileURI, int minimumDegreeOfMatch, double treshold) {
        try {
            ErrorLog.debug("Matching request: " + profileURI);
            ErrorLog.debug("Minimum DOM: " + minimumDegreeOfMatch);
            ErrorLog.debug("Similarity treshold: " + treshold);
            this.ranMatchmaker = true;
            SortedSet tmpResult = this.matcher.matchRequest(profileURI, GUIState.getInstance().getMinDegree(), GUIState.getInstance().getTreshold());
            ErrorLog.debug("Resultat:\n   " + tmpResult);
            SortedSet result = this.MatchmakerToGUISet(tmpResult);
            return result;
        }
        catch (MatchingException e) {
            e.printStackTrace();
            this.matcher = null;
            return new TreeSet();
        }
    }

    public void addService(URI profileURI) {
        try {
            if (this.matcher == null) {
                ErrorLog.debug(String.valueOf(this.getClass().toString()) + ": Reset machmaker");
                this.createMatchmaker();
            }
            ErrorLog.debug(String.valueOf(this.getClass().toString()) + ": Adding service: " + profileURI.toString());
            this.matcher.addService(profileURI);
        }
        catch (Exception e) {
            GUIState.displayWarning("Matchmaker", "Couldn't add service " + profileURI + " either file not found or not an valid OWL-S 1.1 file.");
        }
    }

    private SortedSet MatchmakerToGUISet(SortedSet result) {
        TreeSet<HybridServiceItem> hybrid = new TreeSet<HybridServiceItem>();
        if (result == null) {
            GUIState.displayWarning("Matchmaker", "Result set is empty");
            return hybrid;
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            MatchedService m_result = (MatchedService)iter.next();
            ServiceItem s_item = TestCollection.getInstance().getService(m_result.serviceURI);
            HybridServiceItem h_result = new HybridServiceItem(s_item);
            h_result.setDegreeOfMatch(m_result.degreeOfMatch);
            h_result.setSyntacticSimilarity(m_result.similarity);
            hybrid.add(h_result);
        }
        return hybrid;
    }

    public void clear() {
        this.matcher.clear();
        this.matcher = null;
        ErrorLog.debug(String.valueOf(this.getClass().toString()) + ": Reset machmaker");
    }

    public boolean didRun() {
        return this.ranMatchmaker;
    }
}

