/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.gui.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JOptionPane;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.service.Service;
import owlsmx.gui.util.GUIState;

public class ServiceLoader {
    OWLKnowledgeBase kb = OWLFactory.createKB();
    private static ServiceLoader _instance = new ServiceLoader();

    private ServiceLoader() {
    }

    public static ServiceLoader getInstance() {
        return _instance;
    }

    private URI getFileURI(URI uri) throws URISyntaxException {
        String tmp = uri.toString();
        if (tmp.indexOf("#") < 0) {
            return uri;
        }
        tmp = tmp.substring(0, tmp.lastIndexOf("#"));
        return new URI(tmp);
    }

    public ServiceContent loadService(URI uri) {
        ServiceContent content;
        block7: {
            content = new ServiceContent(uri);
            try {
                this.kb.setReasoner("RDFS");
                Service service = this.kb.readService(uri);
                if (service == null) {
                    GUIState.displayWarning("Loading service", "Could not load service " + uri.toString() + "\n" + "Either the URI is wrong or the service is not valid OWL-S 1.1");
                    throw new FileNotFoundException();
                }
                content.name = service.getName();
                if (service.getURI() != null && !service.getURI().toString().equals("")) {
                    content.uri = service.getURI();
                }
                if (this.getFileURI(service.getURI()) != null && !this.getFileURI(service.getURI()).toString().equals("")) {
                    content.fileURI = this.getFileURI(service.getURI());
                }
                Iterator iter = service.getProfile().getInputs().iterator();
                while (iter.hasNext()) {
                    content.inputs.add(((Input)iter.next()).getParamType().getURI());
                }
                iter = service.getProfile().getOutputs().iterator();
                while (iter.hasNext()) {
                    content.outputs.add(((Output)iter.next()).getParamType().getURI());
                }
                this.kb.unload(uri);
            }
            catch (Exception e) {
                if (!GUIState.debug) break block7;
                JOptionPane.showMessageDialog(null, "Couldn't read service " + uri.toString() + "\n It will be added without any additional information.", String.valueOf(this.getClass().toString()) + ": " + e.getMessage(), 2);
            }
        }
        return content;
    }

    private void saveServiceItemInfo(ServiceContent item) {
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(new File("serviceList.txt"), true));
            String uri = item.fileURI.toString();
            if (uri.contains("/")) {
                uri = uri.substring(uri.lastIndexOf("/"));
            }
            String line = String.valueOf(uri) + " (" + item.inputs.size() + "/" + item.outputs.size() + ") (#InputConcepts/#OutputConcepts)";
            output.write(line);
            output.newLine();
            output.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class ServiceContent {
        public URI uri;
        public URI fileURI;
        public Set inputs = new HashSet();
        public Set outputs = new HashSet();
        public String name;

        public ServiceContent(URI Serviceuri) {
            this.uri = Serviceuri;
            this.fileURI = Serviceuri;
            this.name = Serviceuri.toString();
        }
    }
}

