/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.gui.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JPanel;

public class print2DtoPS
implements Printable {
    private int width;
    private int height;

    public print2DtoPS(String path, JPanel panel, int width, int height) {
        this.width = width;
        this.height = height;
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        String psMimeType = DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType();
        StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(flavor, psMimeType);
        if (factories.length == 0) {
            System.err.println("No suitable factories");
            System.exit(0);
        }
        try {
            FileOutputStream fos = new FileOutputStream(path);
            StreamPrintService sps = factories[0].getPrintService(fos);
            DocPrintJob pj = sps.createPrintJob();
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            SimpleDoc doc = new SimpleDoc(this, flavor, null);
            pj.print(doc, aset);
            fos.close();
        }
        catch (PrintException pe) {
            System.err.println(pe);
        }
        catch (IOException ie) {
            System.err.println(ie);
        }
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        if (pageIndex == 0) {
            Graphics2D g2d = (Graphics2D)g;
            GraphicsConfiguration gc = g2d.getDeviceConfiguration();
            BufferedImage image = gc.createCompatibleImage(this.width, this.height, 1);
            Graphics2D g2 = image.createGraphics();
            g2.setPaint(Color.white);
            g2.fillRect(0, 0, this.width, this.height);
            g2.dispose();
            return 0;
        }
        return 1;
    }
}

