/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.gui.util.tasks;

import java.io.File;
import java.io.FileNotFoundException;
import owlsmx.analysis.MemoryContainer;
import owlsmx.gui.data.Query;
import owlsmx.gui.data.ServiceItem;
import owlsmx.gui.data.TestCollection;
import owlsmx.gui.util.GUIState;
import owlsmx.gui.util.SwingWorker;
import owlsmx.io.ErrorLog;

public class AddServiceToRelevanceset {
    private int lengthOfTask;
    private int current = 0;
    private boolean done = false;
    private boolean canceled = false;
    private Query query;
    File[] files;

    public AddServiceToRelevanceset(File[] files, Query query) {
        if (files == null) {
            return;
        }
        this.lengthOfTask = files.length - 1;
        this.query = query;
        this.files = files;
    }

    public void go() {
        MemoryContainer.getInstance().setGUIMemory();
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                AddServiceToRelevanceset.this.current = 0;
                AddServiceToRelevanceset.this.done = false;
                AddServiceToRelevanceset.this.canceled = false;
                return new ActualTask(AddServiceToRelevanceset.this.files, AddServiceToRelevanceset.this.query);
            }
        };
        worker.start();
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public int getCurrent() {
        return this.current;
    }

    public void stop() {
        this.canceled = true;
    }

    public boolean isDone() {
        return this.done;
    }

    public String getMessage() {
        return "Processing service " + this.current + "/" + this.lengthOfTask;
    }

    class ActualTask {
        ActualTask(File[] files, Query query) {
            while (!AddServiceToRelevanceset.this.canceled && !AddServiceToRelevanceset.this.done) {
                int i = 0;
                while (i < files.length) {
                    AddServiceToRelevanceset.this.current = i;
                    if (files[i].isFile() && (files[i].getAbsolutePath().endsWith(".owl") || files[i].getAbsolutePath().endsWith(".owls"))) {
                        try {
                            ServiceItem tmpService = TestCollection.getInstance().addService(files[i].toURI());
                            if (query == null) {
                                ErrorLog.instanceOf().report("Query was empty and I don't know why");
                            }
                            if (tmpService == null) {
                                ErrorLog.instanceOf().report("Service was not found for file" + files[i] + " and query " + query);
                            }
                            TestCollection.getInstance().addServiceToAnswerset(query.getURI(), tmpService.getURI());
                            if (AddServiceToRelevanceset.this.canceled) {
                                break;
                            }
                        }
                        catch (FileNotFoundException e) {
                            GUIState.displayWarning(e.getClass().toString(), e.getMessage());
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
                AddServiceToRelevanceset.this.done = true;
            }
        }
    }
}

