/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.gui.util.tasks;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import owlsmx.analysis.MemoryContainer;
import owlsmx.gui.data.TestCollection;
import owlsmx.gui.util.GUIState;
import owlsmx.gui.util.SwingWorker;
import owlsmx.io.ErrorLog;

public class AddServicesToCollectionTask {
    private int lengthOfTask;
    private int current = 0;
    private boolean done = false;
    private boolean canceled = false;
    private boolean query = false;
    File[] files;
    Component comp;

    public AddServicesToCollectionTask(Component comp, File[] files, boolean query) {
        if (files == null) {
            return;
        }
        this.comp = comp;
        this.lengthOfTask = files.length - 1;
        this.query = query;
        this.files = files;
    }

    public void go() {
        MemoryContainer.getInstance().setGUIMemory();
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                AddServicesToCollectionTask.this.current = 0;
                AddServicesToCollectionTask.this.done = false;
                AddServicesToCollectionTask.this.canceled = false;
                return new ActualTask(AddServicesToCollectionTask.this.files, AddServicesToCollectionTask.this.query);
            }
        };
        worker.start();
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public int getCurrent() {
        return this.current;
    }

    public void stop() {
        this.canceled = true;
    }

    public boolean isDone() {
        return this.done;
    }

    public String getMessage() {
        if (!this.query) {
            return "Processing service " + this.current + "/" + this.lengthOfTask;
        }
        return "Processing service request " + this.current + "/" + this.lengthOfTask;
    }

    class ActualTask {
        ActualTask(File[] files, boolean query) {
            int adding = 0;
            int before = 0;
            int before_query = 0;
            before = !query ? TestCollection.getInstance().getServices().size() : TestCollection.getInstance().getQueries().size();
            while (!AddServicesToCollectionTask.this.canceled && !AddServicesToCollectionTask.this.done) {
                int i = 0;
                while (i < files.length) {
                    AddServicesToCollectionTask.this.current = i;
                    if (files[i].isFile() && (files[i].getAbsolutePath().endsWith(".owl") || files[i].getAbsolutePath().endsWith(".owls"))) {
                        try {
                            before_query = TestCollection.getInstance().getServices().size();
                            if (!query) {
                                TestCollection.getInstance().addService(files[i].toURI());
                            } else {
                                TestCollection.getInstance().addQuery(files[i].toURI());
                            }
                            if (TestCollection.getInstance().getServices().size() == before_query) {
                                ErrorLog.instanceOf().report("Service " + files[i].toURI() + " could not be added");
                            }
                            ++adding;
                            if (AddServicesToCollectionTask.this.canceled) {
                                break;
                            }
                        }
                        catch (FileNotFoundException e) {
                            GUIState.displayWarning(e.getClass().toString(), e.getMessage());
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
                AddServicesToCollectionTask.this.done = true;
                AddServicesToCollectionTask.this.current = AddServicesToCollectionTask.this.lengthOfTask;
            }
            if (!query) {
                GUIState.displayWarning(AddServicesToCollectionTask.this.comp, "Adding services to test collection", "Added " + (TestCollection.getInstance().getServices().size() - before) + "/" + adding + " services");
            } else {
                GUIState.displayWarning(AddServicesToCollectionTask.this.comp, "Adding service requests to test collection", "Added " + (TestCollection.getInstance().getQueries().size() - before) + "/" + adding + " service requests");
            }
        }
    }
}

