/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.gui.util.tasks;

import java.util.Iterator;
import java.util.Set;
import owlsmx.analysis.MemoryContainer;
import owlsmx.analysis.PassedTimeContainer;
import owlsmx.gui.data.ServiceItem;
import owlsmx.gui.data.TestCollection;
import owlsmx.gui.util.GUIState;
import owlsmx.gui.util.MatchmakerInterface;
import owlsmx.gui.util.SwingWorker;
import owlsmx.io.ErrorLog;

public class AddServicesToMatchmakerTask {
    private int lengthOfTask;
    private int current = 0;
    private boolean done = false;
    private boolean canceled = false;
    private Set services = TestCollection.getInstance().getServices();

    public AddServicesToMatchmakerTask() {
        this.lengthOfTask = this.services.size();
    }

    public void go() {
        MemoryContainer.getInstance().clear();
        MemoryContainer.getInstance().setGUIMemory();
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                AddServicesToMatchmakerTask.this.current = 1;
                AddServicesToMatchmakerTask.this.done = false;
                AddServicesToMatchmakerTask.this.canceled = false;
                return new ActualTask(AddServicesToMatchmakerTask.this.services);
            }
        };
        worker.start();
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public int getCurrent() {
        return this.current;
    }

    public void stop() {
        this.canceled = true;
    }

    public boolean isDone() {
        return this.done;
    }

    public String getMessage() {
        return "Processing service " + this.current + "/" + this.lengthOfTask + ".";
    }

    class ActualTask {
        ActualTask(Set services) {
            MatchmakerInterface.getInstance().createMatchmaker();
            PassedTimeContainer.getInstance().setStartTime();
            ErrorLog.debug(String.valueOf(this.getClass().toString()) + "Services to add: " + services.size());
            Iterator iter = services.iterator();
            while (iter.hasNext()) {
                ServiceItem service = (ServiceItem)iter.next();
                ErrorLog.debug(String.valueOf(this.getClass().toString()) + ": Adding service: " + service.getURI().toString());
                MatchmakerInterface.getInstance().addService(service.getURI());
                if (GUIState.getInstance().getMemoryConsumption()) {
                    MemoryContainer.getInstance().addState(AddServicesToMatchmakerTask.this.current);
                }
                if (AddServicesToMatchmakerTask.this.canceled) break;
                AddServicesToMatchmakerTask addServicesToMatchmakerTask2 = AddServicesToMatchmakerTask.this;
                addServicesToMatchmakerTask2.current = addServicesToMatchmakerTask2.current + 1;
            }
            AddServicesToMatchmakerTask.this.done = true;
            AddServicesToMatchmakerTask.this.current = AddServicesToMatchmakerTask.this.lengthOfTask;
            MemoryContainer.getInstance().addState(AddServicesToMatchmakerTask.this.lengthOfTask);
        }
    }
}

