/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.reasoning;

import aterm.ATermAppl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import mx.com.hp.hpl.jena.ontology.OntClass;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import org.mindswap.owl.OWLClass;
import org.mindswap.pellet.TuBox;
import org.mindswap.pellet.jena.OWLReasoner;
import owlsmx.exceptions.ConceptNotFoundException;
import owlsmx.exceptions.MatchingException;
import owlsmx.io.ErrorLog;
import owlsmx.utils.MatchmakerUtils;

public class PelletReasoner
extends OWLReasoner {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Set getAllClasses() {
        return this.getClasses();
    }

    private Set getDescendantClasses(OntClass clazz) {
        return MatchmakerUtils.union((Collection)this.getSubClasses((Resource)clazz));
    }

    private Set getDirectSubClasses(OntClass clazz) {
        return MatchmakerUtils.union((Collection)this.getSubClasses((Resource)clazz, true));
    }

    private Set getAncestorClasses(OntClass clazz) {
        return MatchmakerUtils.union((Collection)this.getSuperClasses((Resource)clazz));
    }

    private Set getDirectParentClasses(OntClass clazz) {
        return MatchmakerUtils.union((Collection)this.getSuperClasses((Resource)clazz, true));
    }

    private Set getAllEquivalentClasses(OntClass clazz) {
        return MatchmakerUtils.union((Collection)this.getEquivalentClasses((Resource)clazz));
    }

    public boolean conceptExists(RDFNode node) {
        return this.getClasses().contains(node);
    }

    public boolean conceptExists(URI clazzURI) {
        Iterator iter = this.getClasses().iterator();
        while (iter.hasNext()) {
            RDFNode node = (RDFNode)iter.next();
            if (!node.toString().toLowerCase().equals(clazzURI.toString().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public RDFNode getRDFNode(URI clazzURI) throws ConceptNotFoundException {
        Iterator iter = this.getClasses().iterator();
        while (iter.hasNext()) {
            RDFNode node = (RDFNode)iter.next();
            if (!node.toString().toLowerCase().equals(clazzURI.toString().toLowerCase())) continue;
            return node;
        }
        Resource r = this.getModel().getResource(clazzURI.toString());
        if (r != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mx.com.hp.hpl.jena.rdf.model.RDFNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return r.as((Class)clazz);
        }
        throw new ConceptNotFoundException(String.valueOf(((Object)((Object)this)).getClass().toString()) + "|getRDFNode : Could not load class " + clazzURI.toString());
    }

    public String unfoldTerm(URI clazzURI) throws TuBox.NotUnfoldableException, ConceptNotFoundException, MatchingException {
        return this.unfoldTerm(this.getRDFNode(clazzURI));
    }

    public String unfoldTerm(OntClass clazz) throws TuBox.NotUnfoldableException, MatchingException {
        try {
            return this.unfoldTerm(new URI(clazz.getURI()));
        }
        catch (ConceptNotFoundException e) {
            e.printStackTrace();
            throw new MatchingException(e.getMessage());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new MatchingException(e.getMessage());
        }
    }

    public String unfoldURIs(Vector uris) throws TuBox.NotUnfoldableException, MatchingException, URISyntaxException {
        String result = "";
        int i = 0;
        while (i < uris.size()) {
            URI uri = (URI)uris.get(i);
            if (this.conceptExists(uri)) {
                result = String.valueOf(result) + this.unfoldTerm(this.getRDFNode(uri));
            } else {
                System.out.println("Concept " + uri + " did not exist in reasoner");
            }
            ++i;
        }
        return result.trim();
    }

    public OntClass getClass(String stringURI) throws URISyntaxException, ConceptNotFoundException {
        return this.getClass(new URI(stringURI));
    }

    public OntClass getClass(URI uri) throws URISyntaxException, ConceptNotFoundException {
        if (uri == null) {
            throw new URISyntaxException("URI was not initialized correctly ", "URI was not initialized correctly ");
        }
        RDFNode rDFNode = this.getRDFNode(uri);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("mx.com.hp.hpl.jena.ontology.OntClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (OntClass)rDFNode.as((Class)clazz);
    }

    public String unfoldTerm(RDFNode clazz) throws TuBox.NotUnfoldableException, MatchingException {
        ATermAppl term;
        if (this.getKB().getTBox().Tu == null) {
            this.getKB().getTBox().split();
        }
        if ((term = this.node2term(clazz)) == null) {
            ErrorLog.instanceOf().report("Can't find Term for class " + clazz.toString());
            throw new MatchingException("Can't find Term for class " + clazz.toString());
        }
        String result = this.getKB().getTBox().Tu.unfoldTerm(term).toString();
        return result;
    }

    public String unfoldTerm(OWLClass clazz) throws TuBox.NotUnfoldableException, MatchingException {
        return this.unfoldTerm((OntClass)clazz.getImplementation());
    }

    public Set retrieveEquivalentClasses(OntClass clazz) {
        Set result = this.getAllEquivalentClasses(clazz);
        result.add(clazz);
        return result;
    }

    public Set retrieveDirectParentClasses(OntClass clazz, Set equivalentClasses) {
        Set result = this.getDirectParentClasses(clazz);
        result.removeAll(equivalentClasses);
        return result;
    }

    public Set retrieveAncestorClasses(OntClass clazz, Set equivalentClasses, Set directParentClasses) {
        Set result = this.getAncestorClasses(clazz);
        result.removeAll(equivalentClasses);
        result.removeAll(directParentClasses);
        return result;
    }

    public Set retrieveAllAncestorClasses(OntClass clazz) {
        return this.getAncestorClasses(clazz);
    }

    public Set retrieveDirectSubClasses(OntClass clazz, Set equivalentClasses) {
        Set result = this.getDirectSubClasses(clazz);
        result.removeAll(equivalentClasses);
        return result;
    }

    public Set retrieveDescendantClasses(OntClass clazz, Set equivalentClasses, Set directSubClasses) {
        Set result = this.getDescendantClasses(clazz);
        result.removeAll(directSubClasses);
        result.removeAll(equivalentClasses);
        return result;
    }

    public Set retrieveRemainingClasses(OntClass clazz, Set equivalentClasses, Set directParentClasses, Set AncestorClasses, Set directSubClasses, Set DecendantClasses) {
        Set result = this.getAllClasses();
        result.removeAll(directParentClasses);
        result.removeAll(AncestorClasses);
        result.removeAll(DecendantClasses);
        result.removeAll(directSubClasses);
        return result;
    }

    public Set retrieveAllRemainingClasses(OntClass clazz, Set equivalentClasses, Set AllAncestorClasses) {
        Set result = this.getClasses();
        result.removeAll(AllAncestorClasses);
        result.removeAll(equivalentClasses);
        return result;
    }
}

