/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.similaritymeasures;

import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.TuBox;
import owlsmx.Indexer.Index;
import owlsmx.Indexer.SimpleIndex;
import owlsmx.data.LocalOntologyContainer;
import owlsmx.exceptions.MatchingException;
import owlsmx.io.ErrorLog;
import owlsmx.reasoning.PelletReasoner;
import owlsmx.similaritymeasures.SimilarityMeasure;
import owlsmx.tokenizer.PrimitiveConceptTokenizer;
import owlsmx.utils.CollectionUtils;
import owlsmx.utils.CosineResultTriple;
import owlsmx.utils.MathUtils;
import owlsmx.utils.StringUtils;

public class CosineSimilarity
extends SimilarityMeasure {
    protected int term_frequency_component = 203;
    PrimitiveConceptTokenizer tokenizer = new PrimitiveConceptTokenizer();
    protected boolean useIndex = true;

    public CosineSimilarity() {
        super(SimpleIndex.instanceOf());
    }

    public CosineSimilarity(Index index) {
        super(index);
    }

    public CosineSimilarity(SimilarityMeasure measure) {
        super(measure);
    }

    protected void updateDocumentFrequency(String classname, Map primitiveConcepts) {
        if (this.usesIndex()) {
            SimpleIndex.instanceOf().addDocument(classname, primitiveConcepts);
        }
    }

    protected double[] binaryTermWeight(int[] termFrequencies) {
        double[] result = new double[termFrequencies.length];
        int i = 0;
        while (i < termFrequencies.length) {
            result[i] = termFrequencies[i] > 0 ? 1.0 : 0.0;
            ++i;
        }
        return result;
    }

    protected double[] augmentedNormalizedTermFrequency(int[] termFrequencies) {
        double[] result = new double[termFrequencies.length];
        int max = 1;
        int i = 0;
        while (i < termFrequencies.length) {
            if (termFrequencies[i] > max) {
                max = termFrequencies[i];
            }
            ++i;
        }
        i = 0;
        while (i < termFrequencies.length) {
            result[i] = 0.5 + 0.5 * (double)termFrequencies[i] / (double)max;
            ++i;
        }
        return result;
    }

    protected double[] logrithmicTermFrequency(int[] termFrequencies) {
        double[] result = new double[termFrequencies.length];
        int i = 0;
        while (i < termFrequencies.length) {
            result[i] = termFrequencies[i] < 1 ? 0.0 : Math.log(termFrequencies[i]) + 1.0;
            ++i;
        }
        return result;
    }

    protected double[] relativeTermWeight(int[] termFrequencies) {
        double[] result = new double[termFrequencies.length];
        double sum = MathUtils.vectorSum(termFrequencies);
        if (sum != 0.0) {
            int i = 0;
            while (i < termFrequencies.length) {
                result[i] = (double)termFrequencies[i] / sum;
                ++i;
            }
        }
        return result;
    }

    protected double[] idf(double[] result, double[] idf) {
        int i = 0;
        while (i < result.length) {
            result[i] = result[i] * idf[i];
            ++i;
        }
        return result;
    }

    public double[] weigthAndNormalizeTerms(int[] termFrequencies) {
        double[] idf = new double[termFrequencies.length];
        int i = 0;
        while (i < idf.length) {
            idf[i] = 1.0;
            ++i;
        }
        return this.weigthAndNormalizeTerms(termFrequencies, idf);
    }

    public double[] weigthAndNormalizeTerms(int[] termFrequencies, double[] idf) {
        double[] result = new double[termFrequencies.length];
        switch (this.term_frequency_component) {
            case 201: {
                result = this.binaryTermWeight(termFrequencies);
                break;
            }
            case 200: {
                int i = 0;
                while (i < termFrequencies.length) {
                    result[i] = termFrequencies[i];
                    ++i;
                }
                break;
            }
            case 202: {
                result = this.idf(this.augmentedNormalizedTermFrequency(termFrequencies), idf);
                break;
            }
            case 203: {
                result = this.idf(this.logrithmicTermFrequency(termFrequencies), idf);
                break;
            }
            case 204: {
                result = this.relativeTermWeight(termFrequencies);
            }
        }
        return result;
    }

    public CosineResultTriple getTFArrays(Map pc1, Map pc2) throws MatchingException {
        Set size = CollectionUtils.union(pc1.keySet(), pc2.keySet());
        int[] r1 = new int[size.size()];
        int[] r2 = new int[size.size()];
        double[] idf = new double[size.size()];
        Iterator iter = size.iterator();
        int count = 0;
        while (iter.hasNext()) {
            String current = (String)iter.next();
            if (!pc1.containsKey(current) && !pc2.containsKey(current)) {
                ErrorLog.instanceOf().report("Problem with current: " + current);
            }
            r1[count] = pc1.containsKey(current) ? (Integer)pc1.get(current) : 0;
            r2[count] = pc2.containsKey(current) ? (Integer)pc2.get(current) : 0;
            if (r1[count] == 0 && r2[count] == 0) {
                ErrorLog.instanceOf().report("A new Problem with current: " + current);
            }
            idf[count] = this.index.getIDF(current);
            ++count;
        }
        return new CosineResultTriple(r1, r2, idf);
    }

    public void updateDocument(String document, String tokens) {
        this.updateDocumentFrequency(document, StringUtils.getPrimitiveConcepts(tokens));
    }

    public double computeSimilarity(String query, String token1, String service, String token2) throws MatchingException {
        Map pc1 = this.tokenizer.getTokenFrequencies(token1);
        Map pc2 = this.tokenizer.getTokenFrequencies(token2);
        CosineResultTriple TFs = this.getTFArrays(pc1, pc2);
        double[] weightedPC1 = this.weigthAndNormalizeTerms(TFs.term1);
        double[] weightedPC2 = this.weigthAndNormalizeTerms(TFs.term2, TFs.idf);
        if (weightedPC1.length == 0 && weightedPC2.length == 0) {
            return 1.0;
        }
        if (weightedPC1.length == 0 || weightedPC2.length == 0) {
            return 0.0;
        }
        return MathUtils.vectorDotProduct(weightedPC1, weightedPC2) / (MathUtils.vectorNorm(weightedPC1) * MathUtils.vectorNorm(weightedPC2));
    }

    public void setWeigth(int type) {
        this.term_frequency_component = type;
    }

    public int getWeigth() {
        return this.term_frequency_component;
    }

    public double computeSimilarity(PelletReasoner reason, LocalOntologyContainer localOntology, String clazz1, String clazz2) {
        try {
            return this.computeSimilarity(clazz1.toString(), this.unfoldTerm(reason, localOntology, clazz1), clazz2.toString(), this.unfoldTerm(reason, localOntology, clazz2));
        }
        catch (TuBox.NotUnfoldableException e) {
            e.printStackTrace();
        }
        catch (MatchingException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    public short getSimilarityType() {
        return 2;
    }

    public String getName() {
        return "COSINE";
    }
}

