/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.similaritymeasures;

import java.util.Map;
import owlsmx.Indexer.Index;
import owlsmx.exceptions.MatchingException;
import owlsmx.similaritymeasures.CosineSimilarity;
import owlsmx.similaritymeasures.SimilarityMeasure;
import owlsmx.utils.CosineResultTriple;
import owlsmx.utils.MathUtils;

public class ExtendedJaccardMeasure
extends CosineSimilarity {
    public ExtendedJaccardMeasure() {
        this.term_frequency_component = 203;
    }

    public ExtendedJaccardMeasure(Index index) {
        super(index);
    }

    public ExtendedJaccardMeasure(SimilarityMeasure measure) {
        super(measure);
    }

    public short getSimilarityType() {
        return 1;
    }

    public String getName() {
        return "EXTENDED_JACCARD";
    }

    public double computeSimilarity(String query, String token1, String service, String token2) throws MatchingException {
        Map pc1 = this.tokenizer.getTokenFrequencies(token1);
        Map pc2 = this.tokenizer.getTokenFrequencies(token2);
        CosineResultTriple TFs = this.getTFArrays(pc1, pc2);
        if (pc1.size() == 0 && pc2.size() == 0) {
            return 1.0;
        }
        double[] weightedPC1 = this.weigthAndNormalizeTerms(TFs.term1, TFs.idf);
        double[] weightedPC2 = this.weigthAndNormalizeTerms(TFs.term2, TFs.idf);
        double CqCr = MathUtils.vectorDotProduct(weightedPC1, weightedPC2);
        double nenner = MathUtils.vectorDotProduct(weightedPC1, weightedPC1) + MathUtils.vectorDotProduct(weightedPC2, weightedPC2) - CqCr;
        double result = 0.0;
        if (nenner != 0.0) {
            result = CqCr / nenner;
        }
        return result;
    }
}

