/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.similaritymeasures;

import java.util.Map;
import owlsmx.Indexer.Index;
import owlsmx.exceptions.MatchingException;
import owlsmx.similaritymeasures.CosineSimilarity;
import owlsmx.similaritymeasures.SimilarityMeasure;
import owlsmx.utils.CosineResultTriple;

public class JensenShannonMeasure
extends CosineSimilarity {
    private static final double log2 = Math.log(2.0);
    public boolean onlyIntersection = true;

    public JensenShannonMeasure() {
        this.term_frequency_component = 204;
    }

    public JensenShannonMeasure(Index index) {
        super(index);
        this.term_frequency_component = 204;
    }

    public JensenShannonMeasure(SimilarityMeasure measure) {
        super(measure);
        this.term_frequency_component = 204;
    }

    double h(double x) {
        return -x * Math.log(x);
    }

    double computeSimilarity(double[] v1, double[] v2) {
        double sum = 0.0;
        double tmp = 0.0;
        int i = 0;
        while (i < v1.length) {
            if (v1[i] != 0.0 && v2[i] != 0.0 && !new Double(tmp = this.h(v1[i] + v2[i]) - this.h(v1[i]) - this.h(v2[i])).isNaN()) {
                sum += tmp;
            }
            ++i;
        }
        return sum;
    }

    public double computeSimilarity(String query, String token1, String service, String token2) throws MatchingException {
        Map pc1 = this.tokenizer.getTokenFrequencies(token1);
        Map pc2 = this.tokenizer.getTokenFrequencies(token2);
        CosineResultTriple TFs = this.getTFArrays(pc1, pc2);
        double[] weightedPC1 = this.weigthAndNormalizeTerms(TFs.term1);
        double[] weightedPC2 = this.weigthAndNormalizeTerms(TFs.term2);
        double temp = this.computeSimilarity(weightedPC1, weightedPC2);
        double result = -0.5 * temp / log2;
        return result;
    }

    public short getSimilarityType() {
        return 3;
    }

    public String getName() {
        return "JENSEN_SHANNON";
    }
}

