/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.similaritymeasures;

import owlsmx.utils.MathUtils;

public class SimilarityMeasures {
    int termWeight = 0;
    static final int BINARY_WEIGHT = 0;
    static final int TERM_FREQUENCY = 1;
    static final int AUGMENTED_NORMALIZED_TERM_FREQUENCY = 2;
    static final int LOGARITHMIC_TERM_FREQUENCY = 3;
    static final int RELATIVE_TERM_WEIGHT = 4;

    public SimilarityMeasures() {
    }

    public SimilarityMeasures(int termWeight) {
        this.termWeight = termWeight;
    }

    public double loiSimilarity(String term1, String term2) {
        return 0.0;
    }

    public double cosineSimilarity(int[] tf1, int[] tf2, double[] idf) {
        double[] weight1 = this.idf(this.weigthTerms(tf1), idf);
        double[] weight2 = this.idf(this.weigthTerms(tf2), idf);
        return MathUtils.vectorDotProduct(weight1, weight2) / (MathUtils.vectorNorm(weight1) * MathUtils.vectorNorm(weight2));
    }

    protected double h(double x) {
        return -x * Math.log(x);
    }

    public double jensenShannonSimilarity(int[] tf1, int[] tf2) {
        double[] weight1 = this.weigthTerms(tf1);
        double[] weight2 = this.weigthTerms(tf2);
        double sum = 0.0;
        int i = 0;
        while (i < weight1.length) {
            if (tf1[i] != 0 && tf2[i] != 0) {
                sum += this.h(weight1[i] + weight2[i]) - this.h(weight1[i]) - this.h(weight2[i]);
            }
            ++i;
        }
        return MathUtils.log2 + 0.5 * sum;
    }

    public double extendedJaccardSimilarity(int[] tf1, int[] tf2, double[] idf) {
        double[] weight1 = this.idf(this.weigthTerms(tf1), idf);
        double[] weight2 = this.idf(this.weigthTerms(tf2), idf);
        double CqCr = MathUtils.vectorDotProduct(weight1, weight2);
        double nenner = MathUtils.vectorDotProduct(weight1, weight1) + MathUtils.vectorDotProduct(weight2, weight2) - CqCr;
        if (nenner == 0.0) {
            return 0.0;
        }
        return CqCr / nenner;
    }

    protected double[] weigthTerms(int[] termFrequencies) {
        double[] result = new double[termFrequencies.length];
        switch (this.termWeight) {
            case 0: {
                result = this.binaryTermWeight(termFrequencies);
                break;
            }
            case 1: {
                int i = 0;
                while (i < termFrequencies.length) {
                    result[i] = termFrequencies[i];
                    ++i;
                }
                break;
            }
            case 2: {
                result = this.augmentedNormalizedTermFrequency(termFrequencies);
                break;
            }
            case 3: {
                result = this.logrithmicTermFrequency(termFrequencies);
                break;
            }
            case 4: {
                result = this.relativeTermWeight(termFrequencies);
            }
        }
        return result;
    }

    public double[] binaryTermWeight(int[] termFrequencies) {
        double[] result = new double[termFrequencies.length];
        int i = 0;
        while (i < termFrequencies.length) {
            result[i] = termFrequencies[i] > 0 ? 1.0 : 0.0;
            ++i;
        }
        return result;
    }

    public double[] augmentedNormalizedTermFrequency(int[] termFrequencies) {
        double[] result = new double[termFrequencies.length];
        int max = 1;
        int i = 0;
        while (i < termFrequencies.length) {
            if (termFrequencies[i] > max) {
                max = termFrequencies[i];
            }
            ++i;
        }
        i = 0;
        while (i < termFrequencies.length) {
            result[i] = 0.5 + 0.5 * (double)termFrequencies[i] / (double)max;
            ++i;
        }
        return result;
    }

    public double[] logrithmicTermFrequency(int[] termFrequencies) {
        double[] result = new double[termFrequencies.length];
        int i = 0;
        while (i < termFrequencies.length) {
            result[i] = termFrequencies[i] < 1 ? 0.0 : Math.log(termFrequencies[i]) + 1.0;
            ++i;
        }
        return result;
    }

    public double[] relativeTermWeight(int[] termFrequencies) {
        double[] result = new double[termFrequencies.length];
        double sum = MathUtils.vectorSum(termFrequencies);
        if (sum != 0.0) {
            int i = 0;
            while (i < termFrequencies.length) {
                result[i] = (double)termFrequencies[i] / sum;
                ++i;
            }
        }
        return result;
    }

    public double[] idf(double[] result, double[] idf) {
        int i = 0;
        while (i < result.length) {
            result[i] = result[i] * idf[i];
            ++i;
        }
        return result;
    }
}

