/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.stemmer;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;

public class PorterStemmer {
    protected static final String stopWordsFile = "./stopwords.txt";
    protected static final int numStopWords = 514;
    private HashSet stopWords = null;
    static PorterStemmer stemmer = new PorterStemmer();

    public static PorterStemmer instanceOf() {
        return stemmer;
    }

    public PorterStemmer() {
        this.loadStopWords();
    }

    private void loadStopWords() {
        int HashMapSize = 695;
        this.stopWords = new HashSet(HashMapSize);
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(stopWordsFile));
            while ((line = in.readLine()) != null) {
                this.stopWords.add(line);
            }
            in.close();
        }
        catch (IOException e) {
            this.stopWords.add("a");
            this.stopWords.add("associates");
            this.stopWords.add("able");
            this.stopWords.add("about");
            this.stopWords.add("above");
            this.stopWords.add("according");
            this.stopWords.add("accordingly");
            this.stopWords.add("across");
            this.stopWords.add("actually");
            this.stopWords.add("after");
            this.stopWords.add("afterwards");
            this.stopWords.add("again");
            this.stopWords.add("against");
            this.stopWords.add("all");
            this.stopWords.add("allow");
            this.stopWords.add("allows");
            this.stopWords.add("almost");
            this.stopWords.add("alone");
            this.stopWords.add("along");
            this.stopWords.add("already");
            this.stopWords.add("also");
            this.stopWords.add("although");
            this.stopWords.add("always");
            this.stopWords.add("am");
            this.stopWords.add("among");
            this.stopWords.add("amongst");
            this.stopWords.add("an");
            this.stopWords.add("and");
            this.stopWords.add("another");
            this.stopWords.add("any");
            this.stopWords.add("anybody");
            this.stopWords.add("anyhow");
            this.stopWords.add("anyone");
            this.stopWords.add("anything");
            this.stopWords.add("anyway");
            this.stopWords.add("anyways");
            this.stopWords.add("anywhere");
            this.stopWords.add("apart");
            this.stopWords.add("appear");
            this.stopWords.add("appreciate");
            this.stopWords.add("appropriate");
            this.stopWords.add("are");
            this.stopWords.add("around");
            this.stopWords.add("as");
            this.stopWords.add("aside");
            this.stopWords.add("ask");
            this.stopWords.add("asking");
            this.stopWords.add("associated");
            this.stopWords.add("at");
            this.stopWords.add("available");
            this.stopWords.add("away");
            this.stopWords.add("awfully");
            this.stopWords.add("be");
            this.stopWords.add("became");
            this.stopWords.add("because");
            this.stopWords.add("become");
            this.stopWords.add("becomes");
            this.stopWords.add("becoming");
            this.stopWords.add("been");
            this.stopWords.add("before");
            this.stopWords.add("beforehand");
            this.stopWords.add("behind");
            this.stopWords.add("being");
            this.stopWords.add("believe");
            this.stopWords.add("below");
            this.stopWords.add("beside");
            this.stopWords.add("besides");
            this.stopWords.add("best");
            this.stopWords.add("better");
            this.stopWords.add("between");
            this.stopWords.add("beyond");
            this.stopWords.add("both");
            this.stopWords.add("brief");
            this.stopWords.add("but");
            this.stopWords.add("by");
            this.stopWords.add("came");
            this.stopWords.add("can");
            this.stopWords.add("cannot");
            this.stopWords.add("cant");
            this.stopWords.add("cause");
            this.stopWords.add("causes");
            this.stopWords.add("certain");
            this.stopWords.add("certainly");
            this.stopWords.add("changes");
            this.stopWords.add("clearly");
            this.stopWords.add("com");
            this.stopWords.add("come");
            this.stopWords.add("comes");
            this.stopWords.add("concerning");
            this.stopWords.add("consequently");
            this.stopWords.add("consider");
            this.stopWords.add("considering");
            this.stopWords.add("contain");
            this.stopWords.add("containing");
            this.stopWords.add("contains");
            this.stopWords.add("corresponding");
            this.stopWords.add("could");
            this.stopWords.add("course");
            this.stopWords.add("currently");
            this.stopWords.add("definitely");
            this.stopWords.add("described");
            this.stopWords.add("despite");
            this.stopWords.add("did");
            this.stopWords.add("different");
            this.stopWords.add("do");
            this.stopWords.add("does");
            this.stopWords.add("doing");
            this.stopWords.add("done");
            this.stopWords.add("down");
            this.stopWords.add("downwards");
            this.stopWords.add("during");
            this.stopWords.add("each");
            this.stopWords.add("edu");
            this.stopWords.add("eg");
            this.stopWords.add("eight");
            this.stopWords.add("either");
            this.stopWords.add("else");
            this.stopWords.add("elsewhere");
            this.stopWords.add("enough");
            this.stopWords.add("entirely");
            this.stopWords.add("especially");
            this.stopWords.add("et");
            this.stopWords.add("etc");
            this.stopWords.add("even");
            this.stopWords.add("ever");
            this.stopWords.add("every");
            this.stopWords.add("everybody");
            this.stopWords.add("everyone");
            this.stopWords.add("everything");
            this.stopWords.add("everywhere");
            this.stopWords.add("ex");
            this.stopWords.add("exactly");
            this.stopWords.add("example");
            this.stopWords.add("except");
            this.stopWords.add("far");
            this.stopWords.add("few");
            this.stopWords.add("fifth");
            this.stopWords.add("first");
            this.stopWords.add("five");
            this.stopWords.add("followed");
            this.stopWords.add("following");
            this.stopWords.add("follows");
            this.stopWords.add("for");
            this.stopWords.add("former");
            this.stopWords.add("formerly");
            this.stopWords.add("forth");
            this.stopWords.add("four");
            this.stopWords.add("from");
            this.stopWords.add("further");
            this.stopWords.add("furthermore");
            this.stopWords.add("get");
            this.stopWords.add("gets");
            this.stopWords.add("getting");
            this.stopWords.add("given");
            this.stopWords.add("gives");
            this.stopWords.add("go");
            this.stopWords.add("goes");
            this.stopWords.add("going");
            this.stopWords.add("gone");
            this.stopWords.add("got");
            this.stopWords.add("gotten");
            this.stopWords.add("greetings");
            this.stopWords.add("had");
            this.stopWords.add("happens");
            this.stopWords.add("hardly");
            this.stopWords.add("has");
            this.stopWords.add("have");
            this.stopWords.add("having");
            this.stopWords.add("he");
            this.stopWords.add("hello");
            this.stopWords.add("help");
            this.stopWords.add("hence");
            this.stopWords.add("her");
            this.stopWords.add("here");
            this.stopWords.add("hereafter");
            this.stopWords.add("hereby");
            this.stopWords.add("herein");
            this.stopWords.add("hereupon");
            this.stopWords.add("hers");
            this.stopWords.add("herself");
            this.stopWords.add("hi");
            this.stopWords.add("him");
            this.stopWords.add("himself");
            this.stopWords.add("his");
            this.stopWords.add("hither");
            this.stopWords.add("hopefully");
            this.stopWords.add("how");
            this.stopWords.add("howbeit");
            this.stopWords.add("however");
            this.stopWords.add("i");
            this.stopWords.add("ie");
            this.stopWords.add("if");
            this.stopWords.add("ignored");
            this.stopWords.add("immediate");
            this.stopWords.add("in");
            this.stopWords.add("inasmuch");
            this.stopWords.add("inc");
            this.stopWords.add("indeed");
            this.stopWords.add("indicate");
            this.stopWords.add("indicated");
            this.stopWords.add("indicates");
            this.stopWords.add("inner");
            this.stopWords.add("insofar");
            this.stopWords.add("instead");
            this.stopWords.add("into");
            this.stopWords.add("inward");
            this.stopWords.add("is");
            this.stopWords.add("it");
            this.stopWords.add("its");
            this.stopWords.add("itself");
            this.stopWords.add("j");
            this.stopWords.add("just");
            this.stopWords.add("k");
            this.stopWords.add("keep");
            this.stopWords.add("keeps");
            this.stopWords.add("kept");
            this.stopWords.add("know");
            this.stopWords.add("knows");
            this.stopWords.add("known");
            this.stopWords.add("last");
            this.stopWords.add("lately");
            this.stopWords.add("later");
            this.stopWords.add("latter");
            this.stopWords.add("latterly");
            this.stopWords.add("least");
            this.stopWords.add("less");
            this.stopWords.add("lest");
            this.stopWords.add("let");
            this.stopWords.add("like");
            this.stopWords.add("liked");
            this.stopWords.add("likely");
            this.stopWords.add("little");
            this.stopWords.add("look");
            this.stopWords.add("looking");
            this.stopWords.add("looks");
            this.stopWords.add("ltd");
            this.stopWords.add("mainly");
            this.stopWords.add("many");
            this.stopWords.add("may");
            this.stopWords.add("maybe");
            this.stopWords.add("me");
            this.stopWords.add("mean");
            this.stopWords.add("meanwhile");
            this.stopWords.add("merely");
            this.stopWords.add("might");
            this.stopWords.add("more");
            this.stopWords.add("moreover");
            this.stopWords.add("most");
            this.stopWords.add("mostly");
            this.stopWords.add("much");
            this.stopWords.add("must");
            this.stopWords.add("my");
            this.stopWords.add("myself");
            this.stopWords.add("name");
            this.stopWords.add("namely");
            this.stopWords.add("nd");
            this.stopWords.add("near");
            this.stopWords.add("nearly");
            this.stopWords.add("necessary");
            this.stopWords.add("need");
            this.stopWords.add("needs");
            this.stopWords.add("neither");
            this.stopWords.add("never");
            this.stopWords.add("nevertheless");
            this.stopWords.add("new");
            this.stopWords.add("next");
            this.stopWords.add("nine");
            this.stopWords.add("no");
            this.stopWords.add("nobody");
            this.stopWords.add("non");
            this.stopWords.add("none");
            this.stopWords.add("noone");
            this.stopWords.add("nor");
            this.stopWords.add("normally");
            this.stopWords.add("not");
            this.stopWords.add("nothing");
            this.stopWords.add("novel");
            this.stopWords.add("now");
            this.stopWords.add("nowhere");
            this.stopWords.add("obviously");
            this.stopWords.add("of");
            this.stopWords.add("off");
            this.stopWords.add("often");
            this.stopWords.add("oh");
            this.stopWords.add("ok");
            this.stopWords.add("okay");
            this.stopWords.add("old");
            this.stopWords.add("on");
            this.stopWords.add("once");
            this.stopWords.add("one");
            this.stopWords.add("ones");
            this.stopWords.add("only");
            this.stopWords.add("onto");
            this.stopWords.add("or");
            this.stopWords.add("other");
            this.stopWords.add("others");
            this.stopWords.add("otherwise");
            this.stopWords.add("ought");
            this.stopWords.add("our");
            this.stopWords.add("ours");
            this.stopWords.add("ourselves");
            this.stopWords.add("out");
            this.stopWords.add("outside");
            this.stopWords.add("over");
            this.stopWords.add("overall");
            this.stopWords.add("own");
            this.stopWords.add("particular");
            this.stopWords.add("particularly");
            this.stopWords.add("per");
            this.stopWords.add("perhaps");
            this.stopWords.add("placed");
            this.stopWords.add("please");
            this.stopWords.add("plus");
            this.stopWords.add("possible");
            this.stopWords.add("presumably");
            this.stopWords.add("probably");
            this.stopWords.add("provides");
            this.stopWords.add("que");
            this.stopWords.add("quite");
            this.stopWords.add("qv");
            this.stopWords.add("rather");
            this.stopWords.add("rd");
            this.stopWords.add("re");
            this.stopWords.add("really");
            this.stopWords.add("reasonably");
            this.stopWords.add("regarding");
            this.stopWords.add("regardless");
            this.stopWords.add("regards");
            this.stopWords.add("relatively");
            this.stopWords.add("respectively");
            this.stopWords.add("right");
            this.stopWords.add("said");
            this.stopWords.add("same");
            this.stopWords.add("saw");
            this.stopWords.add("say");
            this.stopWords.add("saying");
            this.stopWords.add("says");
            this.stopWords.add("second");
            this.stopWords.add("secondly");
            this.stopWords.add("see");
            this.stopWords.add("seeing");
            this.stopWords.add("seem");
            this.stopWords.add("seemed");
            this.stopWords.add("seeming");
            this.stopWords.add("seems");
            this.stopWords.add("seen");
            this.stopWords.add("self");
            this.stopWords.add("selves");
            this.stopWords.add("sensible");
            this.stopWords.add("sent");
            this.stopWords.add("serious");
            this.stopWords.add("seriously");
            this.stopWords.add("seven");
            this.stopWords.add("several");
            this.stopWords.add("shall");
            this.stopWords.add("she");
            this.stopWords.add("should");
            this.stopWords.add("since");
            this.stopWords.add("six");
            this.stopWords.add("so");
            this.stopWords.add("some");
            this.stopWords.add("somebody");
            this.stopWords.add("somehow");
            this.stopWords.add("someone");
            this.stopWords.add("something");
            this.stopWords.add("sometime");
            this.stopWords.add("sometimes");
            this.stopWords.add("somewhat");
            this.stopWords.add("somewhere");
            this.stopWords.add("soon");
            this.stopWords.add("sorry");
            this.stopWords.add("specified");
            this.stopWords.add("specify");
            this.stopWords.add("specifying");
            this.stopWords.add("still");
            this.stopWords.add("sub");
            this.stopWords.add("such");
            this.stopWords.add("sup");
            this.stopWords.add("sure");
            this.stopWords.add("take");
            this.stopWords.add("taken");
            this.stopWords.add("tell");
            this.stopWords.add("tends");
            this.stopWords.add("th");
            this.stopWords.add("than");
            this.stopWords.add("thank");
            this.stopWords.add("thanks");
            this.stopWords.add("thanx");
            this.stopWords.add("that");
            this.stopWords.add("thats");
            this.stopWords.add("the");
            this.stopWords.add("their");
            this.stopWords.add("theirs");
            this.stopWords.add("them");
            this.stopWords.add("themselves");
            this.stopWords.add("then");
            this.stopWords.add("thence");
            this.stopWords.add("there");
            this.stopWords.add("thereafter");
            this.stopWords.add("thereby");
            this.stopWords.add("therefore");
            this.stopWords.add("therein");
            this.stopWords.add("theres");
            this.stopWords.add("thereupon");
            this.stopWords.add("these");
            this.stopWords.add("they");
            this.stopWords.add("think");
            this.stopWords.add("third");
            this.stopWords.add("this");
            this.stopWords.add("thorough");
            this.stopWords.add("thoroughly");
            this.stopWords.add("those");
            this.stopWords.add("though");
            this.stopWords.add("three");
            this.stopWords.add("through");
            this.stopWords.add("throughout");
            this.stopWords.add("thru");
            this.stopWords.add("thus");
            this.stopWords.add("to");
            this.stopWords.add("together");
            this.stopWords.add("too");
            this.stopWords.add("took");
            this.stopWords.add("toward");
            this.stopWords.add("towards");
            this.stopWords.add("tried");
            this.stopWords.add("tries");
            this.stopWords.add("truly");
            this.stopWords.add("try");
            this.stopWords.add("trying");
            this.stopWords.add("twice");
            this.stopWords.add("two");
            this.stopWords.add("un");
            this.stopWords.add("under");
            this.stopWords.add("unfortunately");
            this.stopWords.add("unless");
            this.stopWords.add("unlikely");
            this.stopWords.add("until");
            this.stopWords.add("unto");
            this.stopWords.add("up");
            this.stopWords.add("upon");
            this.stopWords.add("us");
            this.stopWords.add("use");
            this.stopWords.add("used");
            this.stopWords.add("useful");
            this.stopWords.add("uses");
            this.stopWords.add("using");
            this.stopWords.add("usually");
            this.stopWords.add("uucp");
            this.stopWords.add("value");
            this.stopWords.add("various");
            this.stopWords.add("very");
            this.stopWords.add("via");
            this.stopWords.add("viz");
            this.stopWords.add("vs");
            this.stopWords.add("want");
            this.stopWords.add("wants");
            this.stopWords.add("was");
            this.stopWords.add("way");
            this.stopWords.add("we");
            this.stopWords.add("welcome");
            this.stopWords.add("well");
            this.stopWords.add("went");
            this.stopWords.add("were");
            this.stopWords.add("what");
            this.stopWords.add("whatever");
            this.stopWords.add("when");
            this.stopWords.add("whence");
            this.stopWords.add("whenever");
            this.stopWords.add("where");
            this.stopWords.add("whereafter");
            this.stopWords.add("whereas");
            this.stopWords.add("whereby");
            this.stopWords.add("wherein");
            this.stopWords.add("whereupon");
            this.stopWords.add("wherever");
            this.stopWords.add("whether");
            this.stopWords.add("which");
            this.stopWords.add("while");
            this.stopWords.add("whither");
            this.stopWords.add("who");
            this.stopWords.add("whoever");
            this.stopWords.add("whole");
            this.stopWords.add("whom");
            this.stopWords.add("whose");
            this.stopWords.add("why");
            this.stopWords.add("will");
            this.stopWords.add("willing");
            this.stopWords.add("wish");
            this.stopWords.add("with");
            this.stopWords.add("within");
            this.stopWords.add("without");
            this.stopWords.add("wonder");
            this.stopWords.add("would");
            this.stopWords.add("would");
            this.stopWords.add("yes");
            this.stopWords.add("yet");
            this.stopWords.add("you");
            this.stopWords.add("your");
            this.stopWords.add("yours");
            this.stopWords.add("yourself");
            this.stopWords.add("yourselves");
            this.stopWords.add("zero");
            this.stopWords.add("q");
            this.stopWords.add("nbsp");
            this.stopWords.add("http");
            this.stopWords.add("www");
            this.stopWords.add("writeln");
            this.stopWords.add("pdf");
            this.stopWords.add("html");
        }
    }

    public String stem(String str) {
        if (str == null) {
            return "";
        }
        str = str.toLowerCase();
        String token = null;
        if (this.stopWords.contains(str)) {
            token = null;
        } else {
            token = this.stripAffixes(str);
            if (this.stopWords.contains(token)) {
                token = null;
            }
        }
        return token;
    }

    private String Clean(String str) {
        if (str == null || str.length() <= 0) {
            return "";
        }
        int last = str.length();
        String temp = "";
        int i = 0;
        while (i < last) {
            if (Character.isLetterOrDigit(str.charAt(i))) {
                temp = String.valueOf(temp) + str.charAt(i);
            }
            ++i;
        }
        return temp;
    }

    private boolean hasSuffix(String word, String suffix, String stem) {
        String tmp = "";
        if (word.length() <= suffix.length()) {
            return false;
        }
        if (suffix.length() > 1 && word.charAt(word.length() - 2) != suffix.charAt(suffix.length() - 2)) {
            return false;
        }
        stem = "";
        int i = 0;
        while (i < word.length() - suffix.length()) {
            stem = String.valueOf(stem) + word.charAt(i);
            ++i;
        }
        tmp = stem;
        i = 0;
        while (i < suffix.length()) {
            tmp = String.valueOf(tmp) + suffix.charAt(i);
            ++i;
        }
        return tmp.compareTo(word) == 0;
    }

    private boolean vowel(char ch, char prev) {
        switch (ch) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                return true;
            }
            case 'y': {
                switch (prev) {
                    case 'a': 
                    case 'e': 
                    case 'i': 
                    case 'o': 
                    case 'u': {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private int measure(String stem) {
        block4: {
            i = 0;
            count = 0;
            length = stem.length();
            break block4;
            while (!(i > 0 ? this.vowel(stem.charAt(i), stem.charAt(i - 1)) != false : this.vowel(stem.charAt(i), 'a') != false)) {
                ++i;
lbl7:
                // 2 sources

                ** while (i >= length)
lbl8:
                // 1 sources

            }
lbl9:
            // 2 sources

            ++i;
            while (i < length) {
                if (i > 0 ? this.vowel(stem.charAt(i), stem.charAt(i - 1)) == false : this.vowel(stem.charAt(i), '?') == false) break;
                ++i;
            }
            if (i < length) {
                ++count;
                ++i;
            }
        }
        if (i < length) ** GOTO lbl7
        return count;
    }

    private boolean containsVowel(String word) {
        int i = 0;
        while (i < word.length()) {
            if (i > 0 ? this.vowel(word.charAt(i), word.charAt(i - 1)) : this.vowel(word.charAt(0), 'a')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean cvc(String str) {
        int length = str.length();
        if (length < 3) {
            return false;
        }
        if (!this.vowel(str.charAt(length - 1), str.charAt(length - 2)) && str.charAt(length - 1) != 'w' && str.charAt(length - 1) != 'x' && str.charAt(length - 1) != 'y' && this.vowel(str.charAt(length - 2), str.charAt(length - 3))) {
            if (length == 3) {
                return !this.vowel(str.charAt(0), '?');
            }
            return !this.vowel(str.charAt(length - 3), str.charAt(length - 4));
        }
        return false;
    }

    private String step1(String str) {
        int i;
        String tmp;
        String stem = "";
        if (str.charAt(str.length() - 1) == 's') {
            if (this.hasSuffix(str, "sses", stem) || this.hasSuffix(str, "ies", stem)) {
                tmp = "";
                i = 0;
                while (i < str.length() - 2) {
                    tmp = String.valueOf(tmp) + str.charAt(i);
                    ++i;
                }
                str = tmp;
            } else {
                if (str.length() == 1 && str.charAt(str.length() - 1) == 's') {
                    str = "";
                    return str;
                }
                if (str.charAt(str.length() - 2) != 's') {
                    tmp = "";
                    i = 0;
                    while (i < str.length() - 1) {
                        tmp = String.valueOf(tmp) + str.charAt(i);
                        ++i;
                    }
                    str = tmp;
                }
            }
        }
        if (this.hasSuffix(str, "eed", stem)) {
            if (this.measure(stem) > 0) {
                tmp = "";
                i = 0;
                while (i < str.length() - 1) {
                    tmp = String.valueOf(tmp) + str.charAt(i);
                    ++i;
                }
                str = tmp;
            }
        } else if ((this.hasSuffix(str, "ed", stem) || this.hasSuffix(str, "ing", stem)) && this.containsVowel(stem)) {
            tmp = "";
            i = 0;
            while (i < stem.length()) {
                tmp = String.valueOf(tmp) + str.charAt(i);
                ++i;
            }
            str = tmp;
            if (str.length() == 1) {
                return str;
            }
            if (this.hasSuffix(str, "at", stem) || this.hasSuffix(str, "bl", stem) || this.hasSuffix(str, "iz", stem)) {
                str = String.valueOf(str) + "e";
            } else {
                int length = str.length();
                if (str.charAt(length - 1) == str.charAt(length - 2) && str.charAt(length - 1) != 'l' && str.charAt(length - 1) != 's' && str.charAt(length - 1) != 'z') {
                    tmp = "";
                    int i2 = 0;
                    while (i2 < str.length() - 1) {
                        tmp = String.valueOf(tmp) + str.charAt(i2);
                        ++i2;
                    }
                    str = tmp;
                } else if (this.measure(str) == 1 && this.cvc(str)) {
                    str = String.valueOf(str) + "e";
                }
            }
        }
        if (this.hasSuffix(str, "y", stem) && this.containsVowel(stem)) {
            tmp = "";
            i = 0;
            while (i < str.length() - 1) {
                tmp = String.valueOf(tmp) + str.charAt(i);
                ++i;
            }
            str = String.valueOf(tmp) + "i";
        }
        return str;
    }

    private String step2(String str) {
        String[][] suffixes = new String[][]{{"ational", "ate"}, {"tional", "tion"}, {"enci", "ence"}, {"anci", "ance"}, {"izer", "ize"}, {"iser", "ize"}, {"abli", "able"}, {"alli", "al"}, {"entli", "ent"}, {"eli", "e"}, {"ousli", "ous"}, {"ization", "ize"}, {"isation", "ize"}, {"ation", "ate"}, {"ator", "ate"}, {"alism", "al"}, {"iveness", "ive"}, {"fulness", "ful"}, {"ousness", "ous"}, {"aliti", "al"}, {"iviti", "ive"}, {"biliti", "ble"}};
        String stem = "";
        int index = 0;
        while (index < suffixes.length) {
            if (this.hasSuffix(str, suffixes[index][0], stem) && this.measure(stem) > 0) {
                str = String.valueOf(stem) + suffixes[index][1];
                return str;
            }
            ++index;
        }
        return str;
    }

    private String step3(String str) {
        String[][] suffixes = new String[][]{{"icate", "ic"}, {"ative", ""}, {"alize", "al"}, {"alise", "al"}, {"iciti", "ic"}, {"ical", "ic"}, {"ful", ""}, {"ness", ""}};
        String stem = "";
        int index = 0;
        while (index < suffixes.length) {
            if (this.hasSuffix(str, suffixes[index][0], stem) && this.measure(stem) > 0) {
                str = String.valueOf(stem) + suffixes[index][1];
                return str;
            }
            ++index;
        }
        return str;
    }

    private String step4(String str) {
        String[] suffixes = new String[]{"al", "ance", "ence", "er", "ic", "able", "ible", "ant", "ement", "ment", "ent", "sion", "tion", "ou", "ism", "ate", "iti", "ous", "ive", "ize", "ise"};
        String stem = "";
        int index = 0;
        while (index < suffixes.length) {
            if (this.hasSuffix(str, suffixes[index], stem) && this.measure(stem) > 1) {
                str = stem;
                return str;
            }
            ++index;
        }
        return str;
    }

    private String step5(String str) {
        int i;
        String tmp;
        if (str.charAt(str.length() - 1) == 'e') {
            if (this.measure(str) > 1) {
                tmp = "";
                i = 0;
                while (i < str.length() - 1) {
                    tmp = String.valueOf(tmp) + str.charAt(i);
                    ++i;
                }
                str = tmp;
            } else if (this.measure(str) == 1) {
                String stem = "";
                i = 0;
                while (i < str.length() - 1) {
                    stem = String.valueOf(stem) + str.charAt(i);
                    ++i;
                }
                if (!this.cvc(stem)) {
                    str = stem;
                }
            }
        }
        if (str.length() == 1) {
            return str;
        }
        if (str.charAt(str.length() - 1) == 'l' && str.charAt(str.length() - 2) == 'l' && this.measure(str) > 1 && this.measure(str) > 1) {
            tmp = "";
            i = 0;
            while (i < str.length() - 1) {
                tmp = String.valueOf(tmp) + str.charAt(i);
                ++i;
            }
            str = tmp;
        }
        return str;
    }

    private String stripPrefixes(String str) {
        String[] prefixes = new String[]{"kilo", "micro", "milli", "intra", "ultra", "mega", "nano", "pico", "pseudo"};
        int last = prefixes.length;
        int i = 0;
        while (i < last) {
            if (str.startsWith(prefixes[i])) {
                String temp = "";
                int j = 0;
                while (j < str.length() - prefixes[i].length()) {
                    temp = String.valueOf(temp) + str.charAt(j + prefixes[i].length());
                    ++j;
                }
                return temp;
            }
            ++i;
        }
        return str;
    }

    private String stripSuffixes(String str) {
        if ((str = this.step1(str)).length() >= 1) {
            str = this.step2(str);
        }
        if (str.length() >= 1) {
            str = this.step3(str);
        }
        if (str.length() >= 1) {
            str = this.step4(str);
        }
        if (str.length() >= 1) {
            str = this.step5(str);
        }
        return str;
    }

    protected String stripAffixes(String str) {
        if ((str = this.Clean(str)) != "" && str.length() > 2 && (str = this.stripPrefixes(str)) != "") {
            str = this.stripSuffixes(str);
        }
        return str;
    }
}

