/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.tokenizer;

import java.net.URI;
import owlsmx.tokenizer.Tokenizer;

public class URLTokenizer
extends Tokenizer {
    protected boolean isTokenChar(char c) {
        return !Character.isWhitespace(c) && (Character.isLetterOrDigit(c) || c == ':' || c == '/' || c == '#');
    }

    boolean isURL(String token) {
        try {
            new URI(token);
        }
        catch (Exception e) {
            return false;
        }
        return (token.indexOf("file:") >= 0 || token.indexOf("http:") >= 0 || token.startsWith("#")) && token.indexOf("#") >= 0;
    }

    protected void filterToken(String token) {
        if (token == null || token.equals("")) {
            return;
        }
        if (token.indexOf("file:") >= 0) {
            token = token.substring(token.indexOf("file:"));
        }
        if (token.indexOf("http:") >= 0) {
            token = token.substring(token.indexOf("http:"));
        }
        if (this.isURL(token)) {
            this.updateToken(token);
        }
    }
}

