/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.ParameterList;
import org.mindswap.pellet.utils.SetUtils;
import org.semanticweb.owl.io.RendererException;
import org.semanticweb.owl.io.owl_rdf.Renderer;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLOntology;
import owlsmx.data.ServiceConcept;
import owlsmx.data.ServiceEntry;
import owlsmx.exceptions.MatchingException;
import owlsmx.io.ErrorLog;
import owlsmx.utils.StringUtils;

public class MatchmakerUtils
extends SetUtils {
    public static String getConcept(String classuri) {
        if (StringUtils.contains(classuri, "#")) {
            return classuri.substring(classuri.lastIndexOf("#"));
        }
        return classuri;
    }

    public static String getConcept(URI classuri) {
        return MatchmakerUtils.getConcept(classuri.toString());
    }

    private static String makeLineLocal(String line) {
        String result = line;
        try {
            if (StringUtils.contains(line, "http://") && StringUtils.contains(line, "#") && !StringUtils.contains(line, "http://www.w3.org/2001/XMLSchema")) {
                result = String.valueOf(line.substring(0, line.indexOf("http://"))) + line.substring(line.lastIndexOf("#"));
            } else if (StringUtils.contains(line, "file:/") && StringUtils.contains(line, "#") && !StringUtils.contains(line, "http://www.w3.org/2001/XMLSchema")) {
                result = String.valueOf(line.substring(0, line.indexOf("file:/"))) + line.substring(line.lastIndexOf("#"));
            }
            return result;
        }
        catch (Exception e) {
            ErrorLog.instanceOf().report("Something went wrong! " + line + " " + (StringUtils.contains(line, "file:/") && StringUtils.contains(line, "#")));
            return line;
        }
    }

    public static String replace(String inString, String toReplace, String replacement) {
        if (StringUtils.contains(inString, toReplace)) {
            inString = String.valueOf(inString.substring(0, inString.indexOf(toReplace))) + replacement + inString.substring(inString.indexOf(toReplace) + toReplace.length() + 1);
        }
        return inString;
    }

    public static String getLocalConceptFromLine(String line, String localOntology) {
        String result = line;
        if ((StringUtils.contains(line, "http://") || StringUtils.contains(line, "file:/")) && StringUtils.contains(line, "#") && StringUtils.contains(line, "\"") && !StringUtils.contains(line, "http://www.w3.org/2001/XMLSchema")) {
            result = String.valueOf(localOntology) + line.substring(line.lastIndexOf("#"), line.lastIndexOf("\""));
        }
        return result;
    }

    public static void makeOntologyLocal(String localOntology, String filename, Set localConcepts) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        Vector<String> vec = new Vector<String>();
        String line = "";
        String localized = "";
        while ((line = reader.readLine()) != null) {
            localized = MatchmakerUtils.getLocalConceptFromLine(line = line.trim(), localOntology);
            if (localConcepts.contains(localized)) {
                line = MatchmakerUtils.makeLineLocal(line);
            }
            vec.add(String.valueOf(line) + "\n");
        }
        reader.close();
        FileWriter writer = new FileWriter(filename, false);
        int i = 0;
        while (i < vec.size()) {
            writer.write((String)vec.get(i));
            ++i;
        }
        writer.flush();
        writer.close();
    }

    public static void replaceOntologyInFile(String filename, String replacement) throws IOException {
        String toReplace = "";
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        Vector<String> vec = new Vector<String>();
        String line = "";
        boolean replace = false;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            if (!replace && StringUtils.contains(line, "file:/") && StringUtils.contains(line, filename)) {
                toReplace = String.valueOf(line.substring(line.indexOf("file:/"), line.indexOf(filename))) + filename;
                replace = true;
            }
            if (replace && StringUtils.contains(line, "file:/") && StringUtils.contains(line, filename) && !StringUtils.contains(line, "http://www.w3.org/2001/XMLSchema")) {
                line = MatchmakerUtils.replace(line, toReplace, replacement);
            }
            vec.add(String.valueOf(line) + "\n");
        }
        reader.close();
        FileWriter writer = new FileWriter(filename, false);
        int i = 0;
        while (i < vec.size()) {
            writer.write((String)vec.get(i));
            ++i;
        }
        writer.flush();
        writer.close();
    }

    public static String degreeOfMatchIntToString(int dom) {
        switch (dom) {
            case 0: {
                return "EXACT";
            }
            case 1: {
                return "PLUG-IN";
            }
            case 2: {
                return "SUBSUMES";
            }
            case 3: {
                return "SUBSUMED-BY";
            }
            case 4: {
                return "NEAREST NEIGHBOUR";
            }
            case 5: {
                return "FAIL";
            }
        }
        return "COULDN'T TRANSLATE " + dom;
    }

    public static void printOWLClassSet(Set set) throws MatchingException {
        try {
            Iterator iter = set.iterator();
            System.out.println("Printing HashSet: ");
            while (iter.hasNext()) {
                System.out.println(((OWLClass)iter.next()).getURI().toString());
            }
        }
        catch (Exception e) {
            throw new MatchingException(e.getMessage());
        }
    }

    public static String printServiceEntrySet(Set set) {
        Iterator iter = set.iterator();
        String result = "";
        while (iter.hasNext()) {
            ServiceEntry entry = (ServiceEntry)iter.next();
            result = String.valueOf(result) + "(" + entry.ID + "," + entry.degreeOfMatch + "," + entry.similarity + ")" + " ";
        }
        return result;
    }

    private static String getStringFromEntries(Set set) {
        String result = "(";
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            ServiceEntry entry = (ServiceEntry)iter.next();
            result = String.valueOf(result) + entry.ID + ";" + entry.degreeOfMatch + ";" + entry.similarity + ";;";
        }
        int last = result.lastIndexOf(";;");
        if (last > 0) {
            result = result.substring(0, last);
        }
        result = String.valueOf(result) + ")";
        return result;
    }

    private static SortedSet entriesFromString(String parsed) {
        TreeSet<ServiceEntry> result = new TreeSet<ServiceEntry>();
        parsed = parsed.substring(parsed.indexOf("(") + 1, parsed.lastIndexOf(")"));
        String[] tokens = parsed.split(";;");
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i].trim();
            String[] entryTokens = token.split(";");
            if (entryTokens.length >= 3) {
                result.add(new ServiceEntry(new Integer(entryTokens[0].trim()), (int)new Integer(entryTokens[1].trim()), (double)new Double(entryTokens[2].trim())));
            }
            ++i;
        }
        return result;
    }

    public static Map loadConceptServiceSet(String path) throws IOException {
        String line;
        HashMap<String, ServiceConcept> result = new HashMap<String, ServiceConcept>();
        BufferedReader reader = new BufferedReader(new FileReader(path));
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            line = line.substring(line.indexOf("(") + 1, line.lastIndexOf(")"));
            String[] tokens = line.split(";;;");
            ServiceConcept services = new ServiceConcept();
            SortedSet entries = MatchmakerUtils.entriesFromString(tokens[1]);
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                services.addInput((ServiceEntry)iter.next());
            }
            entries = MatchmakerUtils.entriesFromString(tokens[2]);
            iter = entries.iterator();
            while (iter.hasNext()) {
                services.addOutput((ServiceEntry)iter.next());
            }
            result.put(tokens[0], services);
        }
        reader.close();
        return result;
    }

    public static boolean saveConceptServiceSet(Map map, String targetpath) {
        try {
            FileWriter writer = new FileWriter(targetpath, false);
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry me = iter.next();
                ServiceConcept services = (ServiceConcept)me.getValue();
                writer.write("(" + (String)me.getKey() + ";;;" + MatchmakerUtils.getStringFromEntries(services.getInputs()) + ";;;" + MatchmakerUtils.getStringFromEntries(services.getOutputs()) + ")\n");
            }
            writer.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean save(OWLOntology ontology, String path) {
        try {
            Renderer render = new Renderer();
            FileWriter writer = new FileWriter(path, false);
            render.renderOntology(ontology, (Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (RendererException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static URI getOntologyURI(URI ClassURI) throws MatchingException {
        String path = ClassURI.toString();
        if (path.startsWith("#") || !StringUtils.contains(path, "#")) {
            throw new MatchingException(String.valueOf(ClassURI.toString()) + " doesn't contain the OntologyURL");
        }
        try {
            return new URI(path.substring(0, path.indexOf("#")));
        }
        catch (URISyntaxException e) {
            throw new MatchingException("URI error: Couldn't get ontologyURI of " + ClassURI.toString());
        }
    }

    public static Vector getClassTextFromFile(OWLClass clazz, String filename) throws IOException, MatchingException {
        try {
            String searchterm1 = clazz.getURI().toString();
            String searchterm2 = "#" + clazz.getURI().getFragment();
            searchterm1 = searchterm1.substring(0, searchterm1.indexOf(searchterm2));
            if (searchterm1.indexOf(".") > 0) {
                searchterm1 = searchterm1.substring(0, searchterm1.lastIndexOf("."));
            }
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            String lastline = "";
            String line = "";
            boolean current_class = false;
            Vector<String> result = new Vector<String>();
            int class_count = 0;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).indexOf("\"" + searchterm1) > 0 && line.indexOf(String.valueOf(searchterm2) + "\"") > 0 && line.startsWith("<owl:Class") && (lastline.startsWith("</") || lastline.endsWith("/>"))) {
                    current_class = true;
                    line = MatchmakerUtils.makeLineLocal(line);
                }
                if (current_class && line.startsWith("<owl:Class")) {
                    ++class_count;
                }
                if (current_class) {
                    result.add(line);
                }
                if (current_class && line.startsWith("</owl:Class") && --class_count <= 0) {
                    current_class = false;
                }
                lastline = line;
            }
            reader.close();
            return result;
        }
        catch (Exception e) {
            throw new MatchingException(e.getMessage());
        }
    }

    public static void appendClassVectorToOntologyFile(Vector classinfo, String ontologypath) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(ontologypath));
        Vector<String> tmp = new Vector<String>();
        String line = "";
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("</rdf:RDF>")) {
                int i = 0;
                while (i < classinfo.size()) {
                    tmp.add(String.valueOf((String)classinfo.get(i)) + "\n");
                    ++i;
                }
            }
            tmp.add(String.valueOf(line) + "\n");
        }
        reader.close();
        FileWriter writer = new FileWriter(ontologypath, false);
        int i = 0;
        while (i < tmp.size()) {
            writer.write((String)tmp.get(i));
            ++i;
        }
        writer.flush();
        writer.close();
    }

    public static Vector getURIList(ParameterList resourcen) {
        Iterator iter = resourcen.iterator();
        Vector<URI> urilist = new Vector<URI>();
        while (iter.hasNext()) {
            urilist.add(((Parameter)iter.next()).getParamType().getURI());
        }
        return urilist;
    }

    public static boolean setContainsService(ServiceEntry se, Set set) {
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            ServiceEntry entry = (ServiceEntry)iter.next();
            if (entry.ID != se.ID) continue;
            return true;
        }
        return false;
    }

    public static SortedSet mapToSortedSet(Map map) {
        TreeSet result = new TreeSet();
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            result.add(me.getValue());
        }
        return result;
    }

    public Set removeEntryFromSet(ServiceEntry entry1, Set set) {
        TreeSet<ServiceEntry> deleteSet = new TreeSet<ServiceEntry>();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            ServiceEntry tmpentry = (ServiceEntry)iter.next();
            if (entry1.ID != tmpentry.ID) continue;
            deleteSet.add(tmpentry);
        }
        set.removeAll(deleteSet);
        return set;
    }

    public static boolean existsEntryInSet(ServiceEntry entry1, Set set) {
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            ServiceEntry tmpentry = (ServiceEntry)iter.next();
            if (entry1.ID != tmpentry.ID) continue;
            return true;
        }
        return false;
    }

    public static void wait(int seconds) {
        System.gc();
        try {
            Thread.sleep(1000 * seconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void wait(double seconds) {
        System.gc();
        try {
            Thread.sleep((int)(1000.0 * seconds));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

