/*
 * Decompiled with CFR 0.152.
 */
package owlsmx.utils;

import owlsmx.similaritymeasures.SimilarityMeasures;

public class MathUtils {
    public static final double log2 = Math.log(2.0);

    public static double vectorNorm(double[] vector) {
        return Math.sqrt(MathUtils.vectorDotProduct(vector, vector));
    }

    public static double vectorDotProduct(double[] v1, double[] v2) {
        if (v1.length != v2.length) {
            return 0.0;
        }
        double sum = 0.0;
        int i = 0;
        while (i < v1.length) {
            sum += v1[i] * v2[i];
            ++i;
        }
        return sum;
    }

    public static double vectorNorm(int[] vector) {
        return Math.sqrt(MathUtils.vectorDotProduct(vector, vector));
    }

    public static double vectorDotProduct(int[] v1, int[] v2) {
        if (v1.length != v2.length) {
            return 0.0;
        }
        double sum = 0.0;
        int i = 0;
        while (i < v1.length) {
            sum += (double)(v1[i] * v2[i]);
            ++i;
        }
        return sum;
    }

    public static int vectorSum(int[] vector) {
        int sum = 0;
        int i = 0;
        while (i < vector.length) {
            sum += vector[i];
            ++i;
        }
        return sum;
    }

    public static double vectorSum(double[] vector) {
        double sum = 0.0;
        int i = 0;
        while (i < vector.length) {
            sum += vector[i];
            ++i;
        }
        return sum;
    }

    public static void main(String[] args) {
        System.out.println("Testing MathUtils:");
        double[] fun = new double[]{1.0, 1.0, 1.0, 1.0};
        System.out.println("");
        System.out.println("Testing vectorNorm");
        if (MathUtils.vectorNorm(fun) == 2.0) {
            System.out.println("                    Success");
        } else {
            System.out.println("                    Fail");
        }
        System.out.println("");
        System.out.println("Testing vectorDotProduct");
        if (MathUtils.vectorDotProduct(fun, fun) == 4.0) {
            System.out.println("                    Success");
        } else {
            System.out.println("                    Fail");
        }
        System.out.println("");
        System.out.println("Testing vectorSum");
        if (MathUtils.vectorSum(fun) == 4.0) {
            System.out.println("                    Success");
        } else {
            System.out.println("                    Fail");
        }
        System.out.println("Testing CosineSimilarity:");
        int[] tf1 = new int[]{1, 4};
        SimilarityMeasures similar = new SimilarityMeasures();
        double[] result = similar.logrithmicTermFrequency(tf1);
        int i = 0;
        while (i < result.length) {
            System.out.print(String.valueOf(result[i]) + " ");
            ++i;
        }
    }

    public static String toString(double[] vector) {
        String result = "";
        int i = 0;
        while (i < vector.length) {
            result = String.valueOf(result) + " " + vector[i];
            ++i;
        }
        return result.trim();
    }

    public static String toString(int[] vector) {
        String result = "";
        int i = 0;
        while (i < vector.length) {
            result = String.valueOf(result) + " " + vector[i];
            ++i;
        }
        return result.trim();
    }
}

