/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.io.owl_rdf;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.io.Renderer;
import org.semanticweb.owl.io.owl_rdf.RenderingConstants;
import org.semanticweb.owl.model.OWLAnd;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataEnumeration;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyInstance;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentPropertiesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLFunctionalPropertyAxiom;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualTypeAssertion;
import org.semanticweb.owl.model.OWLInverseFunctionalPropertyAxiom;
import org.semanticweb.owl.model.OWLInversePropertyAxiom;
import org.semanticweb.owl.model.OWLNot;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyInstance;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOr;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSubPropertyAxiom;
import org.semanticweb.owl.model.OWLSymmetricPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitivePropertyAxiom;
import org.semanticweb.owl.model.helper.OWLObjectVisitorAdapter;

public class RenderingVisitor
extends OWLObjectVisitorAdapter
implements RenderingConstants {
    protected StringWriter sw;
    protected PrintWriter pw;
    protected int level;
    boolean indenting = true;
    String property;
    OWLObject propertyObject;

    public RenderingVisitor(Renderer renderer) {
        this.reset();
        this.level = 0;
    }

    public void setLevel(int i) {
        this.level = i;
    }

    private void setProperty(String p) {
        this.property = p;
    }

    private void setPropertyObject(OWLObject d) {
        this.propertyObject = d;
    }

    public RenderingVisitor() {
        this.reset();
        this.property = null;
        this.propertyObject = null;
    }

    public String result() {
        return this.sw.toString();
    }

    public void reset() {
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
    }

    public void visit(OWLClass clazz) throws OWLException {
        this.pw.println(this.indent() + "<owl:Class rdf:about=\"" + clazz.getURI().toString() + "\">");
        ++this.level;
        this.addPropertyObject();
        --this.level;
        this.pw.println(this.indent() + "</owl:Class>");
    }

    public void visit(OWLIndividual ind) throws OWLException {
        this.pw.println(this.indent() + "<owl:Thing rdf:about=\"" + ind.getURI().toString() + "\">");
        ++this.level;
        this.addPropertyObject();
        --this.level;
        this.pw.println(this.indent() + "</owl:Thing>");
    }

    public void visit(OWLEquivalentPropertiesAxiom axiom) throws OWLException {
        Set properties = axiom.getProperties();
        if (properties.size() != 2) {
            throw new OWLException("Multiple Property Equivalence not yet supported");
        }
        Object[] props = properties.toArray();
        OWLProperty p1 = (OWLProperty)props[0];
        OWLProperty p2 = (OWLProperty)props[1];
        this.setProperty("owl:equivalentProperty");
        this.setPropertyObject((OWLObject)p1);
        p2.accept((OWLObjectVisitor)this);
    }

    public void visit(OWLObjectProperty prop) throws OWLException {
        this.pw.println(this.indent() + "<owl:ObjectProperty rdf:about=\"" + prop.getURI().toString() + "\">");
        ++this.level;
        this.addPropertyObject();
        --this.level;
        this.pw.println(this.indent() + "</owl:ObjectProperty>");
    }

    public void visit(OWLDataProperty prop) throws OWLException {
        this.pw.println(this.indent() + "<owl:DatatypeProperty rdf:about=\"" + prop.getURI().toString() + "\">");
        ++this.level;
        this.addPropertyObject();
        --this.level;
        this.pw.println(this.indent() + "</owl:DatatypeProperty>");
    }

    public void visit(OWLAnd and) throws OWLException {
        this.pw.println(this.indent() + "<owl:Class>");
        ++this.level;
        this.addPropertyObject();
        this.pw.println(this.indent() + "<owl:intersectionOf rdf:parseType=\"Collection\">");
        Iterator it = and.getOperands().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            ++this.level;
            desc.accept((OWLObjectVisitor)this);
            --this.level;
        }
        this.pw.println(this.indent() + "</owl:intersectionOf>");
        --this.level;
        this.pw.println(this.indent() + "</owl:Class>");
    }

    public void visit(OWLOr or) throws OWLException {
        this.pw.println(this.indent() + "<owl:Class>");
        ++this.level;
        this.addPropertyObject();
        this.pw.println(this.indent() + "<owl:unionOf rdf:parseType=\"Collection\">");
        Iterator it = or.getOperands().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            ++this.level;
            desc.accept((OWLObjectVisitor)this);
            --this.level;
        }
        this.pw.println(this.indent() + "</owl:unionOf>");
        --this.level;
        this.pw.println(this.indent() + "</owl:Class>");
    }

    public void visit(OWLNot not) throws OWLException {
        this.pw.println(this.indent() + "<owl:Class>");
        ++this.level;
        this.addPropertyObject();
        this.pw.println(this.indent() + "<owl:complementOf>");
        OWLDescription desc = not.getOperand();
        ++this.level;
        desc.accept((OWLObjectVisitor)this);
        --this.level;
        this.pw.println(this.indent() + "</owl:complementOf>");
        --this.level;
        this.pw.println(this.indent() + "</owl:Class>");
    }

    public void visit(OWLEnumeration enumeration) throws OWLException {
        this.pw.println(this.indent() + "<owl:Class>");
        ++this.level;
        this.addPropertyObject();
        this.pw.println(this.indent() + "<owl:oneOf rdf:parseType=\"Collection\">");
        Iterator it = enumeration.getIndividuals().iterator();
        while (it.hasNext()) {
            OWLIndividual desc = (OWLIndividual)it.next();
            this.pw.print("");
            ++this.level;
            desc.accept((OWLObjectVisitor)this);
            --this.level;
        }
        this.pw.println(this.indent() + "</owl:oneOf>");
        --this.level;
        this.pw.println(this.indent() + "</owl:Class>");
    }

    public void visit(OWLObjectSomeRestriction restriction) throws OWLException {
        this.pw.println(this.indent() + "<owl:Restriction>");
        ++this.level;
        this.addPropertyObject();
        this.pw.println(this.indent() + "<owl:onProperty rdf:resource=\"" + restriction.getObjectProperty().getURI().toString() + "\" />");
        this.pw.println(this.indent() + "<owl:someValuesFrom>");
        ++this.level;
        restriction.getDescription().accept((OWLObjectVisitor)this);
        --this.level;
        this.pw.println(this.indent() + "</owl:someValuesFrom>");
        --this.level;
        this.pw.println(this.indent() + "</owl:Restriction>");
    }

    public void visit(OWLObjectAllRestriction restriction) throws OWLException {
        this.pw.println(this.indent() + "<owl:Restriction>");
        ++this.level;
        this.addPropertyObject();
        this.pw.println(this.indent() + "<owl:onProperty rdf:resource=\"" + restriction.getObjectProperty().getURI().toString() + "\" />");
        this.pw.println(this.indent() + "<owl:allValuesFrom>");
        ++this.level;
        restriction.getDescription().accept((OWLObjectVisitor)this);
        --this.level;
        this.pw.println(this.indent() + "</owl:allValuesFrom>");
        --this.level;
        this.pw.println(this.indent() + "</owl:Restriction>");
    }

    public void visit(OWLObjectValueRestriction restriction) throws OWLException {
        this.pw.println(this.indent() + "<owl:Restriction>");
        ++this.level;
        this.addPropertyObject();
        this.pw.println(this.indent() + "<owl:onProperty rdf:resource=\"" + restriction.getObjectProperty().getURI().toString() + "\" />");
        this.pw.println(this.indent() + "<owl:hasValue rdf.resource=\"" + restriction.getIndividual().getURI() + "\" />");
        --this.level;
        this.pw.println(this.indent() + "</owl:Restriction>");
    }

    public void visit(OWLObjectCardinalityRestriction restriction) throws OWLException {
        this.pw.println(this.indent() + "<owl:Restriction>");
        ++this.level;
        this.addPropertyObject();
        this.pw.println(this.indent() + "<owl:onProperty rdf:resource=\"" + restriction.getObjectProperty().getURI().toString() + "\" />");
        if (restriction.isExactly()) {
            this.pw.println(this.indent() + "<owl:cardinality rdf:datatype=\"&xsd;nonNegativeInteger\">" + restriction.getAtMost() + "</owl:cardinality>");
        } else if (restriction.isAtMost()) {
            this.pw.println(this.indent() + "<owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">" + restriction.getAtMost() + "</owl:maxCardinality>");
        } else if (restriction.isAtLeast()) {
            this.pw.println(this.indent() + "<owl:minCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">" + restriction.getAtLeast() + "</owl:minCardinality>");
        }
        --this.level;
        this.pw.println(this.indent() + "</owl:Restriction>");
    }

    public void visit(OWLDataSomeRestriction restriction) throws OWLException {
        this.pw.println(this.indent() + "<owl:Restriction>");
        ++this.level;
        this.addPropertyObject();
        this.pw.println(this.indent() + "<owl:onProperty rdf:resource=\"" + restriction.getDataProperty().getURI().toString() + "\" />");
        this.pw.println(this.indent() + "<owl:someValuesFrom>");
        ++this.level;
        restriction.getDataType().accept((OWLObjectVisitor)this);
        --this.level;
        this.pw.println(this.indent() + "</owl:someValuesFrom>");
        --this.level;
        this.pw.println(this.indent() + "</owl:Restriction>");
    }

    public void visit(OWLDataAllRestriction restriction) throws OWLException {
        this.pw.println(this.indent() + "<owl:Restriction>");
        ++this.level;
        this.addPropertyObject();
        this.pw.println(this.indent() + "<owl:onProperty rdf:resource=\"" + restriction.getDataProperty().getURI().toString() + "\" />");
        this.pw.println(this.indent() + "<owl:allValuesFrom>");
        ++this.level;
        restriction.getDataType().accept((OWLObjectVisitor)this);
        --this.level;
        this.pw.println(this.indent() + "</owl:allValuesFrom>");
        --this.level;
        this.pw.println(this.indent() + "</owl:Restriction>");
    }

    public void visit(OWLDataValueRestriction restriction) throws OWLException {
        this.pw.println(this.indent() + "<owl:Restriction>");
        ++this.level;
        this.addPropertyObject();
        this.pw.println(this.indent() + "<owl:onProperty rdf:resource=\"" + restriction.getDataProperty().getURI().toString() + "\" />");
        this.pw.print(this.indent() + "<owl:hasValue");
        OWLDataValue odv = restriction.getValue();
        if (odv.getURI() != null) {
            this.pw.print(" rdf:datatype=\"" + odv.getURI() + "\"");
        }
        if (odv.getLang() != null) {
            this.pw.print(" xml:lang=\"" + odv.getLang() + "\"");
        }
        this.pw.print(">");
        this.pw.print(odv.getValue().toString());
        this.pw.println("</owl:hasValue>");
        --this.level;
        this.pw.println(this.indent() + "</owl:Restriction>");
    }

    public void visit(OWLDataCardinalityRestriction restriction) throws OWLException {
        this.pw.println(this.indent() + "<owl:Restriction>");
        ++this.level;
        this.addPropertyObject();
        this.pw.println(this.indent() + "<owl:onProperty rdf:resource=\"" + restriction.getDataProperty().getURI().toString() + "\" />");
        if (restriction.isExactly()) {
            this.pw.println(this.indent() + "<owl:cardinality rdf:datatype=\"&xsd;nonNegativeInteger\">" + restriction.getAtMost() + "</owl:cardinality>");
        } else if (restriction.isAtMost()) {
            this.pw.println(this.indent() + "<owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">" + restriction.getAtMost() + "</owl:maxCardinality>");
        } else if (restriction.isAtLeast()) {
            this.pw.println(this.indent() + "<owl:minCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">" + restriction.getAtLeast() + "</owl:minCardinality>");
        }
        --this.level;
        this.pw.println(this.indent() + "</owl:Restriction>");
    }

    public void visit(OWLDataType datatype) throws OWLException {
        this.pw.println(this.indent() + "<rdfs:Datatype rdf:about=\"" + datatype.getURI().toString() + "\"/>");
    }

    public void visit(OWLDataEnumeration enumeration) throws OWLException {
        throw new OWLException("Data Enumeration Rendering not yet supported");
    }

    public void visit(OWLEquivalentClassesAxiom axiom) throws OWLException {
        OWLDescription[] descs = axiom.getEquivalentClasses().toArray(new OWLDescription[axiom.getEquivalentClasses().size()]);
        for (int i = 0; i < descs.length - 1; ++i) {
            this.setProperty("owl:equivalentClass");
            this.setPropertyObject((OWLObject)descs[i]);
            descs[i + 1].accept((OWLObjectVisitor)this);
        }
    }

    public void visit(OWLDisjointClassesAxiom axiom) throws OWLException {
        OWLDescription[] descs = axiom.getDisjointClasses().toArray(new OWLDescription[axiom.getDisjointClasses().size()]);
        for (int i = 0; i < descs.length; ++i) {
            for (int j = i + 1; j < descs.length; ++j) {
                this.setProperty("owl:disjointWith");
                this.setPropertyObject((OWLObject)descs[i]);
                descs[j].accept((OWLObjectVisitor)this);
            }
        }
    }

    public void visit(OWLSubClassAxiom axiom) throws OWLException {
        OWLDescription sub = axiom.getSubClass();
        OWLDescription sup = axiom.getSuperClass();
        this.setProperty("rdfs:subClassOf");
        this.setPropertyObject((OWLObject)sup);
        sub.accept((OWLObjectVisitor)this);
    }

    public void visit(OWLSubPropertyAxiom axiom) throws OWLException {
        OWLProperty sub = axiom.getSubProperty();
        OWLProperty sup = axiom.getSuperProperty();
        this.setProperty("rdfs:subPropertyOf");
        this.setPropertyObject((OWLObject)sup);
        sub.accept((OWLObjectVisitor)this);
    }

    protected void addPropertyObject() throws OWLException {
        if (this.property != null) {
            String name = this.property;
            this.pw.println(this.indent() + "<" + name + ">");
            this.setProperty(null);
            this.propertyObject.accept((OWLObjectVisitor)this);
            this.pw.println(this.indent() + "</" + name + ">");
        }
    }

    private String indent() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.level; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }

    public void visit(OWLFunctionalPropertyAxiom node) throws OWLException {
    }

    public void visit(OWLInverseFunctionalPropertyAxiom node) throws OWLException {
    }

    public void visit(OWLTransitivePropertyAxiom node) throws OWLException {
    }

    public void visit(OWLSymmetricPropertyAxiom node) throws OWLException {
    }

    public void visit(OWLInversePropertyAxiom node) throws OWLException {
    }

    public void visit(OWLPropertyDomainAxiom node) throws OWLException {
    }

    public void visit(OWLObjectPropertyRangeAxiom node) throws OWLException {
    }

    public void visit(OWLDataPropertyRangeAxiom node) throws OWLException {
    }

    public void visit(OWLObjectPropertyInstance node) throws OWLException {
    }

    public void visit(OWLDataPropertyInstance node) throws OWLException {
    }

    public void visit(OWLIndividualTypeAssertion node) throws OWLException {
    }
}

