/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import java.util.ArrayList;
import java.util.List;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.query.QueryResultBinding;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.query.QueryUtils;

public class PelletResultSet
implements ResultSet {
    private Model model;
    private List<String> resultVars;
    private List<ATermAppl> varTerms;
    private QueryResults answers;
    private int index;
    private int size;
    private Binding parent;

    public PelletResultSet(QueryResults answers, Model model) {
        this(answers, model, null);
    }

    public PelletResultSet(QueryResults answers, Model model, Binding parent) {
        this.answers = answers;
        this.model = model;
        this.parent = parent;
        this.index = 0;
        this.size = answers.size();
        this.varTerms = answers.getResultVars();
    }

    public QueryResults getAnswers() {
        return this.answers;
    }

    public boolean hasNext() {
        return this.index < this.size;
    }

    public Binding nextBinding() {
        QueryResultBinding binding = this.answers.get(this.index++);
        BindingMap result = this.parent == null ? new BindingMap() : new BindingMap(this.parent);
        for (ATermAppl var : this.varTerms) {
            String varName = QueryUtils.getVarName(var);
            ATermAppl value = binding.getValue(var);
            Node node = JenaUtils.makeGraphNode((ATermAppl)value);
            result.add(Var.alloc((String)varName), node);
        }
        return result;
    }

    public QuerySolution nextSolution() {
        return new ResultBinding(this.model, this.nextBinding());
    }

    public Object next() {
        return this.nextSolution();
    }

    public boolean isDistinct() {
        return false;
    }

    public boolean isOrdered() {
        return false;
    }

    public int getRowNumber() {
        return this.index;
    }

    public List getResultVars() {
        if (this.resultVars == null) {
            this.resultVars = new ArrayList<String>(this.varTerms.size());
            for (ATermAppl var : this.varTerms) {
                String varName = QueryUtils.getVarName(var);
                this.resultVars.add(varName);
            }
        }
        return this.resultVars;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot remove from QueryResults");
    }

    public String toString() {
        return this.answers.toString();
    }

    public Model getResourceModel() {
        return this.model;
    }
}

