/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.impl;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIComponents;
import com.hp.hpl.jena.iri.MalformedIDNException;
import com.hp.hpl.jena.iri.Violation;
import com.hp.hpl.jena.iri.ViolationCodes;
import com.hp.hpl.jena.iri.impl.IRIImpl;
import com.hp.hpl.jena.iri.impl.Parser;
import com.hp.hpl.jena.iri.impl.ResolvedRelativeIRI;
import com.hp.hpl.jena.iri.impl.SchemeSpecificPart;
import com.hp.hpl.jena.iri.impl.ViolationImpl;
import com.ibm.icu.text.IDNA;
import com.ibm.icu.text.StringPrepParseException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbsIRIImpl
extends IRI
implements ViolationCodes,
IRIComponents {
    private static final int defaultRelative = 61;
    private long foundExceptionMask;
    long allErrors;
    private ArrayList foundExceptions;
    protected String path;
    private static final char[] hex = "0123456789ABCDEF".toCharArray();
    static final Iterator nullIterator = new ArrayList(0).iterator();
    protected static final int NO_EXCEPTIONS = 1;
    protected static final int ALL_EXCEPTIONS = 2;
    protected static final int NOT_RELATIVE_EXCEPTIONS = 3;
    protected static final int PATH_INDEX = Parser.invFields[11];
    static long ToAsciiMask = -1L;
    private static int[][] prefs = new int[][]{{8, 56}, {16, 48}, {32, 32}};
    static String[] exact = new String[]{".", "..", "../.."};
    static String[] sub = new String[]{"", "../", "../../"};

    static String removeDotSegments(String path) {
        int inputBufferStart = 0;
        int inputBufferEnd = path.length();
        StringBuffer output = new StringBuffer();
        while (inputBufferStart < inputBufferEnd) {
            String in = path.substring(inputBufferStart);
            if (in.startsWith("./")) {
                inputBufferStart += 2;
                continue;
            }
            if (in.startsWith("../")) {
                inputBufferStart += 3;
                continue;
            }
            if (in.startsWith("/./")) {
                inputBufferStart += 2;
                continue;
            }
            if (in.equals("/.")) {
                in = "/";
                inputBufferStart += 2;
            }
            if (in.startsWith("/../")) {
                inputBufferStart += 3;
                AbsIRIImpl.removeLastSeqment(output);
                continue;
            }
            if (in.equals("/..")) {
                in = "/";
                inputBufferStart += 3;
                AbsIRIImpl.removeLastSeqment(output);
            }
            if (in.equals(".")) {
                ++inputBufferStart;
                continue;
            }
            if (in.equals("..")) {
                inputBufferStart += 2;
                continue;
            }
            int nextSlash = in.indexOf(47, 1);
            if (nextSlash == -1) {
                nextSlash = in.length();
            }
            inputBufferStart += nextSlash;
            output.append(in.substring(0, nextSlash));
        }
        return output.toString();
    }

    private static void removeLastSeqment(StringBuffer output) {
        int ix = output.length();
        while (ix > 0 && output.charAt(--ix) != '/') {
        }
        output.setLength(ix);
    }

    abstract long errors(int var1);

    abstract SchemeSpecificPart getSchemeSpec();

    boolean hasExceptionMask(long mask) {
        return (this.allErrors & mask) != 0L;
    }

    Iterator exceptionsMask(final long mask) {
        this.createExceptions(mask);
        return this.foundExceptions == null ? nullIterator : new Iterator(){
            private Iterator underlying;
            private Object next;
            {
                this.underlying = AbsIRIImpl.this.foundExceptions.iterator();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                if (this.next == null) {
                    while (this.underlying.hasNext()) {
                        this.next = this.underlying.next();
                        if ((1L << ((Violation)this.next).getViolationCode() & mask) == 0L) continue;
                        return true;
                    }
                    this.next = null;
                    return false;
                }
                return true;
            }

            public Object next() {
                if (this.hasNext()) {
                    Object rslt = this.next;
                    this.next = null;
                    return rslt;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private void createExceptions(long m) {
        if ((this.allErrors & (m &= this.foundExceptionMask ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            if (this.foundExceptions == null) {
                this.foundExceptions = new ArrayList();
            }
            for (int i = 0; i < Parser.fields.length; ++i) {
                int f = Parser.fields[i];
                if ((this.errors(f) & m) == 0L) continue;
                for (int e = 0; e < 64; ++e) {
                    if ((1L << e & m & this.errors(f)) == 0L) continue;
                    this.foundExceptions.add(new ViolationImpl(this, f, e));
                }
            }
        }
        this.foundExceptionMask |= m;
    }

    public boolean isAbsolute() {
        return this.has(2);
    }

    abstract boolean has(int var1);

    public boolean isRelative() {
        return !this.has(2);
    }

    public boolean hasViolation(boolean includeWarnings) {
        return this.hasExceptionMask(this.getSchemeSpec().getMask(includeWarnings));
    }

    public Iterator violations(boolean includeWarnings) {
        return this.exceptionsMask(this.getSchemeSpec().getMask(includeWarnings));
    }

    public URL toURL() throws MalformedURLException {
        return new URL(this.toASCIIString());
    }

    public String toASCIIString() throws MalformedURLException {
        if (this.hasExceptionMask(ToAsciiMask)) {
            return this.createASCIIString();
        }
        return this.toString();
    }

    private String createASCIIString() throws MalformedURLException {
        StringBuffer asciiString = new StringBuffer();
        if (this.has(2)) {
            this.toAscii(asciiString, this.getScheme(), this.errors(2));
            asciiString.append(':');
        }
        if (this.has(4)) {
            asciiString.append("//");
            if (this.has(6)) {
                this.toAscii(asciiString, this.getRawUserinfo(), this.errors(6));
                asciiString.append('@');
            }
            String host = this.getRawHost();
            this.regNameToAscii(asciiString, host);
            if (this.has(10)) {
                asciiString.append(':');
                this.toAscii(asciiString, this.get(10), this.errors(6));
            }
        }
        this.toAscii(asciiString, this.getRawPath(), this.errors(11));
        if (this.has(13)) {
            asciiString.append('?');
            this.toAscii(asciiString, this.getRawQuery(), this.errors(13));
        }
        if (this.has(15)) {
            asciiString.append('#');
            this.toAscii(asciiString, this.getRawFragment(), this.errors(15));
        }
        return asciiString.toString();
    }

    private void regNameToAscii(StringBuffer asciiString, String host) throws MalformedURLException {
        if ((this.errors(7) & ToAsciiMask) == 0L) {
            asciiString.append(host);
            return;
        }
        asciiString.append(AbsIRIImpl.domainToAscii(host));
    }

    static StringBuffer domainToAscii(String host) throws MalformedIDNException {
        try {
            return IDNA.convertIDNToASCII((String)host, (int)3);
        }
        catch (StringPrepParseException e) {
            throw new MalformedIDNException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MalformedIDNException(new StringPrepParseException("The labels in the input are too long. Length > 64.", 8, host, 0));
        }
    }

    private void toAscii(StringBuffer asciiString, String field, long errs) {
        if ((errs & ToAsciiMask) == 0L) {
            asciiString.append(field);
            return;
        }
        for (int i = 0; i < field.length(); ++i) {
            char ch = field.charAt(i);
            if (ch > '\u007f' || "<>\" {}|\\^`".indexOf(ch) != -1 || ch < ' ') {
                byte[] b;
                try {
                    b = field.substring(i, i + 1).getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Impossible - utf-8 unsupported");
                }
                for (int j = 0; j < b.length; ++j) {
                    char[] buf = new char[]{'%', hex[(b[j] & 0xF0) >> 4], hex[b[j] & 0xF]};
                    asciiString.append(buf);
                }
                continue;
            }
            asciiString.append(new char[]{ch});
        }
    }

    public IRI relativize(String abs, int flags) {
        return this.relativize(new IRIImpl(this.getFactory(), abs), flags);
    }

    public IRI relativize(String abs) {
        return this.relativize(abs, 61);
    }

    public IRI relativize(IRI abs) {
        return this.relativize(abs, 61);
    }

    public IRI relativize(IRI abs, int flags) {
        String rslt = this.relativize(abs, null, flags);
        return rslt == null ? abs : this.getFactory().create(rslt);
    }

    private String relativize(IRI r, String def, int flags) {
        String[] m_subPaths;
        String rslt;
        if (!this.has(4)) {
            return def;
        }
        if (!((AbsIRIImpl)r).has(4)) {
            return def;
        }
        boolean net = this.equal(r.getScheme(), this.getScheme());
        boolean absl = net && this.equal(r.getRawHost(), this.getRawHost()) && this.equal(this.getRawUserinfo(), r.getRawUserinfo()) && this.equal(this.getPort(), r.getPort());
        boolean same = absl && this.equal(this.getRawPath(), r.getRawPath()) && this.equal(this.getRawQuery(), r.getRawQuery());
        String string = rslt = r.getRawFragment() == null ? "" : "#" + r.getRawFragment();
        if (same && (flags & 1) != 0) {
            return rslt;
        }
        if (r.getRawQuery() != null) {
            rslt = "?" + r.getRawQuery() + rslt;
        }
        if (absl && (m_subPaths = new String[]{this.getRawPath() == null ? null : this.getRawPath() + "a", null, null, null})[0] != null) {
            for (int i = 0; i < 3 && (flags & prefs[i][1]) != 0; ++i) {
                if (m_subPaths[i + 1] == null) {
                    m_subPaths[i + 1] = AbsIRIImpl.getLastSlash(m_subPaths[i]);
                }
                if (m_subPaths[i + 1].length() == 0) break;
                if ((flags & prefs[i][0]) == 0 || !r.getRawPath().startsWith(m_subPaths[i + 1])) continue;
                int lg = m_subPaths[i + 1].length();
                if (lg == r.getRawPath().length()) {
                    return exact[i] + rslt;
                }
                rslt = AbsIRIImpl.maybeDotSlash(sub[i] + r.getRawPath().substring(lg) + rslt);
                return rslt;
            }
        }
        rslt = r.getRawPath() + rslt;
        if (absl && (flags & 4) != 0) {
            return rslt;
        }
        if (net && (flags & 2) != 0) {
            return "//" + (r.getRawUserinfo() == null ? "" : r.getRawUserinfo() + "@") + r.getRawHost() + (r.getPort() == -1 ? "" : ":" + ((AbsIRIImpl)r).get(10)) + rslt;
        }
        return def;
    }

    private static String maybeDotSlash(String path) {
        int colon = path.indexOf(58);
        if (colon == -1) {
            return path;
        }
        int slash = path.indexOf(47);
        if (slash == -1 || slash > colon) {
            return "./" + path;
        }
        return path;
    }

    private static String getLastSlash(String s) {
        int ix = s.lastIndexOf(47, s.length() - 2);
        return s.substring(0, ix + 1);
    }

    private boolean equal(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    private boolean equal(int s1, int s2) {
        return s1 == s2;
    }

    public Iterator allViolations() {
        return this.exceptionsMask(-1L);
    }

    public String getRawUserinfo() {
        return this.get(6);
    }

    public int getPort() {
        String port = this.get(10);
        if (port == null) {
            return -1;
        }
        try {
            int v = Integer.parseInt(port);
            if (v < 0) {
                return -2;
            }
            return v;
        }
        catch (Exception e) {
            return -2;
        }
    }

    public String getRawQuery() {
        return this.get(13);
    }

    public String getRawFragment() {
        return this.get(15);
    }

    public String getRawHost() {
        return this.get(7);
    }

    public String getScheme() {
        return this.get(2);
    }

    abstract String get(int var1);

    public String getRawPath() {
        return this.path;
    }

    public boolean isRootless() {
        if (!this.has(2)) {
            return false;
        }
        if (this.has(4)) {
            return false;
        }
        if (this.path.equals("")) {
            return false;
        }
        return this.path.charAt(0) != '/';
    }

    abstract String pathRemoveDots();

    abstract boolean dotsOK();

    public String getRawAuthority() {
        return this.get(4);
    }

    public IRI create(IRI i) {
        return new ResolvedRelativeIRI(this, (AbsIRIImpl)this.getFactory().create(i));
    }

    public IRI create(String s) {
        return this.create(new IRIImpl(this.getFactory(), s));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof IRI)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getAuthority() {
        return this.getCooked(4);
    }

    public String getFragment() {
        return this.getCooked(15);
    }

    public String getHost() {
        return this.getCooked(7);
    }

    public String getPath() {
        return this.getCooked(11);
    }

    public String getQuery() {
        return this.getCooked(13);
    }

    public String getUserinfo() {
        return this.getCooked(6);
    }

    private String getCooked(int component) {
        return null;
    }

    public IRI normalize(boolean useDns) {
        return null;
    }

    public String toDisplayString() {
        return "\u202a" + this.toString() + "\u202c";
    }

    public String getASCIIHost() throws MalformedURLException {
        StringBuffer asciiString = new StringBuffer();
        String host = this.getRawHost();
        if (host == null) {
            return null;
        }
        this.regNameToAscii(asciiString, host);
        return asciiString.toString();
    }

    public boolean ladderEquals(IRI iri, int other) {
        return false;
    }

    public int ladderEquals(IRI iri) {
        return 0;
    }
}

