/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.impl;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIComponents;
import com.hp.hpl.jena.iri.ViolationCodes;
import com.hp.hpl.jena.iri.impl.AbsIRIFactoryImpl;
import com.hp.hpl.jena.iri.impl.AbsIRIImpl;
import com.hp.hpl.jena.iri.impl.Force;
import com.hp.hpl.jena.iri.impl.Parser;
import com.hp.hpl.jena.iri.impl.SchemeSpecificPart;
import com.hp.hpl.jena.iri.impl.SchemeSpecification;
import com.hp.hpl.jena.iri.impl.Specification;
import java.io.UnsupportedEncodingException;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IRIFactoryImpl
extends AbsIRIFactoryImpl
implements ViolationCodes,
Force,
IRIComponents {
    public static final int UNKNOWN_SYNTAX = -4;
    protected long errors;
    protected long warnings;
    private String encoding = "utf-8";
    boolean[] asErrors = new boolean[]{true, true, false, true, true, true};
    boolean[] asWarnings = new boolean[]{false, false, true, false, false, false};
    private boolean initializing = true;
    private Set backwardCompatibleRelativeRefs = new HashSet();
    private NoScheme unregisteredScheme = null;
    private NoScheme nonIETFScheme = null;
    private final NoScheme noScheme = new NoScheme();
    private int required = 0;
    private int prohibited = 0;
    private final Map schemes = new HashMap();

    public IRIFactoryImpl() {
    }

    public IRIFactoryImpl(IRIFactoryImpl template) {
        this.backwardCompatibleRelativeRefs = template.backwardCompatibleRelativeRefs;
        this.encoding = template.encoding;
        this.errors = template.errors;
        this.prohibited = template.prohibited;
        this.required = template.required;
        this.warnings = template.warnings;
        System.arraycopy(template.asErrors, 0, this.asErrors, 0, this.asErrors.length);
        System.arraycopy(template.asWarnings, 0, this.asWarnings, 0, this.asWarnings.length);
        Iterator it = template.schemes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            SchemeSpecificPart p = (SchemeSpecificPart)entry.getValue();
            if (p.withScheme()) {
                this.schemes.put(entry.getKey(), new WithScheme((WithScheme)p));
                continue;
            }
            if (p.port() == -1) continue;
            this.schemes.put(entry.getKey(), new NoScheme(p.port()));
        }
    }

    private final long getMask(boolean includeWarnings) {
        return includeWarnings ? this.errors | this.warnings : this.errors;
    }

    protected IRIFactoryImpl getFactory() {
        return this;
    }

    public IRI create(IRI i) {
        if (i instanceof AbsIRIImpl && ((AbsIRIImpl)i).getFactory() == this) {
            return i;
        }
        return this.create(i.toString());
    }

    boolean getSameSchemaRelativeReferences(String scheme) {
        return this.backwardCompatibleRelativeRefs.contains(scheme.toLowerCase());
    }

    String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String enc) throws UnsupportedEncodingException {
        "".getBytes(enc);
        this.encoding = enc;
    }

    protected void setViolation(int ix, boolean e, boolean w) {
        if (e && w) {
            throw new IllegalArgumentException("xxxViolation(true,true) is not permitted.");
        }
        this.initializing();
        this.asErrors[ix] = e;
        this.asWarnings[ix] = w;
    }

    protected boolean getAsWarnings(int ix) {
        return this.asWarnings[ix];
    }

    protected boolean getAsErrors(int ix) {
        return this.asErrors[ix];
    }

    protected void initializing() {
        if (!this.initializing) {
            throw new IllegalStateException("Cannot reinitialize IRIFactory after first use.");
        }
    }

    public IRI create(String s) {
        this.initializing = false;
        return super.create(s);
    }

    public void setSameSchemeRelativeReferences(String scheme) {
        if (scheme.equals("*")) {
            this.backwardCompatibleRelativeRefs = new AbstractSet(){

                public int size() {
                    return Integer.MAX_VALUE;
                }

                public Iterator iterator() {
                    throw new UnsupportedOperationException();
                }

                public boolean add(Object o) {
                    return false;
                }

                public boolean contains(Object o) {
                    return true;
                }
            };
        } else {
            this.backwardCompatibleRelativeRefs.add(scheme.toLowerCase());
        }
    }

    protected void useSpec(String name, boolean asErr) {
        this.initializing();
        Specification spec = Specification.get(name);
        for (int i = 0; i < 5; ++i) {
            if (this.asErrors[i] || this.asWarnings[i] && asErr) {
                this.errors |= spec.getErrors(i);
            }
            if (!this.asWarnings[i]) continue;
            this.warnings |= spec.getErrors(i);
        }
        this.prohibited |= spec.getProhibited();
        this.required |= spec.getRequired();
        this.warnings &= this.errors ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public SchemeSpecificPart getScheme(String scheme, Parser parser) {
        SchemeSpecificPart p = (SchemeSpecificPart)this.schemes.get(scheme = scheme.toLowerCase());
        if (p != null) {
            p.usedBy(parser);
            return p;
        }
        int dash = scheme.indexOf(45);
        if (dash != -1) {
            if (scheme.startsWith("x-")) {
                p = this.noScheme();
            } else {
                if (this.nonIETFScheme == null) {
                    this.nonIETFScheme = new NoScheme(){

                        void usedBy(Parser pp) {
                            pp.recordError(2, 46);
                        }
                    };
                }
                p = this.nonIETFScheme;
            }
        } else if (Specification.schemes.containsKey(scheme)) {
            SchemeSpecification spec = (SchemeSpecification)Specification.schemes.get(scheme);
            p = new NoScheme(spec.port);
        } else {
            if (this.unregisteredScheme == null) {
                this.unregisteredScheme = new NoScheme(){

                    void usedBy(Parser pp) {
                        pp.recordError(2, 45);
                    }
                };
            }
            p = this.unregisteredScheme;
        }
        p.usedBy(parser);
        if (this.schemes.size() < 1000) {
            this.schemes.put(scheme, p);
        }
        return p;
    }

    public SchemeSpecificPart noScheme() {
        return this.noScheme;
    }

    public int getRequired() {
        return this.required;
    }

    public int getProhibited() {
        return this.prohibited;
    }

    public void useSchemeSpecificRules(String scheme, boolean asErr) {
        if (scheme.equals("*")) {
            Iterator it = Specification.schemes.keySet().iterator();
            while (it.hasNext()) {
                scheme = (String)it.next();
                if (this.schemes.containsKey(scheme)) continue;
                this.useSchemeSpecificRules(scheme, asErr);
            }
            return;
        }
        SchemeSpecification spec = (SchemeSpecification)Specification.schemes.get(scheme = scheme.toLowerCase());
        if (spec == null) {
            this.schemes.put(scheme, this.noScheme);
        } else {
            this.schemes.put(scheme, new WithScheme(spec, asErr));
        }
    }

    private class NoScheme
    extends SchemeSpecificPart {
        private final int port;

        NoScheme() {
            this(-1);
        }

        NoScheme(int i) {
            this.port = i;
        }

        public long getMask(boolean includeWarnings) {
            return IRIFactoryImpl.this.getMask(includeWarnings);
        }

        public int getRequired() {
            return IRIFactoryImpl.this.getRequired();
        }

        public int getProhibited() {
            return IRIFactoryImpl.this.getProhibited();
        }

        void usedBy(Parser parser) {
        }

        public void analyse(Parser parser, int range) {
        }

        public int port() {
            return this.port;
        }

        public boolean withScheme() {
            return false;
        }
    }

    private class WithScheme
    extends SchemeSpecificPart {
        long zerrors;
        long zwarnings;
        int zrequired;
        int zprohibited;
        boolean inited = false;
        final SchemeSpecification scheme;

        private WithScheme(WithScheme ws) {
            this.zerrors = ws.zerrors;
            this.zwarnings = ws.zwarnings;
            this.zprohibited = ws.zprohibited;
            this.zrequired = ws.zrequired;
            this.scheme = ws.scheme;
        }

        private WithScheme(SchemeSpecification spec, boolean asErr) {
            this.scheme = spec;
            for (int i = 0; i < 5; ++i) {
                if (IRIFactoryImpl.this.asErrors[i] || IRIFactoryImpl.this.asWarnings[i] && asErr) {
                    this.zerrors |= spec.getErrors(i);
                }
                if (!IRIFactoryImpl.this.asWarnings[i]) continue;
                this.zwarnings |= spec.getErrors(i);
            }
        }

        void usedBy(Parser parser) {
            if (!this.inited) {
                this.inited = true;
                this.zerrors |= IRIFactoryImpl.this.errors;
                this.zwarnings |= IRIFactoryImpl.this.warnings;
                this.zwarnings &= this.zerrors ^ 0xFFFFFFFFFFFFFFFFL;
                this.zrequired = this.scheme.getRequired() | IRIFactoryImpl.this.required;
                this.zprohibited = this.scheme.getProhibited() | IRIFactoryImpl.this.prohibited;
            }
        }

        public long getMask(boolean includeWarnings) {
            return includeWarnings ? this.zerrors | this.zwarnings : this.zerrors;
        }

        public int getRequired() {
            return this.zrequired;
        }

        public int getProhibited() {
            return this.zprohibited;
        }

        public void analyse(Parser parser, int range) {
            this.scheme.analyse(parser, range);
        }

        public int port() {
            return this.scheme.port;
        }

        public boolean withScheme() {
            return false;
        }
    }
}

