/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation;

import aterm.ATermAppl;
import com.clarkparsia.explanation.SingleExplanationGeneratorImpl;
import com.clarkparsia.explanation.util.DefinitionTracker;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.TaxonomyUtils;
import org.semanticweb.owl.inference.OWLClassReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyChangeListener;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLOntologyURIMapper;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.model.RemoveAxiom;
import org.semanticweb.owl.util.SimpleURIMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassBoxExplanation
extends SingleExplanationGeneratorImpl {
    public static final Logger log;

    public static void setup() {
        PelletOptions.USE_TRACING = true;
    }

    public GlassBoxExplanation(OWLOntologyManager manager) {
        super(manager);
    }

    private OWLOntology createOntology(Set<OWLAxiom> axioms) {
        try {
            URI uri = URI.create("http://explanation.clarkparsia.com/ontology");
            SimpleURIMapper mapper = new SimpleURIMapper(uri, uri);
            this.owlOntologyManager.addURIMapper((OWLOntologyURIMapper)mapper);
            OWLOntology ontology = this.owlOntologyManager.createOntology(uri);
            this.owlOntologyManager.removeURIMapper((OWLOntologyURIMapper)mapper);
            ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
            for (OWLAxiom axiom : axioms) {
                changes.add(new AddAxiom(ontology, axiom));
            }
            this.owlOntologyManager.applyChanges(changes);
            return ontology;
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
        catch (OWLOntologyChangeException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public OWLClassReasoner getAltReasoner() {
        try {
            if (this.altReasoner == null) {
                log.fine("Create alt reasoner");
                this.altReasoner = this.reasonerFactory.createReasoner(this.owlOntologyManager);
                log.fine("Load ontology to the alt reasoner");
                this.altReasoner.loadOntologies(this.getOntologies());
                this.owlOntologyManager.addOntologyChangeListener((OWLOntologyChangeListener)this.altReasoner);
            }
            return this.altReasoner;
        }
        catch (OWLReasonerException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private OWLClass getNegation(OWLDescription desc) {
        if (!(desc instanceof OWLObjectComplementOf)) {
            return null;
        }
        OWLDescription not = ((OWLObjectComplementOf)desc).getOperand();
        if (not.isAnonymous()) {
            return null;
        }
        return (OWLClass)not;
    }

    private Pair<OWLClass, OWLClass> getSubClassAxiom(OWLDescription desc) {
        if (!(desc instanceof OWLObjectIntersectionOf)) {
            return null;
        }
        OWLObjectIntersectionOf conj = (OWLObjectIntersectionOf)desc;
        if (conj.getOperands().size() != 2) {
            return null;
        }
        Iterator conjuncts = conj.getOperands().iterator();
        OWLDescription c1 = (OWLDescription)conjuncts.next();
        OWLDescription c2 = (OWLDescription)conjuncts.next();
        OWLClass sub = null;
        OWLClass sup = null;
        if (!c1.isAnonymous()) {
            sub = (OWLClass)c1;
            sup = this.getNegation(c2);
        } else if (!c2.isAnonymous()) {
            sub = (OWLClass)c2;
            sup = this.getNegation(c2);
        }
        if (sup == null) {
            return null;
        }
        return new Pair<OWLClass, OWLClass>(sub, sup);
    }

    private Set<OWLAxiom> getCachedExplanation(OWLDescription unsatClass) {
        Set<Set<ATermAppl>> exps;
        Reasoner pellet = (Reasoner)this.reasoner;
        if (!pellet.getKB().isClassified()) {
            return null;
        }
        Pair<OWLClass, OWLClass> pair = this.getSubClassAxiom(unsatClass);
        if (pair != null && (exps = TaxonomyUtils.getSuperExplanations(pellet.getKB().getTaxonomy(), pellet.getLoader().term((OWLObject)pair.first), pellet.getLoader().term((OWLObject)pair.second))) != null) {
            Set<OWLAxiom> result = pellet.convertAxioms(exps.iterator().next());
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cached explanation: " + result);
            }
            return result;
        }
        return null;
    }

    public Set<OWLAxiom> getExplanation(OWLDescription unsatClass) {
        Set<OWLAxiom> result = null;
        boolean firstExplanation = this.isFirstExplanation();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Explain: " + unsatClass + " " + "First: " + firstExplanation);
        }
        if (firstExplanation) {
            result = this.getCachedExplanation(unsatClass);
            if (result == null) {
                result = this.getPelletExplanation(unsatClass);
            }
        } else {
            OWLClassReasoner savedReasoner = this.reasoner;
            this.reasoner = this.getAltReasoner();
            try {
                result = this.getPelletExplanation(unsatClass);
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, "Unexpected error while trying to get explanation set from Pellet", e);
                throw new OWLRuntimeException((Throwable)e);
            }
            finally {
                this.reasoner = savedReasoner;
            }
        }
        return result;
    }

    private Set<OWLAxiom> getPelletExplanation(OWLDescription unsatClass) {
        boolean sat;
        Reasoner pellet = (Reasoner)this.reasoner;
        pellet.getKB().prepare();
        boolean bl = sat = !this.definitionTracker.isDefined(unsatClass);
        if (!sat) {
            pellet.getKB().setDoExplanation(true);
            sat = pellet.isSatisfiable(unsatClass);
            pellet.getKB().setDoExplanation(false);
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Undefined entity in " + unsatClass);
        }
        if (sat) {
            return Collections.emptySet();
        }
        Set<OWLAxiom> explanation = pellet.getExplanation();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Explanation " + explanation);
        }
        Set<OWLAxiom> prunedExplanation = this.pruneExplanation(unsatClass, explanation, true);
        int prunedAxiomCount = explanation.size() - prunedExplanation.size();
        if (log.isLoggable(Level.FINE) && prunedAxiomCount > 0) {
            log.fine("Pruned " + prunedAxiomCount + " axioms from the explanation: " + SetUtils.difference(explanation, prunedExplanation));
            log.fine("New explanation " + prunedExplanation);
        }
        return prunedExplanation;
    }

    private Set<OWLAxiom> pruneExplanation(OWLDescription unsatClass, Set<OWLAxiom> explanation, boolean incremental) {
        try {
            HashSet<OWLAxiom> prunedExplanation = new HashSet<OWLAxiom>(explanation);
            if (prunedExplanation.size() <= 1) {
                return prunedExplanation;
            }
            OWLOntology debuggingOntology = this.createOntology(explanation);
            DefinitionTracker defTracker = new DefinitionTracker(this.owlOntologyManager);
            defTracker.setOntology(debuggingOntology);
            Reasoner reasoner = (Reasoner)this.reasonerFactory.createReasoner(this.owlOntologyManager);
            if (incremental) {
                this.owlOntologyManager.addOntologyChangeListener((OWLOntologyChangeListener)reasoner);
                reasoner.loadOntology(debuggingOntology);
            }
            if (!defTracker.isDefined(unsatClass)) {
                log.warning("Some of the entities in " + unsatClass + " are not defined in the explanation " + explanation);
            }
            if (reasoner.isSatisfiable(unsatClass)) {
                log.warning("Explanation incomplete: Concept " + unsatClass + " is satisfiable in the explanation " + explanation);
            }
            for (OWLAxiom axiom : explanation) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Try pruning " + axiom);
                }
                this.owlOntologyManager.applyChange((OWLOntologyChange)new RemoveAxiom(debuggingOntology, axiom));
                if (!incremental) {
                    reasoner.clearOntologies();
                    reasoner.loadOntology(debuggingOntology);
                }
                reasoner.getKB().prepare();
                if (defTracker.isDefined(unsatClass) && !reasoner.isSatisfiable(unsatClass)) {
                    prunedExplanation.remove(axiom);
                    if (!log.isLoggable(Level.FINER)) continue;
                    log.finer("Pruned " + axiom);
                    continue;
                }
                this.owlOntologyManager.applyChange((OWLOntologyChange)new AddAxiom(debuggingOntology, axiom));
            }
            if (incremental) {
                this.owlOntologyManager.removeOntologyChangeListener((OWLOntologyChangeListener)reasoner);
            }
            this.owlOntologyManager.removeOntology(debuggingOntology.getURI());
            return prunedExplanation;
        }
        catch (OWLOntologyChangeException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    @Deprecated
    public OWLOntology getOntology() {
        return super.getOntology();
    }

    public void setReasoner(OWLClassReasoner reasoner) {
        super.setReasoner(reasoner);
        if (!(reasoner instanceof Reasoner)) {
            throw new RuntimeException("GlassBox explanation requires Pellet reasoner!");
        }
    }

    public String toString() {
        return "GlassBox";
    }

    static {
        GlassBoxExplanation.setup();
        log = Logger.getLogger(GlassBoxExplanation.class.getName());
    }
}

