/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomObject;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.RuleAtomVisitor;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrivialSatisfactionHelpers {
    private static final BindingTester ALWAYS_TRUE = new BindingTester(){

        public DependencySet check(VariableBinding binding) {
            return DependencySet.INDEPENDENT;
        }

        public String toString() {
            return "test(TRUE)";
        }
    };
    private ABox abox;

    public TrivialSatisfactionHelpers(ABox abox) {
        this.abox = abox;
    }

    public Collection<BindingHelper> getHelpers(Rule rule) {
        ArrayList<BindingHelper> helpers = new ArrayList<BindingHelper>();
        BodyAtomVisitor bodyVisitor = new BodyAtomVisitor();
        for (RuleAtom ruleAtom : rule.getBody()) {
            ruleAtom.accept(bodyVisitor);
            if (bodyVisitor.getTester() == null) continue;
            helpers.add(new FilterHelper(bodyVisitor.getTester(), VariableUtils.getVars(ruleAtom)));
        }
        return helpers;
    }

    public DependencySet isAtomTrue(RuleAtom atom, VariableBinding binding) {
        HeadAtomVisitor visitor = new HeadAtomVisitor();
        atom.accept(visitor);
        BindingTester tester = visitor.getTester();
        return tester == null ? null : tester.check(binding);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class UnaryBindingTester<R extends AtomObject>
    implements BindingTester {
        R arg;
        final /* synthetic */ TrivialSatisfactionHelpers this$0;

        public UnaryBindingTester(R arg) {
            this.this$0 = var1_1;
            this.arg = arg;
        }

        public R getArg() {
            return this.arg;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestSame
    extends BinaryBindingTester<AtomIObject, AtomIObject> {
        public TestSame(AtomIObject arg1, AtomIObject arg2) {
            super(TrivialSatisfactionHelpers.this, (AtomObject)arg1, (AtomObject)arg2);
        }

        @Override
        public DependencySet check(VariableBinding binding) {
            Individual ind2;
            Individual ind1 = binding.get((AtomIObject)this.arg1);
            if (ind1.isSame(ind2 = binding.get((AtomIObject)this.arg2))) {
                DependencySet ds1 = ind1.getMergeDependency(true);
                DependencySet ds2 = ind2.getMergeDependency(true);
                return ds1 == null ? ds2 : (ds2 == null ? ds1 : ds1.union(ds2, true));
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class TestProperty<S extends AtomObject>
    extends BinaryBindingTester<AtomIObject, S> {
        Role r;
        final /* synthetic */ TrivialSatisfactionHelpers this$0;

        public TestProperty(ATermAppl p, AtomIObject arg1, S arg2) {
            this.this$0 = var1_1;
            super((TrivialSatisfactionHelpers)var1_1, (AtomObject)arg1, arg2);
            this.r = ((TrivialSatisfactionHelpers)var1_1).abox.getRole((ATerm)p);
            if (this.r == null) {
                throw new InternalReasonerException("Cannot retreive role!: " + p);
            }
        }

        public DependencySet check(Individual node1, Node node2) {
            EdgeList list = node1.getRNeighborEdges(this.r);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Edge edge = list.edgeAt(i);
                if (!edge.getNeighbor(node1).equals(node2)) continue;
                return edge.getDepends();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestIndividualProperty
    extends TestProperty<AtomIObject> {
        public TestIndividualProperty(ATermAppl p, AtomIObject arg1, AtomIObject arg2) {
            super(TrivialSatisfactionHelpers.this, p, arg1, (AtomObject)arg2);
        }

        @Override
        public DependencySet check(VariableBinding binding) {
            return this.check(binding.get((AtomIObject)this.getArg1()), binding.get((AtomIObject)this.getArg2()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestDifferent
    extends BinaryBindingTester<AtomIObject, AtomIObject> {
        public TestDifferent(AtomIObject arg1, AtomIObject arg2) {
            super(TrivialSatisfactionHelpers.this, (AtomObject)arg1, (AtomObject)arg2);
        }

        @Override
        public DependencySet check(VariableBinding binding) {
            return binding.get((AtomIObject)this.arg1).getDifferenceDependency(binding.get((AtomIObject)this.arg2));
        }

        public String toString() {
            return "notDifferent(" + this.getArg1() + "," + this.getArg2() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestDataProperty
    extends TestProperty<AtomDObject> {
        public TestDataProperty(ATermAppl p, AtomIObject arg1, AtomDObject arg2) {
            super(TrivialSatisfactionHelpers.this, p, arg1, (AtomObject)arg2);
        }

        @Override
        public DependencySet check(VariableBinding binding) {
            return this.check(binding.get((AtomIObject)this.getArg1()), binding.get((AtomDObject)this.getArg2()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestClass
    extends UnaryBindingTester<AtomIObject> {
        private ATermAppl c;

        public TestClass(ATermAppl c, AtomIObject arg) {
            super(TrivialSatisfactionHelpers.this, (AtomObject)arg);
            this.c = c;
        }

        @Override
        public DependencySet check(VariableBinding binding) {
            Individual ind = binding.get((AtomIObject)this.getArg());
            return ind.getDepends((ATerm)this.c);
        }

        public String toString() {
            return "notClass(" + this.getArg() + ":" + this.c + ")";
        }
    }

    private class HeadAtomVisitor
    implements RuleAtomVisitor {
        private BindingTester tester = null;

        private HeadAtomVisitor() {
        }

        public BindingTester getTester() {
            return this.tester;
        }

        public void visit(BuiltInAtom atom) {
            this.tester = ALWAYS_TRUE;
        }

        public void visit(ClassAtom atom) {
            this.tester = new TestClass(ATermUtils.normalize((ATermAppl)atom.getPredicate()), (AtomIObject)atom.getArgument());
        }

        public void visit(DataRangeAtom atom) {
            this.tester = ALWAYS_TRUE;
        }

        public void visit(DatavaluedPropertyAtom atom) {
            this.tester = new TestDataProperty((ATermAppl)atom.getPredicate(), (AtomIObject)atom.getArgument1(), (AtomDObject)atom.getArgument2());
        }

        public void visit(DifferentIndividualsAtom atom) {
            this.tester = new TestDifferent((AtomIObject)atom.getArgument1(), (AtomIObject)atom.getArgument2());
        }

        public void visit(IndividualPropertyAtom atom) {
            this.tester = new TestIndividualProperty((ATermAppl)atom.getPredicate(), (AtomIObject)atom.getArgument1(), (AtomIObject)atom.getArgument2());
        }

        public void visit(SameIndividualAtom atom) {
            this.tester = new TestSame((AtomIObject)atom.getArgument1(), (AtomIObject)atom.getArgument2());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilterHelper
    implements BindingHelper {
        private boolean result = false;
        private BindingTester tester;
        private Collection<? extends AtomVariable> vars;

        public FilterHelper(BindingTester tester, Collection<? extends AtomVariable> vars) {
            this.tester = tester;
            this.vars = vars;
        }

        @Override
        public Collection<? extends AtomVariable> getBindableVars(Collection<AtomVariable> bound) {
            return Collections.emptySet();
        }

        @Override
        public Collection<? extends AtomVariable> getPrerequisiteVars(Collection<AtomVariable> bound) {
            return this.vars;
        }

        @Override
        public void rebind(VariableBinding newBinding) {
            this.result = this.tester.check(newBinding) == null;
        }

        @Override
        public boolean selectNextBinding() {
            boolean result = this.result;
            this.result = false;
            return result;
        }

        @Override
        public void setCurrentBinding(VariableBinding currentBinding) {
        }

        public String toString() {
            return "Filter(" + this.tester + ")";
        }
    }

    private class BodyAtomVisitor
    implements RuleAtomVisitor {
        private BindingTester tester = null;

        private BodyAtomVisitor() {
        }

        public BindingTester getTester() {
            return this.tester;
        }

        public void visit(BuiltInAtom atom) {
            this.tester = null;
        }

        public void visit(ClassAtom atom) {
            this.tester = new TestClass(ATermUtils.normalize(ATermUtils.negate((ATermAppl)atom.getPredicate())), (AtomIObject)atom.getArgument());
        }

        public void visit(DataRangeAtom atom) {
            this.tester = null;
        }

        public void visit(DatavaluedPropertyAtom atom) {
            this.tester = null;
        }

        public void visit(DifferentIndividualsAtom atom) {
            this.tester = new TestSame((AtomIObject)atom.getArgument1(), (AtomIObject)atom.getArgument2());
        }

        public void visit(IndividualPropertyAtom atom) {
            this.tester = null;
        }

        public void visit(SameIndividualAtom atom) {
            this.tester = new TestDifferent((AtomIObject)atom.getArgument1(), (AtomIObject)atom.getArgument2());
        }
    }

    private static interface BindingTester {
        public DependencySet check(VariableBinding var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BinaryBindingTester<R extends AtomObject, S extends AtomObject>
    implements BindingTester {
        R arg1;
        S arg2;
        final /* synthetic */ TrivialSatisfactionHelpers this$0;

        public BinaryBindingTester(R arg1, S arg2) {
            this.this$0 = var1_1;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        public R getArg1() {
            return this.arg1;
        }

        public S getArg2() {
            return this.arg2;
        }
    }
}

