/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.builtins.BinaryTester;
import com.clarkparsia.pellet.rules.builtins.ComparisonTesters;
import com.clarkparsia.pellet.rules.builtins.Function;
import com.clarkparsia.pellet.rules.builtins.StringFunctionAdapter;
import com.clarkparsia.pellet.rules.builtins.StringToStringFunction;
import com.clarkparsia.pellet.rules.builtins.Tester;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.utils.ATermUtils;

public class StringOperators {
    public static final Tester contains = new Contains();
    public static final Tester containsIgnoreCase = new ContainsIgnoreCase();
    public static final Tester endsWith = new EndsWith();
    public static final Function lowerCase = new StringFunctionAdapter(new LowerCase());
    public static final Tester matches = new Matches();
    public static final Function normalizeSpace = new StringFunctionAdapter(new NormalizeSpace());
    public static final Function replace = new StringFunctionAdapter(new Replace());
    public static final Tester startsWith = new StartsWith();
    public static final Function stringConcat = new StringFunctionAdapter(new StringConcat());
    public static final Tester stringEqualIgnoreCase = new StringEqualIgnoreCase();
    public static final Function stringLength = new StringLength();
    public static final Function substringAfter = new StringFunctionAdapter(new SubStringAfter());
    public static final Function substringBefore = new StringFunctionAdapter(new SubStringBefore());
    public static final Function translate = new StringFunctionAdapter(new Translate());
    public static final Function upperCase = new StringFunctionAdapter(new UpperCase());

    private static class UpperCase
    implements StringToStringFunction {
        private UpperCase() {
        }

        public String apply(String ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0].toUpperCase();
        }
    }

    private static class Translate
    implements StringToStringFunction {
        private Translate() {
        }

        public String apply(String ... args) {
            if (args.length != 3) {
                return null;
            }
            String src = args[1];
            String dst = args[2];
            StringBuffer result = new StringBuffer();
            for (char c : args[0].toCharArray()) {
                int replPos = src.indexOf(c);
                if (replPos < 0) {
                    result.append(c);
                    continue;
                }
                if (replPos >= dst.length()) continue;
                result.append(dst.charAt(replPos));
            }
            return result.toString();
        }
    }

    private static class SubStringBefore
    implements StringToStringFunction {
        private SubStringBefore() {
        }

        public String apply(String ... args) {
            if (args.length != 2) {
                return null;
            }
            if (args[1].equals("")) {
                return "";
            }
            int index = args[0].indexOf(args[1]);
            if (index < 0) {
                return "";
            }
            return args[0].substring(0, index);
        }
    }

    private static class SubStringAfter
    implements StringToStringFunction {
        private SubStringAfter() {
        }

        public String apply(String ... args) {
            if (args.length != 2) {
                return null;
            }
            if (args[1].equals("")) {
                return "";
            }
            int index = args[0].indexOf(args[1]);
            if (index < 0) {
                return "";
            }
            return args[0].substring(index + args[1].length());
        }
    }

    private static class StringLength
    implements Function {
        private StringLength() {
        }

        public Literal apply(ABox abox, Literal expected, Literal ... args) {
            if (args.length != 1) {
                return null;
            }
            String val = ATermUtils.getLiteralValue(args[0].getTerm());
            String length = Integer.toString(val.length());
            Literal result = abox.addLiteral(ATermUtils.makeTypedLiteral(length, "http://www.w3.org/2001/XMLSchema#integer"));
            return ComparisonTesters.expectedIfEquals(expected, result);
        }
    }

    private static class StringEqualIgnoreCase
    extends BinaryTester {
        private StringEqualIgnoreCase() {
        }

        protected boolean test(Literal l1, Literal l2) {
            ATermAppl l1name = l1.getName();
            ATermAppl l2name = l2.getName();
            String l1str = ATermUtils.getLiteralValue(l1name);
            String l2str = ATermUtils.getLiteralValue(l2name);
            return l1str.equalsIgnoreCase(l2str);
        }
    }

    private static class StringConcat
    implements StringToStringFunction {
        private StringConcat() {
        }

        public String apply(String ... args) {
            StringBuffer resultBuffer = new StringBuffer();
            for (String arg : args) {
                resultBuffer.append(arg);
            }
            return resultBuffer.toString();
        }
    }

    private static class StartsWith
    extends BinaryTester {
        private StartsWith() {
        }

        protected boolean test(Literal l1, Literal l2) {
            ATermAppl l1name = l1.getTerm();
            ATermAppl l2name = l2.getTerm();
            String l1str = ATermUtils.getLiteralValue(l1name);
            String l2str = ATermUtils.getLiteralValue(l2name);
            return l1str.startsWith(l2str);
        }
    }

    private static class Replace
    implements StringToStringFunction {
        private Replace() {
        }

        public String apply(String ... args) {
            if (args.length != 3) {
                return null;
            }
            String from = args[1];
            String to = args[2];
            return args[0].replace(from, to);
        }
    }

    private static class NormalizeSpace
    implements StringToStringFunction {
        private NormalizeSpace() {
        }

        public String apply(String ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0].trim().replaceAll("\\s+", " ");
        }
    }

    private static class Matches
    extends BinaryTester {
        private Matches() {
        }

        protected boolean test(Literal l1, Literal l2) {
            ATermAppl l1name = l1.getTerm();
            ATermAppl l2name = l2.getTerm();
            String l1str = ATermUtils.getLiteralValue(l1name);
            String l2str = ATermUtils.getLiteralValue(l2name);
            boolean result = false;
            try {
                result = Pattern.matches(l2str, l1str);
            }
            catch (PatternSyntaxException e) {
                ABox.log.info("Bad regex from builtin rule: " + l2);
            }
            return result;
        }
    }

    private static class LowerCase
    implements StringToStringFunction {
        private LowerCase() {
        }

        public String apply(String ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0].toLowerCase();
        }
    }

    private static class EndsWith
    extends BinaryTester {
        private EndsWith() {
        }

        protected boolean test(Literal l1, Literal l2) {
            ATermAppl l1name = l1.getTerm();
            ATermAppl l2name = l2.getTerm();
            String l1str = ATermUtils.getLiteralValue(l1name);
            String l2str = ATermUtils.getLiteralValue(l2name);
            return l1str.endsWith(l2str);
        }
    }

    private static class ContainsIgnoreCase
    extends BinaryTester {
        private ContainsIgnoreCase() {
        }

        protected boolean test(Literal l1, Literal l2) {
            ATermAppl l1name = l1.getTerm();
            ATermAppl l2name = l2.getTerm();
            String l1str = ATermUtils.getLiteralValue(l1name).toLowerCase();
            String l2str = ATermUtils.getLiteralValue(l2name).toLowerCase();
            return l1str.contains(l2str);
        }
    }

    private static class Contains
    extends BinaryTester {
        private Contains() {
        }

        protected boolean test(Literal l1, Literal l2) {
            ATermAppl l1name = l1.getTerm();
            ATermAppl l2name = l2.getTerm();
            String l1str = ATermUtils.getLiteralValue(l1name);
            String l2str = ATermUtils.getLiteralValue(l2name);
            return l1str.contains(l2str);
        }
    }
}

