/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.rete.AlphaIndex;
import com.clarkparsia.pellet.rules.rete.AlphaNode;
import com.clarkparsia.pellet.rules.rete.AlphaStore;
import com.clarkparsia.pellet.rules.rete.BetaNode;
import com.clarkparsia.pellet.rules.rete.Fact;
import com.clarkparsia.pellet.rules.rete.Interpreter;
import com.clarkparsia.pellet.rules.rete.Node;
import com.clarkparsia.pellet.rules.rete.Rule;
import com.clarkparsia.pellet.rules.rete.RuleNode;
import com.clarkparsia.pellet.rules.rete.TermTuple;
import java.util.Iterator;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;

public class Compiler {
    public static final ATermAppl DIFF_FROM;
    public static final TermTuple EMPTY_TUPLE;
    public static final Fact EMPTY_FACT;
    public static final int OBJ = 2;
    public static final int PRED = 0;
    public static final ATermAppl SAME_AS;
    public static final int SUBJ = 1;
    public static final ATermAppl TYPE;
    ABox abox;
    AlphaIndex alphaIndex;
    Interpreter interpreter;

    public Compiler(Interpreter interp, ABox abox) {
        this.abox = abox;
        this.interpreter = interp;
        this.alphaIndex = new AlphaIndex();
    }

    public boolean addDifferents(Individual individual) {
        boolean changed = false;
        for (org.mindswap.pellet.Node different : individual.getDifferents()) {
            if (!different.isNamedIndividual() || different.isPruned()) continue;
            changed |= this.interpreter.addFact(this.createDifferent(individual, different, individual.getDifferenceDependency(different)));
        }
        return changed;
    }

    public boolean addFact(Edge edge) {
        Individual from = edge.getFrom();
        org.mindswap.pellet.Node to = edge.getTo().getSame();
        if (!to.isRootNominal() || to.isPruned()) {
            return false;
        }
        DependencySet ds = edge.getDepends();
        Role role = edge.getRole();
        boolean added = this.addFact(role, from, to, ds);
        if (role.isObjectRole()) {
            added |= this.addFact(role.getInverse(), (Individual)to, from, ds);
        }
        return added;
    }

    private boolean addFact(Role r, Individual from, org.mindswap.pellet.Node to, DependencySet ds) {
        boolean added = false;
        for (Role sup : r.getSuperRoles()) {
            added |= this.interpreter.addFact(this.createFact(sup.getName(), from, to, ds.union(r.getExplainSuper((ATerm)sup.getName()), this.abox.doExplanation())));
        }
        return added;
    }

    public boolean addFact(Individual individual, ATermAppl type, DependencySet ds) {
        boolean changed = false;
        return changed |= this.interpreter.addFact(this.createFact(individual, type, ds));
    }

    public void compile(Rule rule, ATermAppl explain) {
        AlphaStore alphaNodesOfRule = new AlphaStore();
        for (TermTuple anodePattern : rule.getBody()) {
            AlphaNode anode = this.makeAlphaNode(anodePattern);
            alphaNodesOfRule.addNode(anode);
        }
        alphaNodesOfRule.sort();
        switch (alphaNodesOfRule.nodes.size()) {
            case 0: {
                AlphaNode alpha1 = this.makeAlphaNode(EMPTY_TUPLE);
                alphaNodesOfRule.addNode(alpha1);
            }
            case 1: {
                AlphaNode alpha1 = alphaNodesOfRule.nodes.get(0);
                BetaNode beta = this.makeBetaNode(alpha1, alpha1, false);
                alpha1.add(beta);
                beta.rule = new RuleNode(rule, explain);
                beta.rule.betaNode = beta;
                break;
            }
            default: {
                Iterator<AlphaNode> nodes = alphaNodesOfRule.nodes.iterator();
                AlphaNode alpha1 = nodes.next();
                AlphaNode alpha2 = nodes.next();
                BetaNode beta = this.makeBetaNode(alpha1, alpha2, true);
                alpha1.add(beta);
                alpha2.add(beta);
                while (nodes.hasNext()) {
                    AlphaNode alpha = nodes.next();
                    beta = this.makeBetaNode(beta, alpha, true);
                    alpha.add(beta);
                }
                beta.rule = new RuleNode(rule, explain);
                beta.rule.betaNode = beta;
            }
        }
    }

    public void compileFacts(ABox abox) {
        this.interpreter.addFact(EMPTY_FACT);
        IndividualIterator i = abox.getIndIterator();
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            this.processIndividual(ind);
        }
    }

    private Fact createDifferent(Individual ind1, org.mindswap.pellet.Node ind2, DependencySet ds) {
        ATermAppl subj = ind1.getName();
        ATermAppl obj = ind2.getName();
        return new Fact(ds, DIFF_FROM, subj, obj);
    }

    private Fact createFact(ATermAppl r, Individual from, org.mindswap.pellet.Node to, DependencySet ds) {
        ATermAppl pred = r;
        ATermAppl subj = from.getName();
        ATermAppl obj = to.getName();
        return new Fact(ds, pred, subj, obj);
    }

    private Fact createFact(Individual ind, ATermAppl c, DependencySet ds) {
        ATermAppl predType = TYPE;
        ATermAppl subj = ind.getName();
        ATermAppl obj = c;
        return new Fact(ds, predType, subj, obj);
    }

    private AlphaNode makeAlphaNode(TermTuple pattern) {
        return this.alphaIndex.add(pattern);
    }

    private BetaNode makeBetaNode(Node node1, Node node2, boolean futureJoins) {
        BetaNode b = new BetaNode(node1, node2, this.abox.doExplanation());
        return b;
    }

    public boolean processIndividual(Individual ind) {
        boolean changed = false;
        if (!ind.isRootNominal() || ind.isPruned()) {
            return false;
        }
        for (ATermAppl indType : ind.getTypes()) {
            changed |= this.addFact(ind, indType, ind.getDepends((ATerm)indType));
        }
        changed |= this.addDifferents(ind);
        for (Edge edge : ind.getOutEdges()) {
            changed |= this.addFact(edge);
        }
        return changed;
    }

    public String toString() {
        return this.alphaIndex.toString();
    }

    static {
        EMPTY_TUPLE = new TermTuple(DependencySet.INDEPENDENT, new ATermAppl[0]);
        EMPTY_FACT = new Fact(DependencySet.INDEPENDENT, new ATermAppl[0]);
        String PREFIX = "tag:clarkparsia.info,2007:pellet:dl-safe-rules:predicate:";
        DIFF_FROM = ATermUtils.makeTermAppl(PREFIX + "differentFrom");
        SAME_AS = ATermUtils.makeTermAppl(PREFIX + "sameAs");
        TYPE = ATermUtils.makeTermAppl(PREFIX + "type");
    }
}

