/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.AbstractABoxEngineWrapper;
import com.clarkparsia.pellet.sparqldl.engine.LiteralIterator;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.QueryResultImpl;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.sparqldl.model.ResultBindingImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;

public class OptimizedQueryEngine3
extends AbstractABoxEngineWrapper {
    public static final Logger log = Logger.getLogger(QueryEngine.class.getName());

    public boolean supports(Query q) {
        return true;
    }

    public QueryResult execABoxQuery(Query q) {
        QueryResultImpl results = new QueryResultImpl(q);
        KnowledgeBase kb = q.getKB();
        long satCount = kb.getABox().satisfiabilityCount;
        long consCount = kb.getABox().consistencyCount;
        if (q.getDistVars().isEmpty()) {
            if (QueryEngine.execBooleanABoxQuery(q)) {
                results.add(new ResultBindingImpl());
            }
        } else {
            boolean hasLiterals;
            HashMap<ATermAppl, Set<ATermAppl>> varBindings = new HashMap<ATermAppl, Set<ATermAppl>>();
            for (ATermAppl currVar : q.getDistVarsForType(Query.VarType.INDIVIDUAL)) {
                ATermAppl rolledUpClass = q.rollUpTo(currVar, Collections.EMPTY_SET, false);
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Rolled up class " + rolledUpClass);
                }
                varBindings.put(currVar, kb.getInstances(rolledUpClass));
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer("Var bindings: " + varBindings);
            }
            ArrayList varList = new ArrayList(varBindings.keySet());
            HashMap goodLists = new HashMap();
            QueryResultImpl result = new QueryResultImpl(q);
            ATermAppl first = (ATermAppl)varList.get(0);
            HashSet<ResultBindingImpl> c = new HashSet<ResultBindingImpl>();
            for (ATermAppl a : (Set)varBindings.get(first)) {
                ResultBindingImpl bind = new ResultBindingImpl();
                bind.setValue(first, a);
                c.add(bind);
            }
            goodLists.put(first, c);
            HashSet<ResultBinding> previous = (HashSet<ResultBinding>)goodLists.get(first);
            for (int i = 1; i < varList.size(); ++i) {
                ATermAppl next = (ATermAppl)varList.get(i);
                HashSet<ResultBinding> newBindings = new HashSet<ResultBinding>();
                for (ResultBinding binding : previous) {
                    for (ATermAppl testBind : (Set)varBindings.get(next)) {
                        ResultBinding bindingCandidate = binding.clone();
                        bindingCandidate.setValue(next, testBind);
                        boolean queryTrue = QueryEngine.execBooleanABoxQuery(q.apply(bindingCandidate));
                        if (queryTrue) {
                            newBindings.add(bindingCandidate);
                            if (!log.isLoggable(Level.FINER)) continue;
                            log.finer("Accepted binding: " + bindingCandidate);
                            continue;
                        }
                        if (!log.isLoggable(Level.FINER)) continue;
                        log.finer("Rejected binding: " + bindingCandidate);
                    }
                }
                previous = newBindings;
            }
            boolean bl = hasLiterals = !q.getDistVarsForType(Query.VarType.LITERAL).isEmpty();
            if (hasLiterals) {
                for (ResultBinding b : previous) {
                    LiteralIterator i = new LiteralIterator(q, b);
                    while (i.hasNext()) {
                        results.add((ResultBinding)i.next());
                    }
                }
            } else {
                for (ResultBinding b : previous) {
                    results.add(b);
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Results: " + results);
                log.fine("Total satisfiability operations: " + (kb.getABox().satisfiabilityCount - satCount));
                log.fine("Total consistency operations: " + (kb.getABox().consistencyCount - consCount));
            }
        }
        return results;
    }
}

