/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.jena;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.model.QueryParameters;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.query.QueryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparqlDLResultSet
implements ResultSetRewindable {
    private Model model;
    private List<ATermAppl> resultVars;
    private List<String> resultVarsString;
    private QueryResult queryResult;
    private int index;
    private Iterator<com.clarkparsia.pellet.sparqldl.model.ResultBinding> bindings;
    private Binding parent;
    private QueryParameters parameters;

    public SparqlDLResultSet(QueryResult answers, Model model) {
        this(answers, model, null, null);
    }

    public SparqlDLResultSet(QueryResult answers, Model model, Binding parent) {
        this(answers, model, parent, null);
    }

    public SparqlDLResultSet(QueryResult answers, Model model, QueryParameters parameters) {
        this(answers, model, null, parameters);
    }

    public SparqlDLResultSet(QueryResult answers, Model model, Binding parent, QueryParameters parameters) {
        this.parent = parent;
        this.queryResult = answers;
        this.model = model;
        this.parameters = parameters;
        this.index = 0;
        this.bindings = answers.iterator();
        this.resultVars = new ArrayList<ATermAppl>();
        this.resultVarsString = new ArrayList<String>();
        for (ATermAppl var : this.queryResult.getResultVars()) {
            this.resultVars.add(var);
            this.resultVarsString.add(QueryUtils.getVarName(var));
        }
        if (parameters == null) {
            this.parameters = new QueryParameters();
        }
    }

    public QueryResult getQueryResult() {
        return this.queryResult;
    }

    public boolean hasNext() {
        return this.bindings.hasNext();
    }

    public Binding nextBinding() {
        ++this.index;
        com.clarkparsia.pellet.sparqldl.model.ResultBinding binding = this.bindings.next();
        BindingMap result = this.parent == null ? new BindingMap() : new BindingMap(this.parent);
        for (ATermAppl var : this.resultVars) {
            if (!binding.isBound(var)) continue;
            String varName = QueryUtils.getVarName(var);
            ATermAppl value = binding.getValue(var);
            if (value == null) continue;
            Node node = JenaUtils.makeGraphNode(value);
            result.add(Var.alloc((String)varName), node);
        }
        if (this.resultVars.size() == 0) {
            for (Map.Entry<ATermAppl, ATermAppl> entry : this.parameters.entrySet()) {
                ATermAppl term = entry.getKey();
                String varName = QueryUtils.getVarName(term);
                Var var = Var.alloc((String)varName);
                if (result.contains(var)) continue;
                result.add(var, JenaUtils.makeGraphNode(entry.getValue()));
            }
        }
        return result;
    }

    public QuerySolution nextSolution() {
        return new ResultBinding(this.model, this.nextBinding());
    }

    public QuerySolution next() {
        return this.nextSolution();
    }

    public boolean isDistinct() {
        return this.queryResult.isDistinct();
    }

    public boolean isOrdered() {
        return false;
    }

    public int getRowNumber() {
        return this.index;
    }

    public List<String> getResultVars() {
        return Collections.unmodifiableList(this.resultVarsString);
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Remove not supported");
    }

    public String toString() {
        return this.queryResult.toString();
    }

    public void reset() {
        this.index = 0;
        this.bindings = this.queryResult.iterator();
    }

    public int size() {
        return this.queryResult.size();
    }

    public Model getResourceModel() {
        return this.model;
    }
}

