/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.utils;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.output.ATermBaseVisitor;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntBuilder {
    private KnowledgeBase kb;
    private KnowledgeBase originalKB;
    private DefinitionVisitor defVisitor = new DefinitionVisitor();

    public OntBuilder(KnowledgeBase originalKB) {
        this.originalKB = originalKB;
    }

    public void add(ATermAppl axiom) {
        AFun afun = axiom.getAFun();
        if (afun.equals(ATermUtils.EQCLASSFUN)) {
            ATermAppl c1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl c2 = (ATermAppl)axiom.getArgument(1);
            this.defineClass(c1);
            this.defineClass(c2);
            this.kb.addEquivalentClass(c1, c2);
        } else if (afun.equals(ATermUtils.SUBFUN)) {
            ATermAppl c1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl c2 = (ATermAppl)axiom.getArgument(1);
            this.defineClass(c1);
            this.defineClass(c2);
            this.kb.addSubClass(c1, c2);
        } else if (afun.equals(ATermUtils.DISJOINTSFUN)) {
            ATermList concepts;
            ATermList l = concepts = (ATermList)axiom.getArgument(0);
            while (!l.isEmpty()) {
                this.defineClass((ATermAppl)l.getFirst());
                l = l.getNext();
            }
            this.kb.addDisjointClasses(concepts);
        } else if (afun.equals(ATermUtils.DISJOINTFUN)) {
            ATermAppl c1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl c2 = (ATermAppl)axiom.getArgument(1);
            this.defineClass(c1);
            this.defineClass(c2);
            this.kb.addDisjointClass(c1, c2);
        } else if (afun.equals(ATermUtils.DISJOINTPROPSFUN)) {
            ATermList props;
            ATermList l = props = (ATermList)axiom.getArgument(0);
            while (!l.isEmpty()) {
                this.defineProperty((ATermAppl)l.getFirst());
                l = l.getNext();
            }
            this.kb.addDisjointProperties(props);
        } else if (afun.equals(ATermUtils.DISJOINTPROPFUN)) {
            ATermAppl p1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl p2 = (ATermAppl)axiom.getArgument(1);
            this.defineProperty(p1);
            this.defineProperty(p2);
            this.kb.addDisjointProperty(p1, p2);
        } else if (afun.equals(ATermUtils.SUBPROPFUN)) {
            ATermAppl p1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl p2 = (ATermAppl)axiom.getArgument(1);
            this.defineProperty(p1);
            this.defineProperty(p2);
            this.kb.addSubProperty((ATerm)p1, p2);
        } else if (afun.equals(ATermUtils.EQPROPFUN)) {
            ATermAppl p1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl p2 = (ATermAppl)axiom.getArgument(1);
            this.defineProperty(p1);
            this.defineProperty(p2);
            this.kb.addEquivalentProperty(p1, p2);
        } else if (afun.equals(ATermUtils.DOMAINFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            ATermAppl c = (ATermAppl)axiom.getArgument(1);
            this.defineProperty(p);
            this.defineClass(c);
            this.kb.addDomain((ATerm)p, c);
        } else if (afun.equals(ATermUtils.RANGEFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            ATermAppl c = (ATermAppl)axiom.getArgument(1);
            this.defineProperty(p);
            this.defineClass(c);
            this.kb.addRange((ATerm)p, c);
        } else if (afun.equals(ATermUtils.INVPROPFUN)) {
            ATermAppl p1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl p2 = (ATermAppl)axiom.getArgument(1);
            this.kb.addObjectProperty((ATerm)p1);
            this.kb.addObjectProperty((ATerm)p2);
            this.kb.addInverseProperty(p1, p2);
        } else if (afun.equals(ATermUtils.TRANSITIVEFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            this.kb.addObjectProperty((ATerm)p);
            this.kb.addTransitiveProperty(p);
        } else if (afun.equals(ATermUtils.FUNCTIONALFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            this.defineProperty(p);
            this.kb.addFunctionalProperty(p);
        } else if (afun.equals(ATermUtils.INVFUNCTIONALFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            this.kb.addObjectProperty((ATerm)p);
            this.kb.addInverseFunctionalProperty((ATerm)p);
        } else if (afun.equals(ATermUtils.SYMMETRICFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            this.kb.addObjectProperty((ATerm)p);
            this.kb.addSymmetricProperty(p);
        } else if (afun.equals(ATermUtils.ASYMMETRICFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            this.kb.addObjectProperty((ATerm)p);
            this.kb.addAsymmetricProperty(p);
        } else if (afun.equals(ATermUtils.REFLEXIVEFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            this.kb.addObjectProperty((ATerm)p);
            this.kb.addReflexiveProperty(p);
        } else if (afun.equals(ATermUtils.IRREFLEXIVEFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            this.kb.addObjectProperty((ATerm)p);
            this.kb.addIrreflexiveProperty(p);
        } else if (afun.equals(ATermUtils.TYPEFUN)) {
            ATermAppl ind = (ATermAppl)axiom.getArgument(0);
            ATermAppl cls = (ATermAppl)axiom.getArgument(1);
            this.kb.addIndividual(ind);
            this.defineClass(cls);
            this.kb.addType(ind, cls);
        } else if (afun.equals(ATermUtils.PROPFUN)) {
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            ATermAppl s = (ATermAppl)axiom.getArgument(1);
            ATermAppl o = (ATermAppl)axiom.getArgument(2);
            this.kb.addIndividual(s);
            if (ATermUtils.isLiteral(o)) {
                this.kb.addDatatypeProperty((ATerm)p);
            } else {
                this.kb.addObjectProperty((ATerm)p);
                this.kb.addIndividual(o);
            }
            this.kb.addPropertyValue(p, s, o);
        } else if (afun.equals(ATermUtils.NOTFUN) && ((ATermAppl)axiom.getArgument(0)).getAFun().equals(ATermUtils.PROPFUN)) {
            axiom = (ATermAppl)axiom.getArgument(0);
            ATermAppl p = (ATermAppl)axiom.getArgument(0);
            ATermAppl s = (ATermAppl)axiom.getArgument(1);
            ATermAppl o = (ATermAppl)axiom.getArgument(2);
            this.kb.addIndividual(s);
            if (ATermUtils.isLiteral(o)) {
                this.kb.addDatatypeProperty((ATerm)p);
            } else {
                this.kb.addObjectProperty((ATerm)p);
                this.kb.addIndividual(o);
            }
            this.kb.addNegatedPropertyValue(p, s, o);
        } else if (afun.equals(ATermUtils.SAMEASFUN)) {
            ATermAppl ind1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl ind2 = (ATermAppl)axiom.getArgument(1);
            this.kb.addIndividual(ind1);
            this.kb.addIndividual(ind2);
            this.kb.addSame(ind1, ind2);
        } else if (afun.equals(ATermUtils.DIFFERENTFUN)) {
            ATermAppl ind1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl ind2 = (ATermAppl)axiom.getArgument(1);
            this.kb.addIndividual(ind1);
            this.kb.addIndividual(ind2);
            this.kb.addDifferent(ind1, ind2);
        } else if (afun.equals(ATermUtils.ALLDIFFERENTFUN)) {
            ATermList inds;
            ATermList l = inds = (ATermList)axiom.getArgument(0);
            while (!l.isEmpty()) {
                this.kb.addIndividual((ATermAppl)l.getFirst());
                l = l.getNext();
            }
            this.kb.addAllDifferent(inds);
        } else if (afun.equals(ATermUtils.RULEFUN)) {
            HashSet<RuleAtom> antecedent = new HashSet<RuleAtom>();
            HashSet<RuleAtom> consequent = new HashSet<RuleAtom>();
            ATermList head = (ATermList)axiom.getArgument(1);
            ATermList body = (ATermList)axiom.getArgument(2);
            while (!body.isEmpty()) {
                antecedent.add(this.convertRuleAtom((ATermAppl)body.getFirst()));
                body = body.getNext();
            }
            while (!head.isEmpty()) {
                consequent.add(this.convertRuleAtom((ATermAppl)head.getFirst()));
                head = head.getNext();
            }
            if (!antecedent.contains(null) && !consequent.contains(null)) {
                ATermAppl name = (ATermAppl)axiom.getArgument(0);
                Rule rule = new Rule(name, consequent, antecedent);
                this.kb.addRule(rule);
            }
        } else {
            throw new InternalReasonerException("Unknown axiom " + axiom);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RuleAtom convertRuleAtom(ATermAppl term) {
        void var2_10;
        Object var2_2 = null;
        if (term.getAFun().equals(ATermUtils.TYPEFUN)) {
            ATermAppl i = (ATermAppl)term.getArgument(0);
            AtomIObject io = this.convertAtomIObject(i);
            ATermAppl c = (ATermAppl)term.getArgument(1);
            this.defineClass(c);
            ClassAtom classAtom = new ClassAtom(c, io);
            return var2_10;
        } else if (term.getAFun().equals(ATermUtils.PROPFUN)) {
            ATermAppl p = (ATermAppl)term.getArgument(0);
            ATermAppl i1 = (ATermAppl)term.getArgument(1);
            ATermAppl i2 = (ATermAppl)term.getArgument(2);
            AtomIObject io1 = this.convertAtomIObject(i1);
            this.defineProperty(p);
            if (this.originalKB.isObjectProperty((ATerm)p)) {
                this.kb.addObjectProperty((ATerm)p);
                AtomIObject io2 = this.convertAtomIObject(i2);
                IndividualPropertyAtom individualPropertyAtom = new IndividualPropertyAtom(p, io1, io2);
                return var2_10;
            } else {
                if (!this.originalKB.isDatatypeProperty((ATerm)p)) throw new InternalReasonerException("Unknown property " + p);
                this.kb.addDatatypeProperty((ATerm)p);
                AtomDObject do2 = this.convertAtomDObject(i2);
                DatavaluedPropertyAtom datavaluedPropertyAtom = new DatavaluedPropertyAtom(p, io1, do2);
            }
            return var2_10;
        } else if (term.getAFun().equals(ATermUtils.SAMEASFUN)) {
            ATermAppl i1 = (ATermAppl)term.getArgument(0);
            ATermAppl i2 = (ATermAppl)term.getArgument(1);
            AtomIObject io1 = this.convertAtomIObject(i1);
            AtomIObject io2 = this.convertAtomIObject(i2);
            SameIndividualAtom sameIndividualAtom = new SameIndividualAtom(io1, io2);
            return var2_10;
        } else if (term.getAFun().equals(ATermUtils.DIFFERENTFUN)) {
            ATermAppl i1 = (ATermAppl)term.getArgument(0);
            ATermAppl i2 = (ATermAppl)term.getArgument(1);
            AtomIObject io1 = this.convertAtomIObject(i1);
            AtomIObject io2 = this.convertAtomIObject(i2);
            DifferentIndividualsAtom differentIndividualsAtom = new DifferentIndividualsAtom(io1, io2);
            return var2_10;
        } else {
            if (!term.getAFun().equals(ATermUtils.BUILTINFUN)) throw new InternalReasonerException("Unknown rule atom " + term);
            ATermList args = (ATermList)term.getArgument(0);
            ATermAppl builtin = (ATermAppl)args.getFirst();
            ArrayList<AtomDObject> list = new ArrayList<AtomDObject>();
            args = args.getNext();
            while (!args.isEmpty()) {
                ATermAppl arg = (ATermAppl)args.getFirst();
                list.add(this.convertAtomDObject(arg));
                args = args.getNext();
            }
            BuiltInAtom builtInAtom = new BuiltInAtom(builtin.toString(), list);
        }
        return var2_10;
    }

    private AtomIObject convertAtomIObject(ATermAppl t) {
        if (ATermUtils.isVar(t)) {
            return new AtomIVariable(((ATermAppl)t.getArgument(0)).getName());
        }
        if (this.kb.isIndividual((ATerm)t)) {
            return new AtomIConstant(t);
        }
        if (ATermUtils.isAnon(t)) {
            return new AtomIConstant(t);
        }
        throw new InternalReasonerException("Unrecognized term: " + t);
    }

    private AtomDObject convertAtomDObject(ATermAppl t) {
        if (ATermUtils.isVar(t)) {
            return new AtomDVariable(((ATermAppl)t.getArgument(0)).getName());
        }
        if (ATermUtils.isLiteral(t)) {
            return new AtomDConstant(t);
        }
        throw new InternalReasonerException("Unrecognized term: " + t);
    }

    public KnowledgeBase build(Set<ATermAppl> axioms) {
        this.reset();
        for (ATermAppl axiom : axioms) {
            this.add(axiom);
        }
        return this.kb;
    }

    private void defineClass(ATermAppl cls) {
        this.defVisitor.visit(cls);
    }

    private void defineProperty(ATermAppl p) {
        if (this.originalKB.isDatatypeProperty((ATerm)p)) {
            this.kb.addDatatypeProperty((ATerm)p);
        } else {
            this.kb.addObjectProperty((ATerm)p);
        }
    }

    public void reset() {
        this.kb = new KnowledgeBase();
    }

    private class DefinitionVisitor
    extends ATermBaseVisitor {
        private DefinitionVisitor() {
        }

        public void visitAll(ATermAppl term) {
            this.visitQR(term);
        }

        public void visitAnd(ATermAppl term) {
            this.visitList((ATermList)term.getArgument(0));
        }

        public void visitCard(ATermAppl term) {
            this.visitQCR(term);
        }

        public void visitHasValue(ATermAppl term) {
            this.visitQR(term);
        }

        public void visitLiteral(ATermAppl term) {
        }

        public void visitMax(ATermAppl term) {
            this.visitQCR(term);
        }

        public void visitMin(ATermAppl term) {
            this.visitQCR(term);
        }

        public void visitNot(ATermAppl term) {
            this.visit((ATermAppl)term.getArgument(0));
        }

        public void visitOneOf(ATermAppl term) {
            this.visitList((ATermList)term.getArgument(0));
        }

        public void visitOr(ATermAppl term) {
            this.visitList((ATermList)term.getArgument(0));
        }

        private void visitQCR(ATermAppl term) {
            ATermAppl p = (ATermAppl)term.getArgument(0);
            ATermAppl q = (ATermAppl)term.getArgument(2);
            this.visitRestr(p, q);
        }

        private void visitQR(ATermAppl term) {
            ATermAppl p = (ATermAppl)term.getArgument(0);
            ATermAppl q = (ATermAppl)term.getArgument(1);
            this.visitRestr(p, q);
        }

        private void visitRestr(ATermAppl p, ATermAppl q) {
            if (OntBuilder.this.originalKB.isObjectProperty((ATerm)p)) {
                OntBuilder.this.kb.addObjectProperty((ATerm)p);
                this.visit(q);
            } else {
                OntBuilder.this.kb.addDatatypeProperty((ATerm)p);
            }
        }

        public void visitSelf(ATermAppl term) {
            OntBuilder.this.kb.addObjectProperty(term.getArgument(0));
        }

        public void visitSome(ATermAppl term) {
            this.visitQR(term);
        }

        public void visitTerm(ATermAppl term) {
            OntBuilder.this.kb.addClass(term);
        }

        public void visitValue(ATermAppl term) {
            ATermAppl nominal = (ATermAppl)term.getArgument(0);
            if (!ATermUtils.isLiteral(nominal)) {
                OntBuilder.this.kb.addIndividual(nominal);
            }
        }

        public void visitInverse(ATermAppl term) {
            ATermAppl p = (ATermAppl)term.getArgument(0);
            if (ATermUtils.isPrimitive(p)) {
                OntBuilder.this.kb.addObjectProperty((ATerm)p);
            } else {
                this.visitInverse(p);
            }
        }

        public void visitRestrictedDatatype(ATermAppl dt) {
        }
    }
}

