/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.utils;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import org.mindswap.pellet.datatypes.DatatypeFacet;
import org.mindswap.pellet.utils.ATermUtils;

public class TermFactory {
    public static final ATermAppl TOP = ATermUtils.TOP;
    public static final ATermAppl BOTTOM = ATermUtils.BOTTOM;
    public static final ATermAppl TOP_LIT = ATermUtils.TOP_LIT;
    public static final ATermAppl BOTTOM_LIT = ATermUtils.BOTTOM_LIT;

    public static ATermAppl term(String s) {
        return ATermUtils.makeTermAppl(s);
    }

    public static ATermAppl bnode(String s) {
        return ATermUtils.makeBnode(s);
    }

    public static ATermAppl var(String s) {
        return ATermUtils.makeVar(s);
    }

    public static ATermList list(ATermAppl ... args) {
        return ATermUtils.makeList((ATerm[])args);
    }

    public static ATermAppl not(ATermAppl c) {
        return ATermUtils.makeNot((ATerm)c);
    }

    public static ATermAppl all(ATermAppl r, ATermAppl c) {
        return ATermUtils.makeAllValues((ATerm)r, (ATerm)c);
    }

    public static ATermAppl some(ATermAppl r, ATermAppl c) {
        return ATermUtils.makeSomeValues((ATerm)r, (ATerm)c);
    }

    public static ATermAppl min(ATermAppl r, int n, ATermAppl c) {
        return ATermUtils.makeMin((ATerm)r, n, (ATerm)c);
    }

    public static ATermAppl max(ATermAppl r, int n, ATermAppl c) {
        return ATermUtils.makeMax((ATerm)r, n, (ATerm)c);
    }

    public static ATermAppl card(ATermAppl r, int n, ATermAppl c) {
        return ATermUtils.makeCard((ATerm)r, n, (ATerm)c);
    }

    public static ATermAppl inv(ATermAppl r) {
        return ATermUtils.makeInv(r);
    }

    public static ATermAppl literal(String value) {
        return ATermUtils.makePlainLiteral(value);
    }

    public static ATermAppl plainLiteral(String value, String lang) {
        return ATermUtils.makePlainLiteral(value, lang);
    }

    public static ATermAppl typedLiteral(String value, String dt) {
        return ATermUtils.makeTypedLiteral(value, dt);
    }

    public static ATermAppl value(ATermAppl r) {
        return ATermUtils.makeValue((ATerm)r);
    }

    public static ATermAppl and(ATermAppl c1, ATermAppl c2) {
        return ATermUtils.makeAnd((ATerm)c1, (ATerm)c2);
    }

    public static ATermAppl and(ATermAppl ... c) {
        return ATermUtils.makeAnd(ATermUtils.makeList((ATerm[])c));
    }

    public static ATermAppl or(ATermAppl c1, ATermAppl c2) {
        return ATermUtils.makeOr(c1, c2);
    }

    public static ATermAppl or(ATermAppl ... c) {
        return ATermUtils.makeOr(ATermUtils.makeList((ATerm[])c));
    }

    public static ATermAppl hasValue(ATermAppl r, ATermAppl ind) {
        return ATermUtils.makeHasValue((ATerm)r, (ATerm)ind);
    }

    public static ATermAppl oneOf(ATermAppl ... terms) {
        ATermList list = ATermUtils.EMPTY_LIST;
        for (ATermAppl term : terms) {
            list = list.insert((ATerm)TermFactory.value(term));
        }
        return ATermUtils.makeOr(list);
    }

    public static ATermAppl self(ATermAppl p) {
        return ATermUtils.makeSelf(p);
    }

    public static ATermAppl minInclusive(ATermAppl facetValue) {
        return ATermUtils.makeFacetRestriction(DatatypeFacet.minInclusive.getName(), facetValue);
    }

    public static ATermAppl minExclusive(ATermAppl facetValue) {
        return ATermUtils.makeFacetRestriction(DatatypeFacet.minExclusive.getName(), facetValue);
    }

    public static ATermAppl maxInclusive(ATermAppl facetValue) {
        return ATermUtils.makeFacetRestriction(DatatypeFacet.maxInclusive.getName(), facetValue);
    }

    public static ATermAppl maxExclusive(ATermAppl facetValue) {
        return ATermUtils.makeFacetRestriction(DatatypeFacet.maxExclusive.getName(), facetValue);
    }

    public static ATermAppl minLength(ATermAppl facetValue) {
        return ATermUtils.makeFacetRestriction(DatatypeFacet.minLength.getName(), facetValue);
    }

    public static ATermAppl maxLength(ATermAppl facetValue) {
        return ATermUtils.makeFacetRestriction(DatatypeFacet.maxLength.getName(), facetValue);
    }

    public static ATermAppl length(ATermAppl facetValue) {
        return ATermUtils.makeFacetRestriction(DatatypeFacet.length.getName(), facetValue);
    }

    public static ATermAppl pattern(ATermAppl facetValue) {
        return ATermUtils.makeFacetRestriction(DatatypeFacet.pattern.getName(), facetValue);
    }

    public static ATermAppl restrict(ATermAppl baseDatatype, ATermAppl ... restrictions) {
        return ATermUtils.makeRestrictedDatatype(baseDatatype, restrictions);
    }
}

