/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern.axiom;

import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.pellint.format.CompactClassLintFormat;
import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.lintpattern.axiom.AxiomLintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.LintFixer;
import java.util.Collections;
import java.util.HashSet;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;

public class EquivalentToTopPattern
extends AxiomLintPattern {
    private static final LintFormat DEFAULT_LINT_FORMAT = new CompactClassLintFormat();

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getDescription() {
        return "Top is equivalent to some concept or is part of an equivalent classes axiom";
    }

    public boolean isFixable() {
        return true;
    }

    public LintFormat getDefaultLintFormat() {
        return DEFAULT_LINT_FORMAT;
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        if (axiom.getDescriptions().contains(OWL.Thing)) {
            Lint lint = this.makeLint();
            lint.addParticipatingAxiom((OWLClassAxiom)axiom);
            LintFixer fixer = new LintFixer(Collections.singleton(axiom), new HashSet());
            lint.setLintFixer(fixer);
            this.setLint(lint);
        }
    }
}

