/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.model;

import com.clarkparsia.pellint.format.SimpleLintFormat;
import com.clarkparsia.pellint.lintpattern.LintPattern;
import com.clarkparsia.pellint.model.LintFixer;
import com.clarkparsia.pellint.model.Severity;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.Collection;
import java.util.Set;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lint {
    private LintPattern m_LintPattern;
    private LintFixer m_LintFixer;
    private Severity m_Severity;
    private Set<OWLClass> m_ParticipatingClasses;
    private Set<OWLClassAxiom> m_ParticipatingAxioms;
    private OWLOntology m_ParticipatingOntology;

    public Lint(LintPattern lintPattern, OWLOntology participatingOntology) {
        this.m_LintPattern = lintPattern;
        this.m_ParticipatingOntology = participatingOntology;
        this.m_ParticipatingClasses = CollectionUtil.makeSet();
        this.m_ParticipatingAxioms = CollectionUtil.makeSet();
    }

    public LintPattern getPattern() {
        return this.m_LintPattern;
    }

    public void setLintFixer(LintFixer fixer) {
        this.m_LintFixer = fixer;
    }

    public LintFixer getLintFixer() {
        return this.m_LintFixer;
    }

    public void setSeverity(Severity v) {
        this.m_Severity = v;
    }

    public Severity getSeverity() {
        return this.m_Severity;
    }

    public void addParticipatingClass(OWLClass c) {
        this.m_ParticipatingClasses.add(c);
    }

    public void addAllParticipatingClasses(Collection<? extends OWLClass> c) {
        this.m_ParticipatingClasses.addAll(c);
    }

    public Set<OWLClass> getParticipatingClasses() {
        return this.m_ParticipatingClasses;
    }

    public void addParticipatingAxiom(OWLClassAxiom a) {
        this.m_ParticipatingAxioms.add(a);
    }

    public void addAllParticipatingAxioms(Collection<? extends OWLClassAxiom> a) {
        this.m_ParticipatingAxioms.addAll(a);
    }

    public Set<OWLClassAxiom> getParticipatingAxioms() {
        return this.m_ParticipatingAxioms;
    }

    public OWLOntology getParticipatingOntology() {
        return this.m_ParticipatingOntology;
    }

    public boolean applyFix(OWLOntologyManager manager) throws OWLOntologyChangeException {
        return this.m_LintFixer != null && this.m_LintFixer.apply(manager, this.m_ParticipatingOntology);
    }

    public String toString() {
        return new SimpleLintFormat().format(this);
    }
}

