/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena.graph.converter;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.graph.converter.TripleAdder;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.output.ATermBaseVisitor;
import org.mindswap.pellet.output.ATermVisitor;
import org.mindswap.pellet.utils.ATermUtils;

public class ConceptConverter
extends ATermBaseVisitor
implements ATermVisitor {
    private Graph graph;
    private Node subj;
    private Node obj;

    public ConceptConverter(Graph g) {
        this.graph = g;
    }

    public Node convert(ATerm term) {
        return this.convert(term, null);
    }

    public Node convert(ATerm term, Node s) {
        Node prevSubj = this.subj;
        this.subj = s;
        this.obj = null;
        if (term instanceof ATermAppl) {
            this.visit((ATermAppl)term);
        } else if (term instanceof ATermInt) {
            this.obj = Node.createLiteral((String)term.toString(), null, (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
        } else {
            throw new IllegalArgumentException(term.toString());
        }
        this.subj = prevSubj;
        return this.obj;
    }

    public Node getResult() {
        return this.obj;
    }

    public void visitTerm(ATermAppl term) {
        this.obj = JenaUtils.makeGraphNode(term);
    }

    private void createConcept(Property p) {
        this.createBooleanType(p, OWL.Class);
    }

    private void createDatatype(Property p) {
        this.createBooleanType(p, RDFS.Datatype);
    }

    private void createBooleanType(Property p, Resource type) {
        if (this.subj != null) {
            TripleAdder.add(this.graph, this.subj, (Resource)p, this.obj);
        } else {
            Node c = Node.createAnon();
            TripleAdder.add(this.graph, c, (Resource)p, this.obj);
            this.obj = c;
        }
    }

    public void visitAnd(ATermAppl term) {
        this.visitList((ATermList)term.getArgument(0));
        this.createConcept(OWL.intersectionOf);
    }

    public void visitOr(ATermAppl term) {
        this.visitList((ATermList)term.getArgument(0));
        this.createConcept(OWL.unionOf);
    }

    public void visitNot(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        this.createConcept(OWL.complementOf);
    }

    private Node createQualifiedRestriction(ATermAppl term, Property restrType) {
        Node restr = this.createRestriction(term, restrType);
        Node qual = this.convert(term.getArgument(2));
        if (!ATermUtils.isTop((ATermAppl)term.getArgument(2))) {
            TripleAdder.add(this.graph, restr, (Resource)OWL2.onClass, qual);
        }
        this.obj = restr;
        return restr;
    }

    private Node createRestriction(ATermAppl term, Property restrType) {
        Node restr = Node.createAnon();
        Node prop = this.convert(term.getArgument(0));
        Node val = this.convert(term.getArgument(1));
        TripleAdder.add(this.graph, restr, (Resource)RDF.type, (RDFNode)OWL.Restriction);
        TripleAdder.add(this.graph, restr, (Resource)OWL.onProperty, prop);
        TripleAdder.add(this.graph, restr, (Resource)restrType, val);
        this.obj = restr;
        return restr;
    }

    public void visitSome(ATermAppl term) {
        this.createRestriction(term, OWL.someValuesFrom);
    }

    public void visitAll(ATermAppl term) {
        this.createRestriction(term, OWL.allValuesFrom);
    }

    public void visitMin(ATermAppl term) {
        this.createQualifiedRestriction(term, OWL.minCardinality);
    }

    public void visitCard(ATermAppl term) {
        this.createQualifiedRestriction(term, OWL.cardinality);
    }

    public void visitMax(ATermAppl term) {
        this.createQualifiedRestriction(term, OWL.maxCardinality);
    }

    public void visitHasValue(ATermAppl term) {
        this.createRestriction(term, OWL.hasValue);
    }

    public void visitValue(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
    }

    public void visitSelf(ATermAppl term) {
        Node restr = Node.createAnon();
        Node prop = this.convert(term.getArgument(0));
        TripleAdder.add(this.graph, restr, (Resource)RDF.type, (RDFNode)OWL.Restriction);
        TripleAdder.add(this.graph, restr, (Resource)OWL.onProperty, prop);
        TripleAdder.add(this.graph, restr, (Resource)OWL2.hasSelf, (RDFNode)JenaUtils.XSD_BOOLEAN_TRUE);
        this.obj = restr;
    }

    public void visitOneOf(ATermAppl term) {
        ATermList list = (ATermList)term.getArgument(0);
        this.visitList(list);
        if (list.isEmpty() || !ATermUtils.isLiteral((ATermAppl)((ATermAppl)list.getFirst()).getArgument(0))) {
            this.createConcept(OWL.oneOf);
        } else {
            this.createDatatype(OWL.oneOf);
        }
    }

    public void visitLiteral(ATermAppl term) {
        this.obj = JenaUtils.makeGraphNode(term);
    }

    public void visitList(ATermList list) {
        if (list.isEmpty()) {
            this.obj = RDF.nil.asNode();
        } else {
            Node rdfList = Node.createAnon();
            Node first = this.convert(list.getFirst());
            TripleAdder.add(this.graph, rdfList, (Resource)RDF.first, first);
            this.visitList(list.getNext());
            TripleAdder.add(this.graph, rdfList, (Resource)RDF.rest, this.obj);
            this.obj = rdfList;
        }
    }

    public void visitInverse(ATermAppl term) {
        Node node = Node.createAnon();
        Node prop = this.convert(term.getArgument(0));
        TripleAdder.add(this.graph, node, (Resource)OWL.inverseOf, prop);
        this.obj = node;
    }

    public void visitRestrictedDatatype(ATermAppl dt) {
        Node def = Node.createAnon();
        TripleAdder.add(this.graph, def, (Resource)RDF.type, (RDFNode)RDFS.Datatype);
        TripleAdder.add(this.graph, def, (Resource)OWL2.onDatatype, JenaUtils.makeGraphNode((ATermAppl)dt.getArgument(0)));
        Node list = null;
        ATermList restrictions = (ATermList)dt.getArgument(1);
        while (!restrictions.isEmpty()) {
            ATermAppl facet = (ATermAppl)restrictions.getFirst();
            Node facetNode = Node.createAnon();
            TripleAdder.add(this.graph, facetNode, JenaUtils.makeGraphNode((ATermAppl)facet.getArgument(0)), JenaUtils.makeGraphNode((ATermAppl)facet.getArgument(1)));
            Node newList = Node.createAnon();
            TripleAdder.add(this.graph, newList, (Resource)RDF.first, facetNode);
            if (list != null) {
                TripleAdder.add(this.graph, list, (Resource)RDF.rest, newList);
            } else {
                TripleAdder.add(this.graph, def, (Resource)OWL2.withRestrictions, newList);
            }
            list = newList;
            restrictions = restrictions.getNext();
        }
        TripleAdder.add(this.graph, list, (Resource)RDF.rest, (RDFNode)RDF.nil);
        this.obj = def;
    }
}

