/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.owlapi;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.output.ATermBaseVisitor;
import org.mindswap.pellet.output.ATermVisitor;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLPropertyExpression;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.vocab.OWLRestrictedDataRangeFacetVocabulary;

public class ConceptConverter
extends ATermBaseVisitor
implements ATermVisitor {
    private KnowledgeBase kb;
    private OWLDataFactory factory;
    private OWLObject obj;
    private Set set;

    public ConceptConverter(KnowledgeBase kb, OWLDataFactory factory) {
        this.kb = kb;
        this.factory = factory;
    }

    public OWLObject convert(ATermAppl term) {
        this.obj = null;
        this.visit(term);
        return this.obj;
    }

    public OWLObject getResult() {
        return this.obj;
    }

    public void visitTerm(ATermAppl term) {
        this.obj = null;
        URI uri = null;
        uri = ATermUtils.isBnode(term) ? URI.create(((ATermAppl)term.getArgument(0)).getName()) : URI.create(term.getName());
        if (uri == null) {
            throw new NullPointerException("Could not resolve URI for term: URI is null");
        }
        if (term.equals(OWL_THING)) {
            this.obj = this.factory.getOWLThing();
        } else if (term.equals(OWL_NOTHING)) {
            this.obj = this.factory.getOWLNothing();
        }
        if (this.kb.isClass((ATerm)term)) {
            this.obj = this.factory.getOWLClass(uri);
        } else if (this.kb.isObjectProperty((ATerm)term)) {
            this.obj = this.factory.getOWLObjectProperty(uri);
        } else if (this.kb.isDatatypeProperty((ATerm)term)) {
            this.obj = this.factory.getOWLDataProperty(uri);
        } else if (this.kb.isIndividual((ATerm)term)) {
            this.obj = ATermUtils.isBnode(term) ? this.factory.getOWLAnonymousIndividual(uri) : this.factory.getOWLIndividual(uri);
        } else if (this.kb.isDatatype(term)) {
            this.obj = this.factory.getOWLDataType(uri);
        }
        if (this.obj == null) {
            throw new InternalReasonerException("Ontology does not contain: " + term);
        }
    }

    public void visitAnd(ATermAppl term) {
        this.visitList((ATermList)term.getArgument(0));
        this.obj = this.factory.getOWLObjectIntersectionOf(this.set);
    }

    public void visitOr(ATermAppl term) {
        this.visitList((ATermList)term.getArgument(0));
        this.obj = this.factory.getOWLObjectUnionOf(this.set);
    }

    public void visitNot(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        if (this.obj instanceof OWLDescription) {
            this.obj = this.factory.getOWLObjectComplementOf((OWLDescription)this.obj);
        } else if (this.obj instanceof OWLDataRange) {
            this.obj = this.factory.getOWLDataComplementOf((OWLDataRange)this.obj);
        }
    }

    public void visitSome(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLPropertyExpression prop = (OWLPropertyExpression)this.obj;
        this.visit((ATermAppl)term.getArgument(1));
        if (prop instanceof OWLObjectPropertyExpression) {
            OWLDescription desc = (OWLDescription)this.obj;
            this.obj = this.factory.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)prop, desc);
        } else {
            OWLDataRange datatype = (OWLDataRange)this.obj;
            this.obj = this.factory.getOWLDataSomeRestriction((OWLDataPropertyExpression)((OWLDataProperty)prop), datatype);
        }
    }

    public void visitAll(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLPropertyExpression prop = (OWLPropertyExpression)this.obj;
        this.visit((ATermAppl)term.getArgument(1));
        if (prop instanceof OWLObjectPropertyExpression) {
            OWLDescription desc = (OWLDescription)this.obj;
            this.obj = this.factory.getOWLObjectAllRestriction((OWLObjectPropertyExpression)prop, desc);
        } else {
            OWLDataRange datatype = (OWLDataRange)this.obj;
            this.obj = this.factory.getOWLDataAllRestriction((OWLDataPropertyExpression)((OWLDataProperty)prop), datatype);
        }
    }

    public void visitMin(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLPropertyExpression prop = (OWLPropertyExpression)this.obj;
        int cardinality = Integer.parseInt(term.getArgument(1).toString());
        if (prop instanceof OWLObjectPropertyExpression) {
            OWLDescription c = (OWLDescription)this.convert((ATermAppl)term.getArgument(2));
            this.obj = this.factory.getOWLObjectMinCardinalityRestriction((OWLObjectPropertyExpression)prop, cardinality, c);
        } else {
            OWLDataRange d = (OWLDataRange)this.convert((ATermAppl)term.getArgument(2));
            this.obj = this.factory.getOWLDataMinCardinalityRestriction((OWLDataPropertyExpression)((OWLDataProperty)prop), cardinality, d);
        }
    }

    public void visitCard(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLPropertyExpression prop = (OWLPropertyExpression)this.obj;
        int cardinality = Integer.parseInt(term.getArgument(1).toString());
        if (prop instanceof OWLObjectPropertyExpression) {
            OWLDescription c = (OWLDescription)this.convert((ATermAppl)term.getArgument(2));
            this.obj = this.factory.getOWLObjectExactCardinalityRestriction((OWLObjectPropertyExpression)prop, cardinality, c);
        } else {
            OWLDataRange d = (OWLDataRange)this.convert((ATermAppl)term.getArgument(2));
            this.obj = this.factory.getOWLDataExactCardinalityRestriction((OWLDataPropertyExpression)((OWLDataProperty)prop), cardinality, d);
        }
    }

    public void visitMax(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLPropertyExpression prop = (OWLPropertyExpression)this.obj;
        int cardinality = Integer.parseInt(term.getArgument(1).toString());
        if (prop instanceof OWLObjectPropertyExpression) {
            OWLDescription c = (OWLDescription)this.convert((ATermAppl)term.getArgument(2));
            this.obj = this.factory.getOWLObjectMaxCardinalityRestriction((OWLObjectPropertyExpression)prop, cardinality, c);
        } else {
            OWLDataRange d = (OWLDataRange)this.convert((ATermAppl)term.getArgument(2));
            this.obj = this.factory.getOWLDataMaxCardinalityRestriction((OWLDataPropertyExpression)((OWLDataProperty)prop), cardinality, d);
        }
    }

    public void visitHasValue(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLPropertyExpression prop = (OWLPropertyExpression)this.obj;
        this.visit((ATermAppl)((ATermAppl)term.getArgument(1)).getArgument(0));
        if (prop instanceof OWLObjectProperty) {
            OWLIndividual ind = (OWLIndividual)this.obj;
            this.obj = this.factory.getOWLObjectValueRestriction((OWLObjectPropertyExpression)prop, ind);
        } else {
            OWLConstant dataVal = (OWLConstant)this.obj;
            this.obj = this.factory.getOWLDataValueRestriction((OWLDataPropertyExpression)((OWLDataProperty)prop), dataVal);
        }
    }

    public void visitValue(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        this.obj = this.obj instanceof OWLIndividual ? this.factory.getOWLObjectOneOf(new OWLIndividual[]{(OWLIndividual)this.obj}) : this.factory.getOWLDataOneOf(new OWLConstant[]{(OWLConstant)this.obj});
    }

    public void visitSelf(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        this.obj = this.factory.getOWLObjectSelfRestriction(prop);
    }

    public void visitOneOf(ATermAppl term) {
        this.set = new HashSet();
        ATermList list = (ATermList)term.getArgument(0);
        while (!list.isEmpty()) {
            ATermAppl first = (ATermAppl)list.getFirst();
            this.visit((ATermAppl)first.getArgument(0));
            if (this.obj == null) {
                return;
            }
            this.set.add(this.obj);
            list = list.getNext();
        }
        this.obj = this.set.isEmpty() || this.set.iterator().next() instanceof OWLIndividual ? this.factory.getOWLObjectOneOf(this.set) : this.factory.getOWLDataOneOf(this.set);
    }

    public void visitLiteral(ATermAppl term) {
        String lexValue = ((ATermAppl)term.getArgument(0)).toString();
        ATermAppl lang = (ATermAppl)term.getArgument(1);
        ATermAppl dtype = (ATermAppl)term.getArgument(2);
        if (!dtype.equals(ATermUtils.EMPTY)) {
            URI dtypeURI = URI.create(dtype.toString());
            OWLDataType datatype = this.factory.getOWLDataType(dtypeURI);
            this.obj = this.factory.getOWLTypedConstant(lexValue, datatype);
        } else {
            this.obj = !lang.equals(ATermUtils.EMPTY) ? this.factory.getOWLUntypedConstant(lexValue, lang.toString()) : this.factory.getOWLUntypedConstant(lexValue);
        }
    }

    public void visitList(ATermList list) {
        this.set = null;
        HashSet<OWLObject> elements = new HashSet<OWLObject>();
        while (!list.isEmpty()) {
            ATermAppl term = (ATermAppl)list.getFirst();
            this.visit(term);
            if (this.obj == null) {
                return;
            }
            elements.add(this.obj);
            list = list.getNext();
        }
        this.set = elements;
    }

    public void visitInverse(ATermAppl p) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.convert((ATermAppl)p.getArgument(0));
        this.obj = this.factory.getOWLObjectPropertyInverse(prop);
    }

    public void visitRestrictedDatatype(ATermAppl dt) {
        OWLDataType baseDatatype = this.factory.getOWLDataType(URI.create(((ATermAppl)dt.getArgument(0)).getName()));
        HashSet<OWLDataRangeFacetRestriction> restrictions = new HashSet<OWLDataRangeFacetRestriction>();
        ATermList list = (ATermList)dt.getArgument(1);
        while (!list.isEmpty()) {
            ATermAppl facet = (ATermAppl)list.getFirst();
            String facetName = ((ATermAppl)facet.getArgument(0)).getName();
            ATermAppl facetValue = (ATermAppl)facet.getArgument(1);
            this.visitLiteral(facetValue);
            restrictions.add(this.factory.getOWLDataRangeFacetRestriction(OWLRestrictedDataRangeFacetVocabulary.getFacet((URI)URI.create(facetName)), (OWLTypedConstant)this.obj));
            list = list.getNext();
        }
        this.obj = this.factory.getOWLDataRangeRestriction((OWLDataRange)baseDatatype, restrictions);
    }
}

