/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryPattern;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SizeEstimate;

public class QueryCost {
    private KnowledgeBase kb;
    private SizeEstimate estimate;
    private List patterns;
    public static double costIR = 5.0;
    public static double costIC = 1.0;
    public static double costRR = 2.0;
    public static double costRC = 1.0;

    public QueryCost(KnowledgeBase kb) {
        this.kb = kb;
        this.estimate = kb.getSizeEstimate();
    }

    public double estimateCost(Query query) {
        return this.estimateCost(query.getQueryPatterns());
    }

    public double estimateCost(List patterns) {
        this.patterns = patterns;
        if (this.notOptimal()) {
            return Double.MAX_VALUE;
        }
        return this.estimateCost(0, new HashSet());
    }

    protected boolean notOptimal() {
        boolean allSemiGround = true;
        HashSet<ATermAppl> bound = new HashSet<ATermAppl>();
        for (int i = 0; i < this.patterns.size(); ++i) {
            QueryPattern pattern = (QueryPattern)this.patterns.get(i);
            ATermAppl subj = pattern.getSubject();
            ATermAppl obj = pattern.getObject();
            if (pattern.isTypePattern()) {
                allSemiGround = false;
                if (ATermUtils.isVar(subj) && !bound.contains(subj) && i > 0) {
                    return true;
                }
            } else if (ATermUtils.isVar(subj) && ATermUtils.isVar(obj)) {
                allSemiGround = false;
                if (!bound.contains(subj) && !bound.contains(obj) && i > 0) {
                    return true;
                }
            } else if (ATermUtils.isVar(subj)) {
                if (!bound.contains(subj) && i > 0) {
                    return true;
                }
                if (!allSemiGround) {
                    return true;
                }
            } else if (ATermUtils.isVar(obj)) {
                if (!bound.contains(obj) && i > 0) {
                    return true;
                }
                if (!allSemiGround) {
                    return true;
                }
            }
            bound.add(pattern.getSubject());
            bound.add(pattern.getObject());
        }
        return false;
    }

    protected ATermAppl inv(ATermAppl pred) {
        return this.kb.getRBox().getRole((ATerm)pred).getInverse().getName();
    }

    protected double estimateCost(int index, Set bound) {
        if (this.patterns.size() <= index) {
            return 1.0;
        }
        QueryPattern pattern = (QueryPattern)this.patterns.get(index);
        ATermAppl subj = pattern.getSubject();
        ATermAppl pred = pattern.getPredicate();
        ATermAppl obj = pattern.getObject();
        double cost = -1.0;
        if (pattern.isTypePattern()) {
            if (bound.contains(subj)) {
                cost = costIC + this.estimateCost(index + 1, bound);
            } else {
                bound.add(subj);
                cost = costIR + (double)this.estimate.size(obj) * this.estimateCost(index + 1, bound);
            }
        } else if (bound.contains(subj) && bound.contains(obj)) {
            cost = costRC + this.estimateCost(index + 1, bound);
        } else if (bound.contains(subj)) {
            bound.add(obj);
            cost = costRR + this.estimate.avg(pred) * this.estimateCost(index + 1, bound);
        } else if (bound.contains(obj)) {
            bound.add(subj);
            cost = costRR + this.estimate.avg(this.inv(pred)) * this.estimateCost(index + 1, bound);
        } else {
            bound.add(subj);
            bound.add(obj);
            cost = costRR + (double)this.estimate.size(pred) * this.estimateCost(index + 1, bound);
        }
        return cost;
    }
}

